/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.modcluster.ContextHost;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterMessages;
import org.jboss.as.modcluster.ModClusterService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ModClusterStopContext
implements OperationStepHandler {
    static final ModClusterStopContext INSTANCE = new ModClusterStopContext();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ModClusterService.NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(ModClusterService.NAME);
                    final ModCluster modcluster = (ModCluster)controller.getValue();
                    ModClusterLogger.ROOT_LOGGER.debugf("stop-context: %s", operation);
                    final ContextHost contexthost = new ContextHost(operation);
                    try {
                        modcluster.stopContext(contexthost.webhost, contexthost.webcontext, contexthost.waittime);
                    }
                    catch (IllegalArgumentException e) {
                        throw new OperationFailedException(new ModelNode().set(ModClusterMessages.MESSAGES.ContextorHostNotFound(contexthost.webhost, contexthost.webcontext)));
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            modcluster.enableContext(contexthost.webhost, contexthost.webcontext);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

