/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.ConcreteAttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DefaultCheckersAndConverter;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.DynamicLoadProviderDefinition;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterDefinition;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.modcluster.ModClusterMessages;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.as.modcluster.ModClusterSubsystemXMLWriter;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ModClusterExtension
implements XMLStreamConstants,
Extension {
    public static final String SUBSYSTEM_NAME = "modcluster";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 3;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modcluster");
    static final PathElement CONFIGURATION_PATH = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");
    static final PathElement SSL_CONFIGURATION_PATH = PathElement.pathElement((String)"ssl", (String)"configuration");
    static final PathElement DYNAMIC_LOAD_PROVIDER_PATH = PathElement.pathElement((String)"dynamic-load-provider", (String)"configuration");
    static final PathElement LOAD_METRIC_PATH = PathElement.pathElement((String)"load-metric");
    static final PathElement CUSTOM_LOAD_METRIC_PATH = PathElement.pathElement((String)"custom-load-metric");
    private static final String RESOURCE_NAME = ModClusterExtension.class.getPackage().getName() + ".LocalDescriptions";

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModClusterExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        ModClusterLogger.ROOT_LOGGER.debugf("Activating Mod_cluster Extension", new Object[0]);
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 3, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new ModClusterDefinition(context.isRuntimeOnlyRegistrationValid()));
        ManagementResourceRegistration configuration = registration.registerSubModel((ResourceDefinition)new ModClusterConfigResourceDefinition());
        configuration.registerSubModel((ResourceDefinition)new ModClusterSSLResourceDefinition());
        ManagementResourceRegistration dynamicLoadProvider = configuration.registerSubModel((ResourceDefinition)DynamicLoadProviderDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)LoadMetricDefinition.INSTANCE);
        dynamicLoadProvider.registerSubModel((ResourceDefinition)CustomLoadMetricDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)new ModClusterSubsystemXMLWriter());
        if (context.isRegisterTransformers()) {
            ModClusterExtension.registerTransformers_1_2_0(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), namespace.getXMLReader());
        }
    }

    private static void registerTransformers_1_2_0(SubsystemRegistration subsystem) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder configurationBuilder = builder.addChildResource(CONFIGURATION_PATH);
        ResourceTransformationDescriptionBuilder dynamicLoadProvider = ((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)configurationBuilder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterConfigResourceDefinition.ADVERTISE, ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS, ModClusterConfigResourceDefinition.FLUSH_PACKETS, ModClusterConfigResourceDefinition.STICKY_SESSION, ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE, ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE, ModClusterConfigResourceDefinition.PING})).end().addChildResource(DYNAMIC_LOAD_PROVIDER_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{DynamicLoadProviderDefinition.DECAY, DynamicLoadProviderDefinition.HISTORY})).end();
        ((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)dynamicLoadProvider.addChildResource(CUSTOM_LOAD_METRIC_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{CustomLoadMetricDefinition.CLASS, LoadMetricDefinition.WEIGHT})).addRejectCheck((RejectAttributeChecker)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).setValueConverter((AttributeConverter)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).end();
        ((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)((ConcreteAttributeTransformationDescriptionBuilder)dynamicLoadProvider.addChildResource(LOAD_METRIC_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{LoadMetricDefinition.TYPE, LoadMetricDefinition.WEIGHT, LoadMetricDefinition.CAPACITY, LoadMetricDefinition.PROPERTY})).addRejectCheck((RejectAttributeChecker)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).setValueConverter((AttributeConverter)CapacityCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.CAPACITY})).addRejectCheck((RejectAttributeChecker)PropertyCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.PROPERTY})).setValueConverter((AttributeConverter)PropertyCheckerAndConverter.INSTANCE, new AttributeDefinition[]{LoadMetricDefinition.PROPERTY})).end();
        ((ConcreteAttributeTransformationDescriptionBuilder)configurationBuilder.addChildResource(SSL_CONFIGURATION_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{ModClusterSSLResourceDefinition.CIPHER_SUITE, ModClusterSSLResourceDefinition.KEY_ALIAS, ModClusterSSLResourceDefinition.PROTOCOL})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystem, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    private static class PropertyCheckerAndConverter
    extends DefaultCheckersAndConverter {
        private static final PropertyCheckerAndConverter INSTANCE = new PropertyCheckerAndConverter();

        private PropertyCheckerAndConverter() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ModClusterMessages.MESSAGES.propertyCanOnlyHaveOneEntry();
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return attributeValue.isDefined() && attributeValue.asPropertyList().size() > 1;
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            List list;
            if (attributeValue.isDefined() && (list = attributeValue.asPropertyList()).size() == 1) {
                attributeValue.set(((Property)list.get(0)).getName(), ((Property)list.get(0)).getValue().asString());
            }
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }
    }

    private static class CapacityCheckerAndConverter
    extends DefaultCheckersAndConverter {
        private static final CapacityCheckerAndConverter INSTANCE = new CapacityCheckerAndConverter();

        private CapacityCheckerAndConverter() {
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ModClusterMessages.MESSAGES.capacityIsExpressionOrGreaterThanIntegerMaxValue(attributes.get(LoadMetricDefinition.CAPACITY.getName()));
        }

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.getType() == ModelType.EXPRESSION) {
                return true;
            }
            Long converted = this.convert(attributeValue);
            return converted != null && converted > Integer.MAX_VALUE;
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            Long converted = this.convert(attributeValue);
            if (converted != null) {
                attributeValue.set((int)converted.longValue());
            }
        }

        protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            return false;
        }

        private Long convert(ModelNode attributeValue) {
            if (attributeValue.isDefined() && attributeValue.getType() != ModelType.EXPRESSION) {
                return Math.round(attributeValue.asDouble());
            }
            return null;
        }
    }
}

