/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

class ProtocolConfigurationFactory {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.create(RemotingOptions.TRANSMIT_WINDOW_SIZE, 32768, RemotingOptions.RECEIVE_WINDOW_SIZE, 32768);

    ProtocolConfigurationFactory() {
    }

    static ProtocolChannelClient.Configuration create(ModelControllerClientConfiguration client) throws URISyntaxException {
        ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
        configuration.setUri(new URI("remote://" + ProtocolConfigurationFactory.formatPossibleIpv6Address(client.getHost()) + ":" + client.getPort()));
        configuration.setOptionMap(DEFAULT_OPTIONS);
        long timeout = client.getConnectionTimeout();
        if (timeout > 0L) {
            configuration.setConnectionTimeout(timeout);
        }
        return configuration;
    }

    private static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }
}

