/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.protocol.StreamUtils;

public class CliLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        CommandContext cmdCtx = null;
        boolean gui = false;
        try {
            String argError = null;
            List<String> commands = null;
            File file = null;
            boolean connect = false;
            String defaultControllerHost = null;
            int defaultControllerPort = -1;
            boolean version = false;
            String username = null;
            char[] password = null;
            int connectionTimeout = -1;
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    value = arg.startsWith("--") ? arg.substring(13) : arg.substring(11);
                    String portStr = null;
                    int colonIndex = value.lastIndexOf(58);
                    if (colonIndex < 0) {
                        defaultControllerHost = value;
                    } else if (colonIndex == 0) {
                        portStr = value.substring(1);
                    } else {
                        int closeBracket = value.lastIndexOf(93);
                        boolean hasPort = closeBracket != -1 ? closeBracket <= colonIndex : true;
                        if (hasPort) {
                            defaultControllerHost = value.substring(0, colonIndex).trim();
                            portStr = value.substring(colonIndex + 1).trim();
                        } else {
                            defaultControllerHost = value;
                        }
                    }
                    if (portStr == null) continue;
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                        if (port < 0) {
                            argError = "The port must be a valid non-negative integer: '" + args + "'";
                            continue;
                        }
                        defaultControllerPort = port;
                    }
                    catch (NumberFormatException e) {
                        argError = "The port must be a valid non-negative integer: '" + arg + "'";
                    }
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if ("--gui".equals(arg)) {
                    gui = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = Util.splitCommands(value);
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = Collections.singletonList(value);
                    continue;
                }
                if (arg.startsWith("--user=")) {
                    username = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    continue;
                }
                if (arg.startsWith("--password=")) {
                    password = (arg.startsWith("--") ? arg.substring(11) : arg.substring(9)).toCharArray();
                    continue;
                }
                if (arg.startsWith("--timeout=")) {
                    if (connectionTimeout > 0) {
                        argError = "Duplicate argument '--timeout'";
                        break;
                    }
                    value = arg.substring(10);
                    try {
                        connectionTimeout = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (connectionTimeout > 0) continue;
                    argError = "The timeout must be a valid positive integer: '" + value + "'";
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = Collections.singletonList("help");
                    continue;
                }
                if (arg.startsWith("--properties=")) {
                    value = arg.substring(13);
                    File propertiesFile = new File(value);
                    if (!propertiesFile.exists()) {
                        argError = "File doesn't exist: " + propertiesFile.getAbsolutePath();
                        break;
                    }
                    Properties props = new Properties();
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(propertiesFile);
                        props.load(fis);
                    }
                    catch (FileNotFoundException e) {
                        argError = e.getLocalizedMessage();
                        break;
                    }
                    catch (IOException e) {
                        argError = "Failed to load properties from " + propertiesFile.getAbsolutePath() + ": " + e.getLocalizedMessage();
                        break;
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    for (Object prop : props.keySet()) {
                        SecurityActions.setSystemProperty((String)prop, (String)props.get(prop));
                    }
                    continue;
                }
                if (arg.startsWith("-D") || arg.equals("-XX:")) continue;
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time: " + arg;
                    break;
                }
                if (commands != null) {
                    argError = "Duplicate argument '--command'/'--commands'.";
                    break;
                }
                commands = Util.splitCommands(arg);
            }
            if (argError != null) {
                System.err.println(argError);
                exitCode = 1;
                return;
            }
            if (version) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, connect, connectionTimeout);
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, connect, connectionTimeout);
                CliLauncher.processFile(file, cmdCtx);
                return;
            }
            if (commands != null) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, connect, connectionTimeout);
                CliLauncher.processCommands(commands, cmdCtx);
                return;
            }
            if (gui) {
                cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, false, true, connectionTimeout);
                CliLauncher.processGui(cmdCtx);
                return;
            }
            cmdCtx = CliLauncher.initCommandContext(defaultControllerHost, defaultControllerPort, username, password, true, connect, connectionTimeout);
            cmdCtx.interact();
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 1;
        }
        finally {
            if (cmdCtx != null && cmdCtx.getExitCode() != 0) {
                exitCode = cmdCtx.getExitCode();
            }
            if (!gui) {
                System.exit(exitCode);
            }
        }
        System.exit(exitCode);
    }

    private static CommandContext initCommandContext(String defaultHost, int defaultPort, String username, char[] password, boolean initConsole, boolean connect, int connectionTimeout) throws CliInitializationException {
        CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(defaultHost, defaultPort, username, password, initConsole, connectionTimeout);
        if (connect) {
            try {
                cmdCtx.connectController();
            }
            catch (CommandLineException e) {
                throw new CliInitializationException("Failed to connect to the controller", e);
            }
        }
        return cmdCtx;
    }

    private static void processGui(CommandContext cmdCtx) {
        try {
            GuiMain.start(cmdCtx);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(List<String> commands, CommandContext cmdCtx) {
        try {
            for (int i = 0; cmdCtx.getExitCode() == 0 && i < commands.size() && !cmdCtx.isTerminated(); ++i) {
                cmdCtx.handleSafe(commands.get(i));
            }
        }
        finally {
            cmdCtx.terminateSession();
        }
    }

    private static void processFile(File file, CommandContext cmdCtx) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (cmdCtx.getExitCode() == 0 && !cmdCtx.isTerminated() && line != null) {
                cmdCtx.handleSafe(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                throw new IllegalStateException("Failed to process file '" + file.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                cmdCtx.terminateSession();
                throw throwable;
            }
        }
        StreamUtils.safeClose(reader);
        cmdCtx.terminateSession();
    }
}

