/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.ba;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.subordinate.SubordinateBACoordinator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.ba.BAParticipantRecoveryRecord;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryModule;

public class XTSBARecoveryManagerImple
extends XTSBARecoveryManager {
    private boolean participantRecoveryStarted = false;
    private boolean coordinatorRecoveryStarted = false;
    private boolean subordinateCoordinateRecoveryStarted = false;
    private boolean culledOrphanSubordinates = false;
    private HashMap<String, BAParticipantRecoveryRecord> recoveryMap = new HashMap();
    private HashMap<String, Uid> uidMap = new HashMap();
    private List<XTSBARecoveryModule> recoveryModules = new ArrayList<XTSBARecoveryModule>();
    private TxLog txLog;
    private static final String type = BAParticipantRecoveryRecord.type();

    public XTSBARecoveryManagerImple(TxLog txLog) {
        this.txLog = txLog;
    }

    @Override
    public void registerRecoveryModule(XTSBARecoveryModule module) throws NullPointerException {
        if (module == null) {
            throw new NullPointerException("XTSBARecoveryModule value must be non-null");
        }
        this.recoveryModules.add(module);
    }

    @Override
    public void unregisterRecoveryModule(XTSBARecoveryModule module) throws NoSuchElementException {
        if (!this.recoveryModules.remove(module)) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean writeParticipantRecoveryRecord(BAParticipantRecoveryRecord participantRecoveryRecord) {
        OutputObjectState oos = new OutputObjectState();
        try {
            oos.packString(participantRecoveryRecord.getClass().getCanonicalName());
        }
        catch (IOException ioe) {
            RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_1(participantRecoveryRecord.getId(), ioe);
            return false;
        }
        if (participantRecoveryRecord.saveState(oos)) {
            Uid uid = new Uid();
            try {
                this.txLog.write_committed(uid, type, oos);
                this.uidMap.put(participantRecoveryRecord.getId(), uid);
                return true;
            }
            catch (ObjectStoreException ose) {
                RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_1(participantRecoveryRecord.getId(), ose);
            }
        }
        return false;
    }

    @Override
    public boolean deleteParticipantRecoveryRecord(String id) {
        Uid uid = this.uidMap.get(id);
        if (uid != null) {
            try {
                this.txLog.remove_committed(uid, type);
                this.uidMap.remove(id);
                return true;
            }
            catch (ObjectStoreException ose) {
                RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_2(uid, id, ose);
            }
        }
        return false;
    }

    @Override
    public boolean isParticipantPresent(Uid uid) {
        return this.uidMap.get(uid) != null;
    }

    @Override
    public void addParticipantRecoveryRecord(Uid uid, BAParticipantRecoveryRecord participantRecoveryRecord) {
        String participantId = participantRecoveryRecord.getId();
        if (this.recoveryMap.get(participantId) == null && !participantRecoveryRecord.isActive()) {
            this.recoveryMap.put(participantId, participantRecoveryRecord);
            this.uidMap.put(participantId, uid);
        }
    }

    @Override
    public synchronized BAParticipantRecoveryRecord findParticipantRecoveryRecord(String id) {
        return this.recoveryMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverParticipants() {
        ArrayList<XTSBARecoveryModule> recoveryModulesCopy;
        this.setParticipantRecoveryStarted();
        List<XTSBARecoveryModule> list = this.recoveryModules;
        synchronized (list) {
            recoveryModulesCopy = new ArrayList<XTSBARecoveryModule>(this.recoveryModules);
        }
        Iterator<BAParticipantRecoveryRecord> participantIterator = this.iterator();
        while (participantIterator.hasNext()) {
            BAParticipantRecoveryRecord participantRecoveryRecord = participantIterator.next();
            if (participantRecoveryRecord.isActive()) {
                participantIterator.remove();
                continue;
            }
            Iterator moduleIterator = recoveryModulesCopy.iterator();
            boolean found = false;
            while (!found && moduleIterator.hasNext()) {
                XTSBARecoveryModule module = (XTSBARecoveryModule)moduleIterator.next();
                try {
                    if (!participantRecoveryRecord.restoreParticipant(module)) continue;
                    found = true;
                    participantRecoveryRecord.activate();
                    participantIterator.remove();
                }
                catch (Exception e) {
                    found = true;
                    RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_3(participantRecoveryRecord.getId(), e);
                }
            }
            if (found) continue;
            RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_4(participantRecoveryRecord.getId());
        }
        for (XTSBARecoveryModule recoveryModule : recoveryModulesCopy) {
            recoveryModule.endScan();
        }
        this.cullOrphanedSubordinates();
    }

    private void cullOrphanedSubordinates() {
        SubordinateBACoordinator[] coordinators;
        if (this.culledOrphanSubordinates || !this.subordinateCoordinateRecoveryStarted || !this.participantRecoveryStarted) {
            return;
        }
        this.culledOrphanSubordinates = true;
        for (SubordinateBACoordinator coordinator : coordinators = SubordinateBACoordinator.listRecoveredCoordinators()) {
            if (!coordinator.isOrphaned()) continue;
            RecoveryLogger.i18NLogger.warn_participant_ba_XTSBARecoveryModule_5(coordinator.get_uid());
            coordinator.cancel();
        }
    }

    private synchronized Iterator<BAParticipantRecoveryRecord> iterator() {
        return this.recoveryMap.values().iterator();
    }

    private synchronized void setParticipantRecoveryStarted() {
        this.participantRecoveryStarted = true;
    }

    @Override
    public synchronized boolean isParticipantRecoveryStarted() {
        return this.participantRecoveryStarted;
    }

    @Override
    public synchronized boolean isCoordinatorRecoveryStarted() {
        return this.coordinatorRecoveryStarted;
    }

    @Override
    public boolean isSubordinateCoordinatorRecoveryStarted() {
        return this.subordinateCoordinateRecoveryStarted;
    }

    @Override
    public synchronized void setCoordinatorRecoveryStarted() {
        this.coordinatorRecoveryStarted = true;
    }

    @Override
    public void setSubordinateCoordinatorRecoveryStarted() {
        this.subordinateCoordinateRecoveryStarted = true;
        this.cullOrphanedSubordinates();
    }
}

