/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ValueTypeCompleter
implements CommandLineCompleter {
    private static final List<ModelNode> BOOLEAN_LIST = new ArrayList<ModelNode>(2);
    private final ModelNode propDescr;

    public ValueTypeCompleter(ModelNode propDescr) {
        if (propDescr == null || !propDescr.isDefined()) {
            throw new IllegalArgumentException("property description is null or undefined.");
        }
        this.propDescr = propDescr;
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        ValueTypeCallbackHandler handler;
        try {
            handler = this.parse(buffer);
        }
        catch (CommandFormatException e) {
            return -1;
        }
        Collection<String> foundCandidates = handler.getCandidates(this.propDescr);
        if (foundCandidates.isEmpty()) {
            return -1;
        }
        candidates.addAll(foundCandidates);
        return handler.getCompletionIndex();
    }

    protected ValueTypeCallbackHandler parse(String line) throws CommandFormatException {
        ValueTypeCallbackHandler valueTypeHandler = new ValueTypeCallbackHandler(false);
        StateParser.parse(line, valueTypeHandler, InitialValueState.INSTANCE);
        return valueTypeHandler;
    }

    static {
        BOOLEAN_LIST.add(new ModelNode(Boolean.FALSE.booleanValue()));
        BOOLEAN_LIST.add(new ModelNode(Boolean.TRUE.booleanValue()));
    }

    public static class TextState
    extends ValueTypeCandidatesState {
        public static final String ID = "TEXT";
        public static final TextState INSTANCE = new TextState();

        public TextState() {
            super(ID);
            this.setHandleEntrance(true);
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            this.leaveState(',');
            this.leaveState('=');
            this.leaveState('}');
            this.leaveState(']');
        }
    }

    public static class EqualsState
    extends ValueTypeCandidatesState {
        public static final String ID = "EQ";
        public static final EqualsState INSTANCE = new EqualsState();

        public EqualsState() {
            super(ID);
            this.setIgnoreWhitespaces(true);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(TextState.INSTANCE);
                }
            });
            this.putHandler('>', GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
            this.enterState('{', StartObjectState.INSTANCE);
            this.enterState('[', StartListState.INSTANCE);
            this.addCandidate("{");
            this.addCandidate("[");
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class PropertyState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        public static final String ID = "PROP";
        public static final PropertyState INSTANCE = new PropertyState();
        private final Collection<String> candidates = new ArrayList<String>(2);

        public PropertyState() {
            super(ID);
            this.setHandleEntrance(true);
            this.putHandler('{', GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
            this.putHandler('[', GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            this.enterState('=', EqualsState.INSTANCE);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.leaveState();
                }
            });
            this.leaveState(',');
            this.leaveState(']');
            this.leaveState('}');
            this.candidates.add("=");
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            return this.candidates;
        }
    }

    public static class ListItemSeparatorState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        public static final String ID = "ITMSEP";
        public static final ListItemSeparatorState INSTANCE = new ListItemSeparatorState();

        public ListItemSeparatorState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!ctx.isEndOfContent()) {
                        ctx.advanceLocation(1);
                    }
                    ctx.leaveState();
                }
            });
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            return Collections.emptyList();
        }
    }

    public static class PropertyListState
    extends DefaultParsingState {
        public static final String ID = "PROPLIST";
        public static final PropertyListState INSTANCE = new PropertyListState();

        public PropertyListState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyState.INSTANCE);
                }
            });
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyState.INSTANCE);
                }
            });
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (ctx.isEndOfContent()) {
                        ctx.leaveState();
                        return;
                    }
                    char ch = ctx.getCharacter();
                    if (ch == '}' || ch == ']') {
                        if (ctx.getLocation() < ctx.getInput().length() - 1) {
                            ctx.advanceLocation(1);
                        }
                        ctx.leaveState();
                    } else {
                        PropertyListState.this.getHandler(ch).handle(ctx);
                    }
                }
            });
            this.enterState(',', ListItemSeparatorState.INSTANCE);
            this.setIgnoreWhitespaces(true);
        }
    }

    public static class StartListState
    extends DefaultParsingState {
        public static final String ID = "LST";
        private static StartListState INSTANCE = new StartListState();

        public StartListState() {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.setIgnoreWhitespaces(true);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!ctx.isEndOfContent()) {
                        ctx.advanceLocation(1);
                    }
                    ctx.leaveState();
                }
            });
        }
    }

    public static class StartObjectState
    extends DefaultParsingState {
        public static final String ID = "OBJ";
        private static StartObjectState INSTANCE = new StartObjectState();

        public StartObjectState() {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.setIgnoreWhitespaces(true);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.leaveState();
                }
            });
        }
    }

    public static class InitialValueState
    extends ValueTypeCandidatesState {
        public static final String ID = "INITVAL";
        public static final InitialValueState INSTANCE = new InitialValueState();

        public InitialValueState() {
            this(PropertyState.INSTANCE);
        }

        public InitialValueState(PropertyState prop) {
            super(ID);
            this.enterState('{', PropertyListState.INSTANCE);
            this.enterState('[', PropertyListState.INSTANCE);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.addCandidate("{");
            this.addCandidate("[");
            this.addCandidates(prop.getCandidates(null));
        }
    }

    static abstract class ValueTypeCandidatesState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        private final Collection<String> candidates = new ArrayList<String>();

        ValueTypeCandidatesState(String id) {
            super(id);
        }

        protected void addCandidate(String candidate) {
            this.candidates.add(candidate);
        }

        protected void addCandidates(Collection<String> candidates) {
            this.candidates.addAll(candidates);
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            if (this.candidates.isEmpty()) {
                return Collections.emptyList();
            }
            if (chunk == null || chunk.length() == 0) {
                return this.candidates;
            }
            ArrayList<String> filtered = new ArrayList<String>(this.candidates.size());
            for (String candidate : this.candidates) {
                if (!candidate.startsWith(chunk)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }

    public static interface ValueTypeCandidatesProvider {
        public Collection<String> getCandidates(String var1);
    }

    private final class ValueTypeCallbackHandler
    implements ParsingStateCallbackHandler {
        private static final String offsetStep = "  ";
        private final boolean logging;
        private int offset;
        private StringBuilder propBuf = new StringBuilder();
        private String prop;
        private List<String> propStack;
        private List<List<String>> mentionedPropStack = new ArrayList<List<String>>(2);
        private String lastEnteredState;
        private int lastStateIndex;
        private char lastStateChar;

        ValueTypeCallbackHandler(boolean logging) {
            this.logging = logging;
        }

        public int getCompletionIndex() {
            switch (this.lastStateChar) {
                case ',': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return this.lastStateIndex + 1;
                }
            }
            return this.lastStateIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Collection<String> getCandidates(ModelNode propDescr) {
            ArrayList<String> candidates;
            ArrayList<String> candidates2;
            if (propDescr == null || !propDescr.isDefined()) {
                return Collections.emptyList();
            }
            if (!propDescr.has("value-type")) {
                return Collections.emptyList();
            }
            ModelNode propType = propDescr.get("value-type");
            int mentionedIndex = 0;
            if (this.propStack != null && !this.propStack.isEmpty()) {
                mentionedIndex = this.propStack.size();
                for (int i = 0; i < this.propStack.size(); ++i) {
                    String propName = this.propStack.get(i);
                    if (!propType.has(propName)) {
                        return Collections.emptyList();
                    }
                    ModelNode propNode = propType.get(propName);
                    if (!propNode.has("value-type")) return Collections.emptyList();
                    propType = propNode.get("value-type");
                    if (propType.isDefined()) continue;
                    return Collections.emptyList();
                }
            }
            if (this.prop == null) {
                if (("PROP".equals(this.lastEnteredState) || "EQ".equals(this.lastEnteredState)) && this.propBuf.length() > 0) {
                    this.prop = this.propBuf.toString();
                    this.propBuf.setLength(0);
                } else {
                    List<String> mentionedProps;
                    if (this.lastEnteredState == null && propDescr.has("type")) {
                        ModelType type = propDescr.get("type").asType();
                        if (type.equals((Object)ModelType.OBJECT)) {
                            return Collections.singletonList("{");
                        }
                        if (type.equals((Object)ModelType.LIST)) {
                            return Collections.singletonList("[");
                        }
                    }
                    if ((mentionedProps = this.getMentionedProps(mentionedIndex)) != null && !mentionedProps.isEmpty() && !this.lastEnteredState.equals("ITMSEP")) return Collections.emptyList();
                    candidates2 = new ArrayList<String>(propType.keys());
                    if (mentionedProps != null) {
                        candidates2.removeAll(mentionedProps);
                    }
                    Collections.sort(candidates2);
                    return candidates2;
                }
            }
            if ("TEXT".equals(this.lastEnteredState)) {
                List allowed;
                if (!propType.has(this.prop)) {
                    return Collections.emptyList();
                }
                if (!(propType = propType.get(this.prop)).has("allowed")) {
                    if (!this.isBoolean(propType)) return Collections.emptyList();
                    allowed = BOOLEAN_LIST;
                } else {
                    allowed = propType.get("allowed").asList();
                }
                candidates2 = new ArrayList();
                if (this.propBuf.length() > 0) {
                    String value = this.propBuf.toString();
                    for (ModelNode candidate : allowed) {
                        String candidateStr = candidate.asString();
                        if (!candidateStr.startsWith(value)) continue;
                        candidates2.add(candidateStr);
                    }
                } else {
                    for (ModelNode candidate : allowed) {
                        candidates2.add(candidate.asString());
                    }
                }
                Collections.sort(candidates2);
                return candidates2;
            }
            if ("EQ".equals(this.lastEnteredState)) {
                List allowed;
                if (this.isBoolean(propType)) {
                    allowed = BOOLEAN_LIST;
                } else {
                    if (!propType.has(this.prop)) {
                        return Collections.emptyList();
                    }
                    if (!(propType = propType.get(this.prop)).has("allowed")) {
                        block47: {
                            if (propType.has("value-type")) {
                                ModelNode propValueType = propType.get("value-type");
                                try {
                                    propValueType.asType();
                                    return Collections.emptyList();
                                }
                                catch (IllegalArgumentException e) {
                                    if (!propType.has("type")) break block47;
                                    ModelType type = propType.get("type").asType();
                                    if (type.equals((Object)ModelType.OBJECT)) {
                                        return Collections.singletonList("{");
                                    }
                                    if (!type.equals((Object)ModelType.LIST)) break block47;
                                    return Collections.singletonList("[");
                                }
                            }
                        }
                        if (!this.isBoolean(propType)) return Collections.emptyList();
                        allowed = BOOLEAN_LIST;
                    } else {
                        allowed = propType.get("allowed").asList();
                    }
                }
                candidates = new ArrayList<String>();
                for (ModelNode candidate : allowed) {
                    candidates.add(candidate.asString());
                }
            } else if ("OBJ".equals(this.lastEnteredState) || "LST".equals(this.lastEnteredState)) {
                if (!propType.has(this.prop)) {
                    return Collections.emptyList();
                }
                if (!(propType = propType.get(this.prop)).has("value-type")) {
                    return Collections.emptyList();
                }
                ModelNode propValueType = propType.get("value-type");
                try {
                    propValueType.asType();
                    return Collections.emptyList();
                }
                catch (IllegalArgumentException e) {
                    candidates = new ArrayList(propValueType.keys());
                }
            } else {
                ModelNode propNode;
                if (this.propBuf.length() > 0) {
                    if (!propType.has(this.prop)) {
                        return Collections.emptyList();
                    }
                    propNode = propType.get(this.prop);
                    if (!propNode.has("value-type")) {
                        return Collections.emptyList();
                    }
                    propType = propNode.get("value-type");
                    this.prop = this.propBuf.toString();
                    ++mentionedIndex;
                } else if ("ITMSEP".equals(this.lastEnteredState)) {
                    if (!propType.has(this.prop)) {
                        return Collections.emptyList();
                    }
                    propNode = propType.get(this.prop);
                    if (!propNode.has("value-type")) {
                        return Collections.emptyList();
                    }
                    propType = propNode.get("value-type");
                    this.prop = null;
                    ++mentionedIndex;
                }
                candidates = new ArrayList();
                List<String> mentionedProps = this.getMentionedProps(mentionedIndex);
                for (String candidate : propType.keys()) {
                    if (this.prop != null && !candidate.startsWith(this.prop)) continue;
                    if (mentionedProps == null) {
                        candidates.add(candidate);
                        continue;
                    }
                    if (mentionedProps.contains(candidate)) continue;
                    candidates.add(candidate);
                }
            }
            Collections.sort(candidates);
            return candidates;
        }

        protected boolean isBoolean(ModelNode propType) {
            return propType.has("type") && propType.get("type").asType().equals((Object)ModelType.BOOLEAN);
        }

        protected List<String> getMentionedProps(int i) {
            List<String> mentionedProps = null;
            if (this.mentionedPropStack != null && i < this.mentionedPropStack.size()) {
                return this.mentionedPropStack.get(i);
            }
            return mentionedProps;
        }

        @Override
        public void enteredState(ParsingContext ctx) throws CommandFormatException {
            this.lastEnteredState = ctx.getState().getId();
            this.lastStateIndex = ctx.getLocation();
            this.lastStateChar = ctx.getCharacter();
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("entered '" + this.lastStateChar + "' " + this.lastEnteredState);
                System.out.println(buf.toString());
                if (this.lastEnteredState.equals("PROPLIST")) {
                    ++this.offset;
                }
            }
            if (this.lastEnteredState.equals("EQ")) {
                if (this.prop != null) {
                    if (this.propStack == null) {
                        this.propStack = new ArrayList<String>();
                    }
                    this.propStack.add(this.prop);
                }
                this.prop = this.propBuf.toString();
                this.propBuf.setLength(0);
            }
        }

        @Override
        public void leavingState(ParsingContext ctx) throws CommandFormatException {
            String id = ctx.getState().getId();
            if (this.logging) {
                if (id.equals("PROPLIST")) {
                    --this.offset;
                }
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("leaving '" + ctx.getCharacter() + "' " + id);
                System.out.println(buf.toString());
            }
            if (ctx.isEndOfContent()) {
                return;
            }
            if (id.equals("TEXT")) {
                this.propBuf.setLength(0);
            } else if (id.equals("PROP")) {
                if (this.propStack != null && this.propStack.size() > 0) {
                    List<String> mentionedProps;
                    int propStackSize = this.propStack.size();
                    String mentioned = this.prop;
                    this.prop = propStackSize == 0 ? null : this.propStack.remove(propStackSize - 1);
                    if (this.mentionedPropStack.size() < propStackSize + 1) {
                        List<List<String>> tmp = this.mentionedPropStack;
                        this.mentionedPropStack = new ArrayList<List<String>>(propStackSize + 1);
                        this.mentionedPropStack.addAll(tmp);
                        for (int i = this.mentionedPropStack.size(); i <= propStackSize; ++i) {
                            this.mentionedPropStack.add(null);
                        }
                    } else if (this.mentionedPropStack.size() > propStackSize + 1) {
                        this.mentionedPropStack.set(propStackSize + 1, null);
                    }
                    if ((mentionedProps = this.mentionedPropStack.get(propStackSize)) == null) {
                        mentionedProps = Collections.singletonList(mentioned);
                        this.mentionedPropStack.set(propStackSize, mentionedProps);
                    } else if (mentionedProps.size() == 1) {
                        List<String> tmp = mentionedProps;
                        mentionedProps = new ArrayList<String>();
                        mentionedProps.add(tmp.get(0));
                        mentionedProps.add(mentioned);
                        this.mentionedPropStack.set(propStackSize, mentionedProps);
                    } else {
                        mentionedProps.add(mentioned);
                    }
                } else {
                    List<String> mentionedProps;
                    if (this.mentionedPropStack.size() == 0) {
                        this.mentionedPropStack = new ArrayList<List<String>>(1);
                        this.mentionedPropStack.add(null);
                    }
                    if ((mentionedProps = this.mentionedPropStack.get(0)) == null) {
                        mentionedProps = Collections.singletonList(this.prop);
                        this.mentionedPropStack.set(0, mentionedProps);
                    } else if (mentionedProps.size() == 1) {
                        List<String> tmp = mentionedProps;
                        mentionedProps = new ArrayList<String>();
                        mentionedProps.add(tmp.get(0));
                        mentionedProps.add(this.prop);
                        this.mentionedPropStack.set(0, mentionedProps);
                    } else {
                        mentionedProps.add(this.prop);
                    }
                    this.prop = null;
                }
            }
        }

        @Override
        public void character(ParsingContext ctx) throws CommandFormatException {
            String id = ctx.getState().getId();
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("char '" + ctx.getCharacter() + "' " + id);
                System.out.println(buf.toString());
            }
            if (id.equals("PROP")) {
                char ch = ctx.getCharacter();
                if (ch != '\"' && !Character.isWhitespace(ch)) {
                    this.propBuf.append(ch);
                }
            } else if (id.equals("TEXT")) {
                this.propBuf.append(ctx.getCharacter());
            }
        }
    }
}

