/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.interfaces;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.apache.aries.proxy.InvocationListener;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.interfaces.ProxyClassLoader;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.EmptyVisitor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterfaceProxyGenerator
extends EmptyVisitor
implements Opcodes {
    private static final Map<Bundle, WeakReference<ProxyClassLoader>> cache = new WeakHashMap<Bundle, WeakReference<ProxyClassLoader>>(128);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getProxyInstance(Bundle client, Collection<Class<?>> ifaces, Callable<Object> dispatcher, InvocationListener listener) throws UnableToProxyException {
        ProxyClassLoader pcl = null;
        LinkedHashSet<Class<?>> classSet = InterfaceProxyGenerator.createSet(ifaces);
        Map<Bundle, WeakReference<ProxyClassLoader>> map = cache;
        synchronized (map) {
            WeakReference<ProxyClassLoader> ref = cache.get(client);
            if (ref != null) {
                pcl = (ProxyClassLoader)ref.get();
            }
            if (pcl != null && pcl.isInvalid(classSet)) {
                pcl = null;
                cache.remove(client);
            }
            if (pcl == null) {
                pcl = new ProxyClassLoader(client);
                cache.put(client, new WeakReference<ProxyClassLoader>(pcl));
            }
        }
        Class<?> c = pcl.createProxyClass(classSet);
        try {
            Constructor<?> con = c.getDeclaredConstructor(Callable.class, InvocationListener.class);
            con.setAccessible(true);
            return con.newInstance(dispatcher, listener);
        }
        catch (Exception e) {
            throw new UnableToProxyException(ifaces.iterator().next(), (Throwable)e);
        }
    }

    private static LinkedHashSet<Class<?>> createSet(Collection<Class<?>> ifaces) {
        LinkedHashSet classes = new LinkedHashSet();
        for (Class<?> c : ifaces) {
            if (!classes.add(c)) continue;
            classes.addAll(InterfaceProxyGenerator.createSet(Arrays.asList(c.getInterfaces())));
        }
        return classes;
    }
}

