/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.interfaces;

import java.io.IOException;
import java.util.Collection;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyAdapter;
import org.apache.aries.proxy.impl.common.OSGiFriendlyClassWriter;
import org.apache.aries.proxy.impl.interfaces.InterfaceUsingWovenProxyAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InterfaceCombiningClassAdapter
extends EmptyVisitor
implements Opcodes {
    private final Collection<Class<?>> interfaces;
    private final ClassWriter writer;
    private final InterfaceUsingWovenProxyAdapter adapter;
    private boolean done = false;

    InterfaceCombiningClassAdapter(String className, ClassLoader loader, Collection<Class<?>> interfaces) {
        this.writer = new OSGiFriendlyClassWriter(2, loader);
        this.adapter = new InterfaceUsingWovenProxyAdapter((ClassVisitor)this.writer, className, loader);
        this.interfaces = interfaces;
        String[] interfaceNames = new String[interfaces.size()];
        int i = 0;
        for (Class<?> in : interfaces) {
            interfaceNames[i] = Type.getType(in).getInternalName();
            ++i;
        }
        this.adapter.visit(50, 4097, className, null, AbstractWovenProxyAdapter.OBJECT_TYPE.getInternalName(), interfaceNames);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] arg4) {
        access &= 0xFFFFFBFF;
        if (this.adapter.getKnownMethods().contains(new Method(name, desc)) || "<clinit>".equals(name)) {
            return null;
        }
        return this.adapter.visitMethod(access, name, desc, null, arg4);
    }

    final byte[] generateBytes() throws UnableToProxyException {
        if (!this.done) {
            for (Class<?> c : this.interfaces) {
                this.adapter.setCurrentInterface(Type.getType(c));
                try {
                    AbstractWovenProxyAdapter.readClass(c, (ClassVisitor)this);
                }
                catch (IOException e) {
                    throw new UnableToProxyException(c, (Throwable)e);
                }
            }
            this.adapter.setCurrentInterface(Type.getType(Object.class));
            this.visitObjectMethods();
            this.adapter.visitEnd();
            this.done = true;
        }
        return this.writer.toByteArray();
    }

    private void visitObjectMethods() {
        MethodVisitor visitor = this.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        if (visitor != null) {
            visitor.visitEnd();
        }
        if ((visitor = this.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null)) != null) {
            visitor.visitEnd();
        }
        if ((visitor = this.visitMethod(1, "hashCode", "()I", null, null)) != null) {
            visitor.visitEnd();
        }
    }
}

