/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AbstractDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationRule;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.RejectedAttributesLogContext;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class TransformingDescription
extends AbstractDescription
implements TransformationDescription,
ResourceTransformer,
OperationTransformer {
    private final DiscardPolicy discardPolicy;
    private final List<TransformationDescription> children;
    private final Map<String, AttributeTransformationDescription> attributeTransformations;
    private final List<TransformationRule> rules = Collections.emptyList();
    private final Map<String, OperationTransformer> operationTransformers;
    private final ResourceTransformer resourceTransformer;
    static final ModelNode UNDEFINED = new ModelNode();

    public TransformingDescription(PathElement pathElement, PathAddressTransformer pathAddressTransformer, DiscardPolicy discardPolicy, ResourceTransformer resourceTransformer, Map<String, AttributeTransformationDescription> attributeTransformations, Map<String, OperationTransformer> operations, List<TransformationDescription> children) {
        super(pathElement, pathAddressTransformer);
        this.children = children;
        this.discardPolicy = discardPolicy;
        this.resourceTransformer = resourceTransformer;
        this.attributeTransformations = attributeTransformations;
        this.operationTransformers = operations;
        this.operationTransformers.put("write-attribute", new WriteAttributeTransformer());
        this.operationTransformers.put("undefine-attribute", new UndefineAttributeTransformer());
    }

    @Override
    public OperationTransformer getOperationTransformer() {
        return this;
    }

    @Override
    public ResourceTransformer getResourceTransformer() {
        return this;
    }

    @Override
    public Map<String, OperationTransformer> getOperationTransformers() {
        return Collections.unmodifiableMap(this.operationTransformers);
    }

    @Override
    public List<TransformationDescription> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext ctx, final PathAddress address, ModelNode operation) throws OperationFailedException {
        if (this.discardPolicy.discard(operation, address, ctx) == DiscardPolicy.DiscardType.SILENT) {
            return OperationTransformer.DISCARD.transformOperation(ctx, address, operation);
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedOperationContext context = new TransformationRule.ChainedOperationContext(ctx){

            @Override
            void invokeNext(OperationTransformer.TransformedOperation transformedOperation) throws OperationFailedException {
                this.recordTransformedOperation(transformedOperation);
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformOperation(transformedOperation.getTransformedOperation(), address, this);
                }
            }
        };
        AttributeTransformationRule first = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)first).transformOperation(operation, address, context);
        return context.createOp();
    }

    @Override
    public void transformResource(final ResourceTransformationContext ctx, final PathAddress address, Resource original) throws OperationFailedException {
        ModelNode originalModel = TransformationRule.cloneAndProtect(original.getModel());
        if (this.discardPolicy.discard(originalModel, address, ctx) == DiscardPolicy.DiscardType.SILENT) {
            return;
        }
        final Iterator<TransformationRule> iterator = this.rules.iterator();
        TransformationRule.ChainedResourceContext context = new TransformationRule.ChainedResourceContext(ctx){

            @Override
            void invokeNext(Resource resource) throws OperationFailedException {
                if (iterator.hasNext()) {
                    TransformationRule next = (TransformationRule)iterator.next();
                    next.transformResource(resource, address, this);
                } else {
                    TransformingDescription.this.resourceTransformer.transformResource(ctx, address, resource);
                }
            }
        };
        AttributeTransformationRule rule = new AttributeTransformationRule(this.attributeTransformations);
        ((TransformationRule)rule).transformResource(original, address, context);
    }

    private class UndefineAttributeTransformer
    implements OperationTransformer {
        private UndefineAttributeTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            String attributeName = operation.require("name").asString();
            AttributeTransformationDescription description = (AttributeTransformationDescription)TransformingDescription.this.attributeTransformations.get(attributeName);
            if (description == null) {
                return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
            }
            ModelNode originalModel = operation.clone();
            TransformationRule.AbstractChainedContext ctx = new TransformationRule.AbstractChainedContext(context){

                @Override
                protected TransformationContext getContext() {
                    return super.getContext();
                }
            };
            ctx.setImmutableResource(true);
            try {
                if (description.shouldDiscard(address, UNDEFINED, originalModel, ctx)) {
                    OperationTransformer.TransformedOperation transformedOperation = OperationTransformer.DISCARD.transformOperation(context, address, operation);
                    return transformedOperation;
                }
            }
            finally {
                ctx.setImmutableResource(false);
            }
            return new OperationTransformer.TransformedOperation(operation, DEFAULT_REJECTION_POLICY, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    private class WriteAttributeTransformer
    implements OperationTransformer {
        private WriteAttributeTransformer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            TransformationRule.AbstractChainedContext ctx;
            String attributeName = operation.require("name").asString();
            AttributeTransformationDescription description = (AttributeTransformationDescription)TransformingDescription.this.attributeTransformations.get(attributeName);
            if (description == null) {
                return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
            }
            ModelNode attributeValue = operation.get("value");
            if (description.shouldDiscard(address, attributeValue, operation, ctx = new TransformationRule.AbstractChainedContext(context){

                @Override
                protected TransformationContext getContext() {
                    return super.getContext();
                }
            })) {
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
            ctx.setImmutableResource(true);
            try {
                OperationRejectionPolicy policy;
                final RejectedAttributesLogContext rejectedAttributes = new RejectedAttributesLogContext(ctx, address, TransformationRule.cloneAndProtect(operation));
                description.rejectAttributes(rejectedAttributes, attributeValue);
                if (rejectedAttributes.hasRejections()) {
                    rejectedAttributes.errorOrWarn();
                    policy = new OperationRejectionPolicy(){

                        @Override
                        public boolean rejectOperation(ModelNode preparedResult) {
                            return true;
                        }

                        @Override
                        public String getFailureDescription() {
                            try {
                                return rejectedAttributes.errorOrWarn();
                            }
                            catch (OperationFailedException e) {
                                return null;
                            }
                        }
                    };
                } else {
                    policy = DEFAULT_REJECTION_POLICY;
                }
                description.convertValue(address, attributeValue, TransformationRule.cloneAndProtect(operation), ctx);
                String newName = description.getNewName();
                if (newName != null) {
                    operation.get("name").set(newName);
                }
                OperationTransformer.TransformedOperation transformedOperation = new OperationTransformer.TransformedOperation(operation, policy, OperationResultTransformer.ORIGINAL_RESULT);
                return transformedOperation;
            }
            finally {
                ctx.setImmutableResource(false);
            }
        }
    }
}

