/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AbstractTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.ConcreteAttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardDefinition;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.DiscardTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilderImpl;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformingDescription;

class ResourceTransformationDescriptionBuilderImpl
extends AbstractTransformationDescriptionBuilder
implements ResourceTransformationDescriptionBuilder {
    private DiscardPolicy discardPolicy = DiscardPolicy.NEVER;
    private final AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry = new AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry();

    protected ResourceTransformationDescriptionBuilderImpl(PathElement pathElement) {
        this(pathElement, PathAddressTransformer.DEFAULT);
    }

    protected ResourceTransformationDescriptionBuilderImpl(PathElement pathElement, PathAddressTransformer pathAddressTransformer) {
        super(pathElement, pathAddressTransformer, ResourceTransformer.DEFAULT, OperationTransformer.DEFAULT);
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildResource(PathElement pathElement) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(pathElement);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildResource(ResourceDefinition definition) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(definition.getPathElement());
        this.children.add(builder);
        return builder;
    }

    @Override
    public DiscardTransformationDescriptionBuilder discardChildResource(PathElement pathElement) {
        DiscardTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createDiscardInstance(pathElement);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildRedirection(PathElement current, PathElement legacy) {
        PathAddressTransformer.BasicPathAddressTransformer transformation = new PathAddressTransformer.BasicPathAddressTransformer(legacy);
        return this.addChildRedirection(current, transformation);
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildRedirection(PathElement oldAddress, PathAddressTransformer pathAddressTransformer) {
        ResourceTransformationDescriptionBuilderImpl builder = new ResourceTransformationDescriptionBuilderImpl(oldAddress, pathAddressTransformer);
        this.children.add(builder);
        return builder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addChildBuilder(TransformationDescriptionBuilder builder) {
        this.children.add(builder);
        return this;
    }

    @Override
    public ResourceTransformationDescriptionBuilder setCustomResourceTransformer(ResourceTransformer resourceTransformer) {
        super.setResourceTransformer(resourceTransformer);
        return this;
    }

    @Override
    public TransformationDescription build() {
        if (this.discardPolicy == DiscardPolicy.ALWAYS) {
            return new DiscardDefinition(this.pathElement);
        }
        ArrayList rules = new ArrayList();
        Map<String, AttributeTransformationDescription> attributes = this.registry.buildAttributes();
        HashMap<String, OperationTransformer> operations = new HashMap<String, OperationTransformer>();
        for (Map.Entry entry : this.operationTransformers.entrySet()) {
            OperationTransformer transformer = ((AbstractTransformationDescriptionBuilder.OperationTransformationEntry)entry.getValue()).getOperationTransformer(this.registry);
            operations.put((String)entry.getKey(), transformer);
        }
        ArrayList<TransformationDescription> children = new ArrayList<TransformationDescription>();
        for (TransformationDescriptionBuilder builder : this.children) {
            children.add(builder.build());
        }
        return new TransformingDescription(this.pathElement, this.pathAddressTransformer, this.discardPolicy, this.resourceTransformer, attributes, operations, children);
    }

    @Override
    public OperationTransformationOverrideBuilder addOperationTransformationOverride(String operationName) {
        final OperationTransformationOverrideBuilderImpl transformationBuilder = new OperationTransformationOverrideBuilderImpl(this);
        this.addOperationTransformerEntry(operationName, new AbstractTransformationDescriptionBuilder.OperationTransformationEntry(){

            @Override
            OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
                return transformationBuilder.createTransformer(resourceRegistry);
            }
        });
        return transformationBuilder;
    }

    @Override
    public ResourceTransformationDescriptionBuilder addRawOperationTransformationOverride(String operationName, final OperationTransformer operationTransformer) {
        this.addOperationTransformerEntry(operationName, new AbstractTransformationDescriptionBuilder.OperationTransformationEntry(){

            @Override
            OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
                return operationTransformer;
            }
        });
        return this;
    }

    @Override
    public ConcreteAttributeTransformationDescriptionBuilder getAttributeBuilder() {
        return new ConcreteAttributeTransformationDescriptionBuilder(this, this.registry);
    }
}

