/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.Collections;
import java.util.Iterator;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.AttributeTransformationRule;
import org.jboss.as.controller.transform.description.DiscardPolicy;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class OperationTransformationOverrideBuilderImpl
extends AttributeTransformationDescriptionBuilderImpl<OperationTransformationOverrideBuilder>
implements OperationTransformationOverrideBuilder {
    private boolean inherit = false;
    private DiscardPolicy discardPolicy = DiscardPolicy.NEVER;
    private OperationTransformer transformer = OperationTransformer.DEFAULT;
    private String newName;

    protected OperationTransformationOverrideBuilderImpl(ResourceTransformationDescriptionBuilder builder) {
        super(builder, new AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry());
    }

    @Override
    public OperationTransformationOverrideBuilder inheritResourceAttributeDefinitions() {
        this.inherit = true;
        return this;
    }

    @Override
    public OperationTransformationOverrideBuilder setCustomOperationTransformer(OperationTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    @Override
    public OperationTransformationOverrideBuilder rename(String newName) {
        this.newName = newName;
        return this;
    }

    protected OperationTransformer createTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
        AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry registry = this.resultingRegistry(resourceRegistry);
        final AttributeTransformationRule first = new AttributeTransformationRule(registry.buildAttributes());
        return new OperationTransformer(){

            @Override
            public OperationTransformer.TransformedOperation transformOperation(TransformationContext ctx, final PathAddress address, ModelNode operation) throws OperationFailedException {
                DiscardPolicy.DiscardType type = OperationTransformationOverrideBuilderImpl.this.discardPolicy.discard(operation, address, ctx);
                if (type == DiscardPolicy.DiscardType.SILENT) {
                    return OperationTransformer.DISCARD.transformOperation(ctx, address, operation);
                }
                final Iterator iterator = Collections.emptyList().iterator();
                ModelNode originalModel = TransformationRule.cloneAndProtect(operation);
                TransformationRule.ChainedOperationContext context = new TransformationRule.ChainedOperationContext(ctx){

                    @Override
                    void invokeNext(OperationTransformer.TransformedOperation transformedOperation) throws OperationFailedException {
                        this.recordTransformedOperation(transformedOperation);
                        if (iterator.hasNext()) {
                            TransformationRule next = (TransformationRule)iterator.next();
                            next.transformOperation(transformedOperation.getTransformedOperation(), address, this);
                        } else {
                            if (OperationTransformationOverrideBuilderImpl.this.newName != null) {
                                transformedOperation.getTransformedOperation().get("operation").set(OperationTransformationOverrideBuilderImpl.this.newName);
                            }
                            TransformationContext ctx = this.getContext();
                            this.recordTransformedOperation(OperationTransformationOverrideBuilderImpl.this.transformer.transformOperation(ctx, address, transformedOperation.getTransformedOperation()));
                        }
                    }
                };
                operation.get("address").set(address.toModelNode());
                first.transformOperation(operation, address, context);
                return context.createOp();
            }
        };
    }

    protected AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resultingRegistry(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
        AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry local = this.getLocalRegistry();
        if (this.inherit) {
            return AttributeTransformationDescriptionBuilderImpl.mergeRegistries(resourceRegistry, local);
        }
        return local;
    }

    @Override
    protected OperationTransformationOverrideBuilder thisBuilder() {
        return this;
    }
}

