/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AbstractDescription;
import org.jboss.as.controller.transform.description.AbstractTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilderImpl;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;

public final class ExplicitTransformationDescriptionBuilder
extends AbstractTransformationDescriptionBuilder
implements TransformationDescriptionBuilder {
    public ExplicitTransformationDescriptionBuilder(PathElement pathElement) {
        super(pathElement, PathAddressTransformer.DEFAULT, ResourceTransformer.DEFAULT, OperationTransformer.DEFAULT);
    }

    public ExplicitTransformationDescriptionBuilder setTransformer(CombinedTransformer transformer) {
        this.resourceTransformer = transformer;
        this.operationTransformer = transformer;
        return this;
    }

    @Override
    public ExplicitTransformationDescriptionBuilder setResourceTransformer(ResourceTransformer resourceTransformer) {
        this.resourceTransformer = resourceTransformer;
        return this;
    }

    public ExplicitTransformationDescriptionBuilder setOperationTransformer(OperationTransformer operationTransformer) {
        this.operationTransformer = operationTransformer;
        return this;
    }

    public ExplicitTransformationDescriptionBuilder addOperationTransformation(String operationName, final OperationTransformer operationTransformer) {
        this.addOperationTransformerEntry(operationName, new AbstractTransformationDescriptionBuilder.OperationTransformationEntry(){

            @Override
            OperationTransformer getOperationTransformer(AttributeTransformationDescriptionBuilderImpl.AttributeTransformationDescriptionBuilderRegistry resourceRegistry) {
                return operationTransformer;
            }
        });
        return this;
    }

    @Override
    public TransformationDescription build() {
        final HashMap operations = new HashMap();
        for (Map.Entry entry : this.operationTransformers.entrySet()) {
            operations.put(entry.getKey(), ((AbstractTransformationDescriptionBuilder.OperationTransformationEntry)entry.getValue()).getOperationTransformer(null));
        }
        final ArrayList<TransformationDescription> childDescriptions = new ArrayList<TransformationDescription>();
        for (TransformationDescriptionBuilder builder : this.children) {
            childDescriptions.add(builder.build());
        }
        return new AbstractDescription(this.pathElement, this.pathAddressTransformer){

            @Override
            public OperationTransformer getOperationTransformer() {
                return ExplicitTransformationDescriptionBuilder.this.operationTransformer;
            }

            @Override
            public ResourceTransformer getResourceTransformer() {
                return ExplicitTransformationDescriptionBuilder.this.resourceTransformer;
            }

            @Override
            public Map<String, OperationTransformer> getOperationTransformers() {
                return Collections.unmodifiableMap(operations);
            }

            @Override
            public List<TransformationDescription> getChildren() {
                return Collections.unmodifiableList(childDescriptions);
            }
        };
    }
}

