/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.RejectedAttributesLogContext;
import org.jboss.as.controller.transform.description.TransformationRule;
import org.jboss.dmr.ModelNode;

class AttributeTransformationRule
extends TransformationRule {
    private final Map<String, AttributeTransformationDescription> descriptions;

    AttributeTransformationRule(Map<String, AttributeTransformationDescription> descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    void transformOperation(ModelNode operation, PathAddress address, TransformationRule.ChainedOperationContext context) throws OperationFailedException {
        OperationRejectionPolicy policy;
        ModelNode transformed = operation.clone();
        final RejectedAttributesLogContext rejectedAttributes = new RejectedAttributesLogContext(context, address, operation);
        this.doTransform(address, transformed, operation, context, rejectedAttributes);
        if (!rejectedAttributes.hasRejections()) {
            policy = OperationTransformer.DEFAULT_REJECTION_POLICY;
        } else {
            rejectedAttributes.errorOrWarn();
            policy = new OperationRejectionPolicy(){

                @Override
                public boolean rejectOperation(ModelNode preparedResult) {
                    return true;
                }

                @Override
                public String getFailureDescription() {
                    try {
                        return rejectedAttributes.errorOrWarn();
                    }
                    catch (OperationFailedException e) {
                        return null;
                    }
                }
            };
        }
        context.invokeNext(new OperationTransformer.TransformedOperation(transformed, policy, OperationResultTransformer.ORIGINAL_RESULT));
    }

    @Override
    void transformResource(Resource resource, PathAddress address, TransformationRule.ChainedResourceContext context) throws OperationFailedException {
        ModelNode model = resource.getModel();
        RejectedAttributesLogContext rejectedAttributes = new RejectedAttributesLogContext(context, address, null);
        this.doTransform(address, model, null, context, rejectedAttributes);
        if (rejectedAttributes.hasRejections()) {
            rejectedAttributes.errorOrWarn();
        }
        context.invokeNext(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransform(PathAddress address, ModelNode modelOrOp, ModelNode operation, TransformationRule.AbstractChainedContext context, RejectedAttributesLogContext rejectedAttributes) {
        HashMap<String, String> renames = new HashMap<String, String>();
        HashMap<String, ModelNode> adds = new HashMap<String, ModelNode>();
        HashSet<String> newAttributes = new HashSet<String>();
        HashSet<String> discardedAttributes = new HashSet<String>();
        context.setImmutableResource(true);
        try {
            AttributeTransformationDescription description;
            String attributeName;
            for (Map.Entry<String, AttributeTransformationDescription> entry : this.descriptions.entrySet()) {
                AttributeTransformationDescription description2;
                attributeName = entry.getKey();
                boolean isNewAttribute = !modelOrOp.has(attributeName);
                ModelNode attributeValue = modelOrOp.get(attributeName);
                if (isNewAttribute) {
                    newAttributes.add(attributeName);
                }
                if ((description2 = entry.getValue()).shouldDiscard(address, TransformationRule.cloneAndProtect(attributeValue), operation, context)) {
                    modelOrOp.remove(attributeName);
                    discardedAttributes.add(attributeName);
                }
                context.getContext().getLogger().logWarning(address, discardedAttributes);
                String newName = description2.getNewName();
                if (newName == null) continue;
                renames.put(attributeName, newName);
            }
            for (Map.Entry<String, AttributeTransformationDescription> entry : this.descriptions.entrySet()) {
                attributeName = entry.getKey();
                if (discardedAttributes.contains(attributeName)) continue;
                ModelNode attributeValue = modelOrOp.get(attributeName);
                description = entry.getValue();
                description.rejectAttributes(rejectedAttributes, TransformationRule.cloneAndProtect(attributeValue));
            }
            for (Map.Entry<String, AttributeTransformationDescription> entry : this.descriptions.entrySet()) {
                attributeName = entry.getKey();
                if (discardedAttributes.contains(attributeName)) continue;
                ModelNode attributeValue = modelOrOp.get(attributeName);
                description = entry.getValue();
                description.convertValue(address, attributeValue, operation, context);
                if (!attributeValue.isDefined()) {
                    modelOrOp.remove(attributeName);
                    continue;
                }
                if (!newAttributes.contains(attributeName)) continue;
                adds.put(attributeName, attributeValue);
            }
        }
        finally {
            context.setImmutableResource(false);
        }
        if (renames.size() > 0) {
            for (Map.Entry<String, AttributeTransformationDescription> entry : renames.entrySet()) {
                ModelNode model;
                if (!modelOrOp.has(entry.getKey()) || !(model = modelOrOp.remove(entry.getKey())).isDefined()) continue;
                modelOrOp.get((String)((Object)entry.getValue())).set(model);
            }
        }
        if (adds.size() > 0) {
            for (Map.Entry<String, AttributeTransformationDescription> entry : adds.entrySet()) {
                modelOrOp.get(entry.getKey()).set((ModelNode)entry.getValue());
            }
        }
    }
}

