/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform.description;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescription;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;

abstract class AttributeTransformationDescriptionBuilderImpl<T extends AttributeTransformationDescriptionBuilder>
implements AttributeTransformationDescriptionBuilder<T> {
    private AttributeTransformationDescriptionBuilderRegistry registry;
    private ResourceTransformationDescriptionBuilder builder;

    AttributeTransformationDescriptionBuilderImpl(ResourceTransformationDescriptionBuilder builder, AttributeTransformationDescriptionBuilderRegistry registry) {
        this.builder = builder;
        this.registry = registry;
    }

    @Override
    public ResourceTransformationDescriptionBuilder end() {
        return this.builder;
    }

    @Override
    public T setDiscard(DiscardAttributeChecker discardChecker, AttributeDefinition ... discardedAttributes) {
        AttributeDefinition[] useDefs;
        for (AttributeDefinition attribute : useDefs = discardedAttributes) {
            String attrName = this.getAttributeName(attribute);
            this.registry.setDiscardedAttribute(discardChecker, attrName);
        }
        return this.thisBuilder();
    }

    @Override
    public T setDiscard(DiscardAttributeChecker discardChecker, String ... discardedAttributes) {
        String[] useDefs;
        for (String attrName : useDefs = discardedAttributes) {
            this.registry.setDiscardedAttribute(discardChecker, attrName);
        }
        return this.thisBuilder();
    }

    @Override
    public T addRejectCheck(RejectAttributeChecker checker, AttributeDefinition ... rejectedAttributes) {
        for (AttributeDefinition attribute : rejectedAttributes) {
            String attrName = this.getAttributeName(attribute);
            this.registry.addAttributeCheck(attrName, checker);
        }
        return this.thisBuilder();
    }

    @Override
    public T addRejectCheck(RejectAttributeChecker rejectChecker, String ... rejectedAttributes) {
        for (String attribute : rejectedAttributes) {
            this.registry.addAttributeCheck(attribute, rejectChecker);
        }
        return this.thisBuilder();
    }

    @Override
    public T addRejectChecks(List<RejectAttributeChecker> rejectCheckers, AttributeDefinition ... rejectedAttributes) {
        for (RejectAttributeChecker rejectChecker : rejectCheckers) {
            this.addRejectCheck(rejectChecker, rejectedAttributes);
        }
        return this.thisBuilder();
    }

    @Override
    public T addRejectChecks(List<RejectAttributeChecker> rejectCheckers, String ... rejectedAttributes) {
        for (RejectAttributeChecker rejectChecker : rejectCheckers) {
            this.addRejectCheck(rejectChecker, rejectedAttributes);
        }
        return this.thisBuilder();
    }

    @Override
    public T addRename(AttributeDefinition attributeName, String newName) {
        this.registry.addRenamedAttribute(this.getAttributeName(attributeName), newName);
        return this.thisBuilder();
    }

    @Override
    public T addRename(String attributeName, String newName) {
        this.registry.addRenamedAttribute(attributeName, newName);
        return this.thisBuilder();
    }

    @Override
    public T addRenames(Map<String, String> renames) {
        for (Map.Entry<String, String> rename : renames.entrySet()) {
            this.registry.addRenamedAttribute(rename.getKey(), rename.getValue());
        }
        return this.thisBuilder();
    }

    @Override
    public T setValueConverter(AttributeConverter attributeConverter, AttributeDefinition ... convertedAttributes) {
        for (AttributeDefinition attribute : convertedAttributes) {
            String attrName = this.getAttributeName(attribute);
            this.registry.addAttributeConverter(attrName, attributeConverter);
        }
        return this.thisBuilder();
    }

    @Override
    public T setValueConverter(AttributeConverter attributeConverter, String ... convertedAttributes) {
        for (String attribute : convertedAttributes) {
            this.registry.addAttributeConverter(attribute, attributeConverter);
        }
        return this.thisBuilder();
    }

    protected String getAttributeName(AttributeDefinition attr) {
        return attr.getName();
    }

    protected AttributeTransformationDescriptionBuilderRegistry getLocalRegistry() {
        return this.registry;
    }

    protected static AttributeTransformationDescriptionBuilderRegistry mergeRegistries(AttributeTransformationDescriptionBuilderRegistry one, AttributeTransformationDescriptionBuilderRegistry two) {
        AttributeTransformationDescriptionBuilderRegistry result = new AttributeTransformationDescriptionBuilderRegistry();
        result.allAttributes.addAll(one.allAttributes);
        result.allAttributes.addAll(two.allAttributes);
        result.attributeRestrictions.putAll(one.attributeRestrictions);
        result.attributeRestrictions.putAll(two.attributeRestrictions);
        result.discardedAttributes.putAll(one.discardedAttributes);
        result.discardedAttributes.putAll(two.discardedAttributes);
        result.renamedAttributes.putAll(one.renamedAttributes);
        result.renamedAttributes.putAll(two.renamedAttributes);
        result.convertedAttributes.putAll(one.convertedAttributes);
        result.convertedAttributes.putAll(two.convertedAttributes);
        return result;
    }

    protected abstract T thisBuilder();

    static class AttributeTransformationDescriptionBuilderRegistry {
        private final Set<String> allAttributes = new HashSet<String>();
        private final Map<String, List<RejectAttributeChecker>> attributeRestrictions = new HashMap<String, List<RejectAttributeChecker>>();
        private final Map<String, DiscardAttributeChecker> discardedAttributes = new HashMap<String, DiscardAttributeChecker>();
        private final Map<String, String> renamedAttributes = new HashMap<String, String>();
        private final Map<String, AttributeConverter> convertedAttributes = new HashMap<String, AttributeConverter>();

        AttributeTransformationDescriptionBuilderRegistry() {
        }

        void addToAllAttributes(String attributeName) {
            if (!this.allAttributes.contains(attributeName)) {
                this.allAttributes.add(attributeName);
            }
        }

        void addAttributeCheck(String attributeName, RejectAttributeChecker checker) {
            this.addToAllAttributes(attributeName);
            List<RejectAttributeChecker> checkers = this.attributeRestrictions.get(attributeName);
            if (checkers == null) {
                checkers = new ArrayList<RejectAttributeChecker>();
                this.attributeRestrictions.put(attributeName, checkers);
            }
            checkers.add(checker);
        }

        void setDiscardedAttribute(DiscardAttributeChecker discardChecker, String attributeName) {
            assert (discardChecker != null) : "Null discard checker";
            assert (!this.discardedAttributes.containsKey(attributeName)) : "Discard already set";
            this.addToAllAttributes(attributeName);
            this.discardedAttributes.put(attributeName, discardChecker);
        }

        void addRenamedAttribute(String attributeName, String newName) {
            assert (!this.renamedAttributes.containsKey(attributeName)) : "Rename already set";
            this.addToAllAttributes(attributeName);
            this.renamedAttributes.put(attributeName, newName);
        }

        void addAttributeConverter(String attributeName, AttributeConverter attributeConverter) {
            this.addToAllAttributes(attributeName);
            this.convertedAttributes.put(attributeName, attributeConverter);
        }

        Map<String, AttributeTransformationDescription> buildAttributes() {
            HashMap<String, AttributeTransformationDescription> attributes = new HashMap<String, AttributeTransformationDescription>();
            for (String name : this.allAttributes) {
                List<RejectAttributeChecker> checkers = this.attributeRestrictions.get(name);
                String newName = this.renamedAttributes.get(name);
                DiscardAttributeChecker discardChecker = this.discardedAttributes.get(name);
                attributes.put(name, new AttributeTransformationDescription(name, checkers, newName, discardChecker, this.convertedAttributes.get(name)));
            }
            return attributes;
        }
    }
}

