/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class TransformersLogger {
    private TransformationTarget target;
    private ControllerLogger logger;
    private List<LogEntry> messageQueue = Collections.synchronizedList(new LinkedList());
    private static final ConcurrentHashMap<String, TransformersLogger> loggers = new ConcurrentHashMap();

    private TransformersLogger(TransformationTarget target) {
        this.target = target;
        this.logger = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)(ControllerLogger.class.getPackage().getName() + ".transformer." + target.getHostName()));
    }

    public static TransformersLogger getLogger(TransformationTarget target) {
        String hostName = target.getHostName() == null ? "<unknown>" : target.getHostName();
        TransformersLogger result = loggers.get(hostName);
        if (result == null) {
            result = new TransformersLogger(target);
            TransformersLogger existing = loggers.putIfAbsent(hostName, result);
            result = existing == null ? result : existing;
        }
        return result;
    }

    private static String findSubsystemName(PathAddress pathAddress) {
        for (PathElement element : pathAddress) {
            if (!element.getKey().equals("subsystem")) continue;
            return element.getValue();
        }
        return null;
    }

    public void logWarning(PathAddress address, String attribute) {
        this.logWarning(address, null, null, attribute);
    }

    public void logWarning(PathAddress address, Set<String> attributes) {
        this.logWarning(address, null, null, attributes);
    }

    public void logWarning(PathAddress address, String message, String attribute) {
        this.logWarning(address, null, message, attribute);
    }

    public void logWarning(PathAddress address, String message, Set<String> attributes) {
        this.messageQueue.add(new LogEntry(address, null, message, attributes));
    }

    public void logWarning(PathAddress address, ModelNode operation, String message, String attribute) {
        this.messageQueue.add(new LogEntry(address, operation, message, new String[]{attribute}));
    }

    public void logWarning(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
        this.messageQueue.add(new LogEntry(address, operation, message, attributes));
    }

    public String getWarning(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
        return this.getMessage(new LogEntry(address, operation, message, attributes));
    }

    private String getWarning(PathAddress address, ModelNode operation, String message, String ... attributes) {
        return this.getMessage(new LogEntry(address, operation, message, attributes));
    }

    public String getWarning(PathAddress address, ModelNode operation, String ... attributes) {
        return this.getWarning(address, operation, (String)null, attributes);
    }

    public String getWarning(PathAddress address, ModelNode operation, Set<String> attributes) {
        return this.getMessage(new LogEntry(address, operation, null, attributes));
    }

    void flushLogQueue() {
        LinkedHashSet<String> problems = new LinkedHashSet<String>();
        for (LogEntry entry : this.messageQueue) {
            problems.add("\t\t" + this.getMessage(entry) + "\n");
        }
        if (!problems.isEmpty()) {
            this.logger.tranformationWarnings(this.target.getHostName(), problems);
        }
    }

    private String getMessage(LogEntry entry) {
        String msg;
        ModelVersion coreVersion = this.target.getVersion();
        String subsystemName = TransformersLogger.findSubsystemName(entry.address);
        ModelVersion usedVersion = subsystemName == null ? coreVersion : this.target.getSubsystemVersion(subsystemName);
        ModelNode operation = entry.operation;
        PathAddress address = entry.address;
        String string = msg = entry.message == null ? ControllerMessages.MESSAGES.attributesAreNotUnderstoodAndWillBeIgnored() : entry.message;
        if (operation == null) {
            if (subsystemName != null) {
                return ControllerMessages.MESSAGES.transformerLoggerSubsystemModelResourceTransformerAttributes(address, subsystemName, usedVersion, entry.attributes, msg);
            }
            return ControllerMessages.MESSAGES.transformerLoggerCoreModelResourceTransformerAttributes(address, usedVersion, entry.attributes, msg);
        }
        if (subsystemName != null) {
            return ControllerMessages.MESSAGES.transformerLoggerSubsystemModelOperationTransformerAttributes(operation, address, subsystemName, usedVersion, entry.attributes, msg);
        }
        return ControllerMessages.MESSAGES.transformerLoggerCoreModelOperationTransformerAttributes(operation, address, usedVersion, entry.attributes, msg);
    }

    private static class LogEntry {
        private PathAddress address;
        private ModelNode operation;
        private String message;
        private Set<String> attributes;

        private LogEntry(PathAddress address, ModelNode operation, String message, String ... attributes) {
            this.address = address;
            this.operation = operation;
            this.message = message;
            this.attributes = new TreeSet<String>(Arrays.asList(attributes));
        }

        private LogEntry(PathAddress address, ModelNode operation, String message, Set<String> attributes) {
            this.address = address;
            this.operation = operation;
            this.message = message;
            this.attributes = attributes;
        }
    }
}

