/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.AttributeTransformationRequirementChecker;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformationContext;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformerEntry;
import org.jboss.dmr.ModelNode;

@Deprecated
public class RejectExpressionValuesChainedTransformer
implements ChainedResourceTransformerEntry,
OperationTransformer {
    private final Set<String> attributeNames;
    private final Map<String, AttributeTransformationRequirementChecker> attributeCheckers;
    private final OperationTransformer writeAttributeTransformer = new WriteAttributeTransformer();

    public RejectExpressionValuesChainedTransformer(AttributeDefinition ... attributes) {
        this(RejectExpressionValuesChainedTransformer.namesFromDefinitions(attributes));
    }

    private static Set<String> namesFromDefinitions(AttributeDefinition ... attributes) {
        HashSet<String> names = new HashSet<String>();
        for (AttributeDefinition def : attributes) {
            names.add(def.getName());
        }
        return names;
    }

    public RejectExpressionValuesChainedTransformer(Set<String> attributeNames) {
        this(attributeNames, null);
    }

    public RejectExpressionValuesChainedTransformer(String ... attributeNames) {
        this(new HashSet<String>(Arrays.asList(attributeNames)));
    }

    public RejectExpressionValuesChainedTransformer(Set<String> allAttributeNames, Map<String, AttributeTransformationRequirementChecker> specialCheckers) {
        this.attributeNames = allAttributeNames;
        this.attributeCheckers = specialCheckers;
    }

    public RejectExpressionValuesChainedTransformer(Map<String, AttributeTransformationRequirementChecker> specialCheckers) {
        this(specialCheckers.keySet(), specialCheckers);
    }

    public RejectExpressionValuesChainedTransformer(String attributeName, AttributeTransformationRequirementChecker checker) {
        this(Collections.singletonMap(attributeName, checker));
    }

    public OperationTransformer getWriteAttributeTransformer() {
        return this.writeAttributeTransformer;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
        final Set<String> attributes = this.checkModel(operation, context);
        boolean reject = attributes.size() > 0;
        OperationRejectionPolicy rejectPolicy = reject ? new OperationRejectionPolicy(){

            @Override
            public boolean rejectOperation(ModelNode preparedResult) {
                return true;
            }

            @Override
            public String getFailureDescription() {
                return context.getLogger().getWarning(address, operation, ControllerMessages.MESSAGES.attributesDontSupportExpressions(), attributes);
            }
        } : OperationTransformer.DEFAULT_REJECTION_POLICY;
        return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
    }

    @Override
    public void transformResource(ChainedResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        Set<String> attributes = this.checkModel(model, context);
        if (attributes.size() > 0) {
            context.getLogger().logWarning(address, ControllerMessages.MESSAGES.attributesDontSupportExpressions(), attributes);
        }
    }

    private Set<String> checkModel(ModelNode model, TransformationContext context) throws OperationFailedException {
        HashSet<String> attributes = new HashSet<String>();
        for (String attribute : this.attributeNames) {
            AttributeTransformationRequirementChecker checker;
            if (!model.hasDefined(attribute)) continue;
            if (this.attributeCheckers != null && (checker = this.attributeCheckers.get(attribute)) != null) {
                if (!checker.isAttributeTransformationRequired(attribute, model.get(attribute), context)) continue;
                attributes.add(attribute);
                continue;
            }
            if (!AttributeTransformationRequirementChecker.SIMPLE_EXPRESSIONS.isAttributeTransformationRequired(attribute, model.get(attribute), context)) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    class WriteAttributeTransformer
    implements OperationTransformer {
        WriteAttributeTransformer() {
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            boolean rejectResult;
            final String attribute = operation.require("name").asString();
            boolean containsExpression = false;
            if (RejectExpressionValuesChainedTransformer.this.attributeNames.contains(attribute) && operation.hasDefined("value")) {
                AttributeTransformationRequirementChecker checker;
                if (RejectExpressionValuesChainedTransformer.this.attributeCheckers != null && (checker = (AttributeTransformationRequirementChecker)RejectExpressionValuesChainedTransformer.this.attributeCheckers.get(attribute)) != null) {
                    if (checker.isAttributeTransformationRequired(attribute, operation.get("value"), context)) {
                        containsExpression = true;
                    }
                } else if (AttributeTransformationRequirementChecker.SIMPLE_EXPRESSIONS.isAttributeTransformationRequired(attribute, operation.get("value"), context)) {
                    containsExpression = true;
                }
            }
            if (rejectResult = containsExpression) {
                OperationRejectionPolicy rejectPolicy = new OperationRejectionPolicy(){

                    @Override
                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    @Override
                    public String getFailureDescription() {
                        return context.getLogger().getWarning(address, operation, new String[]{ControllerMessages.MESSAGES.attributesDontSupportExpressions(), attribute});
                    }
                };
                return new OperationTransformer.TransformedOperation(operation, rejectPolicy, OperationResultTransformer.ORIGINAL_RESULT);
            }
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

