/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.dmr.ModelNode;

class CompositeOperationTransformer
implements OperationTransformer {
    CompositeOperationTransformer() {
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        return this.transformOperation(context, address, operation, false);
    }

    OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation, boolean nested) throws OperationFailedException {
        assert (address.size() == 0);
        ModelNode composite = operation.clone();
        composite.get("steps").setEmptyList();
        TransformationTarget target = context.getTarget();
        ArrayList<Step> steps = new ArrayList<Step>();
        int i = 0;
        for (ModelNode step : operation.require("steps").asList()) {
            OperationTransformer.TransformedOperation result;
            PathAddress stepAddress;
            ++i;
            String operationName = step.require("operation").asString();
            PathAddress pathAddress = stepAddress = step.hasDefined("address") ? PathAddress.pathAddress(step.require("address")) : PathAddress.EMPTY_ADDRESS;
            if (stepAddress.size() == 0 && "composite".equals(operationName)) {
                result = this.transformOperation(context, PathAddress.EMPTY_ADDRESS, step, false);
            } else {
                OperationTransformer transformer = target.resolveTransformer(stepAddress, operationName);
                result = transformer.transformOperation(context, stepAddress, step);
            }
            composite.get("steps").add(result.getTransformedOperation());
            steps.add(new Step(i, result));
        }
        CompositeResultTransformer resultTransformer = new CompositeResultTransformer(steps);
        return new OperationTransformer.TransformedOperation(composite, resultTransformer);
    }

    private static class Step {
        private final int stepCount;
        private final OperationTransformer.TransformedOperation result;

        private Step(int step, OperationTransformer.TransformedOperation result) {
            this.stepCount = step;
            this.result = result;
        }

        public int getStepCount() {
            return this.stepCount;
        }

        public OperationTransformer.TransformedOperation getResult() {
            return this.result;
        }

        public String toString() {
            return "Step{step=" + this.stepCount + ", operation=" + this.result.getTransformedOperation() + '}';
        }
    }

    private static class CompositeResultTransformer
    implements OperationResultTransformer {
        private final List<Step> steps;

        private CompositeResultTransformer(List<Step> steps) {
            this.steps = steps;
        }

        @Override
        public ModelNode transformResult(ModelNode original) {
            ModelNode response = original.clone();
            ModelNode result = response.get("result").setEmptyObject();
            for (Step step : this.steps) {
                String id = "step-" + step.getStepCount();
                ModelNode stepResult = original.get(new String[]{"result", id});
                if ("ignored-by-unaffected-host-controller".equals(stepResult.get("outcome").asString())) {
                    result.get(id).set(stepResult);
                    continue;
                }
                OperationTransformer.TransformedOperation transformer = step.getResult();
                result.get(id).set(transformer.transformResult(stepResult));
            }
            return response;
        }
    }
}

