/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.TransformingProxyController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.dmr.ModelNode;

public class ProxyStepHandler
implements OperationStepHandler {
    private final ProxyController proxyController;

    public ProxyStepHandler(ProxyController proxyController) {
        this.proxyController = proxyController;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AtomicReference<ModelNode> finalResultRef;
        AtomicReference<ModelNode> preparedResultRef;
        AtomicReference<ModelController.OperationTransaction> txRef;
        block6: {
            DelegatingMessageHandler messageHandler = new DelegatingMessageHandler(context);
            txRef = new AtomicReference<ModelController.OperationTransaction>();
            preparedResultRef = new AtomicReference<ModelNode>();
            finalResultRef = new AtomicReference<ModelNode>();
            final ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    txRef.set(transaction);
                    preparedResultRef.set(result);
                }

                @Override
                public void operationFailed(ModelNode response) {
                    finalResultRef.set(response);
                }

                @Override
                public void operationCompleted(ModelNode response) {
                    finalResultRef.set(response);
                }
            };
            if (this.proxyController instanceof TransformingProxyController) {
                TransformingProxyController transformingProxyController = (TransformingProxyController)this.proxyController;
                final OperationTransformer.TransformedOperation result = transformingProxyController.transformOperation(context, operation);
                ModelNode transformedOperation = result.getTransformedOperation();
                final OperationResultTransformer resultTransformer = result.getResultTransformer();
                if (transformedOperation != null) {
                    ProxyController.ProxyOperationControl transformingProxyControl = new ProxyController.ProxyOperationControl(){

                        @Override
                        public void operationFailed(ModelNode response) {
                            ModelNode result2 = resultTransformer.transformResult(response);
                            proxyControl.operationFailed(result2);
                        }

                        @Override
                        public void operationCompleted(ModelNode response) {
                            ModelNode result2 = resultTransformer.transformResult(response);
                            proxyControl.operationCompleted(result2);
                        }

                        @Override
                        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode response) {
                            ModelNode transformed;
                            if (result.rejectOperation(response)) {
                                ModelNode newResponse = new ModelNode();
                                newResponse.get("outcome").set("failed");
                                newResponse.get("failure-description").set(result.getFailureDescription());
                                transformed = newResponse;
                            } else {
                                transformed = response;
                            }
                            proxyControl.operationPrepared(transaction, transformed);
                        }
                    };
                    this.proxyController.execute(transformedOperation, messageHandler, transformingProxyControl, new DelegatingOperationAttachments(context));
                    break block6;
                } else {
                    ModelNode transformedResult = resultTransformer.transformResult(new ModelNode());
                    if (transformedResult != null) {
                        context.getResult().set(transformedResult);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                    return;
                }
            }
            this.proxyController.execute(operation, messageHandler, proxyControl, new DelegatingOperationAttachments(context));
        }
        ModelNode finalResult = (ModelNode)finalResultRef.get();
        if (finalResult == null) {
            this.completeRemoteTransaction(context, operation, txRef, preparedResultRef, finalResultRef);
            return;
        }
        context.getResult().set(finalResult.get("result"));
        context.getFailureDescription().set(finalResult.get("failure-description"));
        if (finalResult.hasDefined("response-headers")) {
            context.getResponseHeaders().set(finalResult.get("response-headers"));
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRemoteTransaction(OperationContext context, ModelNode operation, final AtomicReference<ModelController.OperationTransaction> txRef, AtomicReference<ModelNode> preparedResultRef, final AtomicReference<ModelNode> finalResultRef) {
        boolean completeStepCalled = false;
        try {
            ModelNode preparedResponse = preparedResultRef.get();
            ModelNode preparedResult = preparedResponse.get("result");
            if (preparedResponse.hasDefined("failure-description")) {
                context.getFailureDescription().set(preparedResponse.get("failure-description"));
                if (preparedResult.isDefined()) {
                    context.getResult().set(preparedResult);
                }
            } else {
                context.getResult().set(preparedResult);
            }
            context.completeStep(new OperationContext.ResultHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    boolean txCompleted = false;
                    try {
                        ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
                        try {
                            if (resultAction == OperationContext.ResultAction.KEEP) {
                                tx.commit();
                            } else {
                                tx.rollback();
                            }
                        }
                        finally {
                            txCompleted = true;
                        }
                        ModelNode finalResponse = (ModelNode)finalResultRef.get();
                        if (finalResponse != null) {
                            ModelNode finalResult = finalResponse.get("result");
                            if (finalResponse.hasDefined("failure-description")) {
                                context.getFailureDescription().set(finalResponse.get("failure-description"));
                                if (finalResult.isDefined()) {
                                    context.getResult().set(finalResult);
                                }
                            } else {
                                context.getResult().set(finalResult);
                            }
                            if (context.getProcessType() == ProcessType.HOST_CONTROLLER && finalResponse.has("server-groups")) {
                                context.getServerResults().set(finalResponse.get("server-groups"));
                            }
                            if (finalResponse.hasDefined("response-headers")) {
                                context.getResponseHeaders().set(finalResponse.get("response-headers"));
                            }
                        } else {
                            ControllerLogger.SERVER_MANAGEMENT_LOGGER.noFinalProxyOutcomeReceived(operation.get("operation"), operation.get("address"), ProxyStepHandler.this.proxyController.getProxyNodeAddress().toModelNode());
                        }
                    }
                    finally {
                        if (!txCompleted && txRef.get() != null) {
                            ((ModelController.OperationTransaction)txRef.get()).rollback();
                        }
                    }
                }
            });
            completeStepCalled = true;
        }
        finally {
            if (!completeStepCalled && txRef.get() != null) {
                txRef.get().rollback();
            }
        }
    }

    private static class DelegatingOperationAttachments
    implements OperationAttachments {
        private final OperationContext context;

        private DelegatingOperationAttachments(OperationContext context) {
            this.context = context;
        }

        public boolean isAutoCloseStreams() {
            return false;
        }

        public List<InputStream> getInputStreams() {
            int count = this.context.getAttachmentStreamCount();
            ArrayList<InputStream> result = new ArrayList<InputStream>(count);
            for (int i = 0; i < count; ++i) {
                result.add(this.context.getAttachmentStream(i));
            }
            return result;
        }

        public void close() throws IOException {
        }
    }

    private static class DelegatingMessageHandler
    implements OperationMessageHandler {
        private final OperationContext context;

        DelegatingMessageHandler(OperationContext context) {
            this.context = context;
        }

        public void handleReport(MessageSeverity severity, String message) {
            this.context.report(severity, message);
        }
    }
}

