/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.Closeable;
import java.net.InetAddress;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="JBAS")
public interface ControllerLogger
extends BasicLogger {
    public static final ControllerLogger ROOT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)ControllerLogger.class.getPackage().getName());
    public static final ControllerLogger MGMT_OP_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)(ControllerLogger.class.getPackage().getName() + ".management-operation"));
    public static final ControllerLogger SERVER_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.server");
    public static final ControllerLogger SERVER_MANAGEMENT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.server.management");
    public static final ControllerLogger DEPRECATED_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)(ControllerLogger.class.getPackage().getName() + ".management-deprecated"));
    public static final ControllerLogger TRANSFORMER_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)(ControllerLogger.class.getPackage().getName() + ".transformer"));

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14600, value="Cannot resolve address %s, so cannot match it to any InetAddress")
    public void cannotResolveAddress(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14601, value="Error booting the container")
    public void errorBootingContainer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14602, value="Error booting the container due to insufficient stack space for the thread used to execute boot operations. The thread was configured with a stack size of [%1$d]. Setting system property %2$s to a value higher than [%1$d] may resolve this problem.")
    public void errorBootingContainer(@Cause Throwable var1, long var2, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14603, value="%s caught exception attempting to revert operation %s at address %s")
    public void errorRevertingOperation(@Cause Throwable var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14604, value="Failed executing operation %s at address %s")
    public void failedExecutingOperation(@Cause Throwable var1, ModelNode var2, PathAddress var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14605, value="Failed executing subsystem %s boot operations")
    public void failedSubsystemBootOperations(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14606, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Closeable var2);

    @LogMessage(level=Logger.Level.ERROR)
    public void failedToCloseResource(@Cause Throwable var1, XMLStreamWriter var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14607, value="Failed to persist configuration change")
    public void failedToPersistConfigurationChange(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14608, value="Failed to store configuration to %s")
    public void failedToStoreConfiguration(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14609, value="Invalid value %s for system property %s -- using default value [%d]")
    public void invalidSystemPropertyValue(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14610, value="Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration element to specify that an interface should use a wildcard address; use '%3$s', '%4$s', or '%5$s'")
    public void invalidWildcardAddress(String var1, String var2, String var3, String var4, String var5);

    @Deprecated
    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14611, value="No handler for %s at address %s")
    public void noHandler(String var1, PathAddress var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14612, value="Operation (%s) failed - address: (%s)")
    public void operationFailed(@Cause Throwable var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=-1, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailed(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14613, value="Operation (%s) failed - address: (%s) -- due to insufficient stack space for the thread used to execute operations. If this error is occurring during server boot, setting system property %s to a value higher than [%d] may resolve this problem.")
    public void operationFailed(@Cause Throwable var1, ModelNode var2, ModelNode var3, String var4, int var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14614, value="Wildcard address detected - will ignore other interface criteria.")
    public void wildcardAddressDetected();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14615, value="Received no final outcome response for operation %s with address %s from remote process at address %s. The result of this operation will only include the remote process' preliminary response tothe request.")
    public void noFinalProxyOutcomeReceived(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14616, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailedOnClientError(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14617, value="A subystem '%s' was registered without calling ExtensionContext.createTracker(). The subsystems are registered normally but won't be cleaned up when the extension is removed.")
    public void registerSubsystemNoWraper(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14618, value="Graceful shutdown of the handler used for native management requests did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownTimedOut(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14619, value="Graceful shutdown of the handler used for native management requests failed but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14620, value="Invalid value '%s' for system property '%s' -- value must be convertible into an int")
    public void invalidChannelCloseTimeout(@Cause NumberFormatException var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14621, value="Multiple addresses or network interfaces matched the selection criteria for interface '%s'. Matching addresses: %s.  Matching network interfaces: %s. The interface will use address %s and network interface %s.")
    public void multipleMatchingAddresses(String var1, Set<InetAddress> var2, Set<String> var3, InetAddress var4, String var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14622, value="Value '%s' for interface selection criteria 'inet-address' is ambiguous, as more than one address or network interface available on the machine matches it. Because of this ambiguity, no address will be selected as a match. Matching addresses: %s.  Matching network interfaces: %s.")
    public void multipleMatchingAddresses(String var1, Set<InetAddress> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14623, value="Could not read target definition!")
    public void cannotReadTargetDefinition(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14624, value="Could not transform")
    public void cannotTransform(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14625, value="We have no transformer for subsystem: %s-%d.%d model transfer can break!")
    public void transformerNotFound(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14626, value="Operation was interrupted before stability could be reached")
    public void interruptedWaitingStability();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14627, value="Attribute %s is deprecated, and it might be removed in future version!")
    public void attributeDeprecated(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=14628, value="Cannot delete temp file %s, will be deleted on exit")
    public void cannotDeleteTempFile(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14629, value="No resource definition is registered for address %s")
    public void noSuchResourceType(PathAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=13400, value="No operation named '%s' exists at address %s")
    public void noHandlerForOperation(String var1, PathAddress var2);

    @Message(id=13403, value="There were some problems during transformation process for target host: '%s' \n Problems found: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void tranformationWarnings(String var1, Set<String> var2);
}

