/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Map;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleReferenceClassLoader;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.FrameworkModuleProviderPlugin;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;

final class FrameworkModuleIntegration
extends FrameworkModuleProviderPlugin {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final Map<String, Object> props;

    FrameworkModuleIntegration(Map<String, Object> props) {
        this.props = props;
    }

    protected void addServiceDependencies(ServiceBuilder<FrameworkModuleProvider> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
    }

    protected FrameworkModuleProvider createServiceValue(StartContext startContext) {
        return new FrameworkModuleProviderImpl();
    }

    class FrameworkModuleProviderImpl
    implements FrameworkModuleProvider {
        private Module frameworkModule;

        FrameworkModuleProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Module getFrameworkModule() {
            FrameworkModuleProviderImpl frameworkModuleProviderImpl = this;
            synchronized (frameworkModuleProviderImpl) {
                if (this.frameworkModule == null) {
                    this.frameworkModule = this.createFrameworkModule();
                }
                return this.frameworkModule;
            }
        }

        private Module createFrameworkModule() {
            String extramodules;
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.create((String)"jbosgi.framework"));
            String sysmodules = (String)FrameworkModuleIntegration.this.props.get("org.jboss.osgi.system.modules");
            if (sysmodules == null) {
                sysmodules = "";
            }
            if ((extramodules = (String)FrameworkModuleIntegration.this.props.get("org.jboss.osgi.system.modules.extra")) != null) {
                sysmodules = sysmodules + "," + extramodules;
            }
            ModuleLoader bootLoader = Module.getBootModuleLoader();
            PathFilter acceptAll = PathFilters.acceptAll();
            for (String modid : sysmodules.split(",")) {
                if ((modid = modid.trim()).length() <= 0) continue;
                ModuleIdentifier identifier = ModuleIdentifier.create((String)modid);
                specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)acceptAll, (PathFilter)acceptAll, (ModuleLoader)bootLoader, (ModuleIdentifier)identifier, (boolean)false));
            }
            XBundle systemBundle = ((BundleManager)FrameworkModuleIntegration.this.injectedBundleManager.getValue()).getSystemBundle();
            specBuilder.setModuleClassLoaderFactory((ModuleClassLoaderFactory)new BundleReferenceClassLoader.Factory((Bundle)systemBundle));
            try {
                final ModuleSpec moduleSpec = specBuilder.create();
                ModuleLoader moduleLoader = new ModuleLoader(){

                    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                        return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                    }

                    public String toString() {
                        return "FrameworkModuleLoader";
                    }
                };
                return moduleLoader.loadModule(specBuilder.getIdentifier());
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

