/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiCapabilityRemove
extends AbstractRemoveStepHandler {
    static final OSGiCapabilityRemove INSTANCE = new OSGiCapabilityRemove();

    private OSGiCapabilityRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String identifier = operation.get("address").asObject().get("capability").asString();
        final SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState == null) {
            context.setRollbackOnly();
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            return;
        }
        final SubsystemState.OSGiCapability oldVal = subsystemState.removeCapability(identifier);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                subsystemState.addCapability(oldVal);
            }
        });
    }
}

