/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCPostgreSQLCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence;
    private String sequenceSQL;

    @Override
    public void init(JDBCStoreManager manager) {
        super.init(manager);
    }

    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.sequence = entityCommand.getAttribute("sequence");
        if (this.sequence == null) {
            this.sequence = this.entity.getQualifiedTableName() + '_' + SQLUtil.getColumnNamesClause(this.pkField, new StringBuffer(20)) + "_seq";
        }
        this.sequenceSQL = "SELECT currval('" + this.sequence + "')";
        if (this.debug) {
            this.log.debug((Object)("SEQUENCE SQL is :" + this.sequenceSQL));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeInsert(int index, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        int rows = ps.executeUpdate();
        Statement s = null;
        ResultSet rs = null;
        try {
            Connection c;
            if (this.trace) {
                this.log.trace((Object)("Executing SQL :" + this.sequenceSQL));
            }
            if (!(rs = (s = (c = ps.getConnection()).createStatement()).executeQuery(this.sequenceSQL)).next()) {
                throw CmpMessages.MESSAGES.sequenceSqlReturnedEmptyResultSet();
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.errorExtractingGeneratedKey(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(s);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(s);
        return rows;
    }
}

