/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.component;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.component.CmpProxy;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.bridge.CMRMessage;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.WrappedRemoteException;
import org.jboss.as.ejb3.component.entity.interceptors.InternalInvocationMarker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class CmpEntityBeanComponentInstance
extends EntityBeanComponentInstance {
    private final Logger log;
    private final Interceptor relationshipInterceptor;

    CmpEntityBeanComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Interceptor relationshipInterceptor) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        this.log = Logger.getLogger((String)(CmpEntityBeanComponentInstance.class.getName() + "." + component.getComponentName()));
        this.relationshipInterceptor = relationshipInterceptor;
    }

    public CmpEntityBeanComponent getComponent() {
        return (CmpEntityBeanComponent)super.getComponent();
    }

    public CmpEntityBeanContext getEjbContext() {
        return (CmpEntityBeanContext)super.getEjbContext();
    }

    public void setupContext(InterceptorContext interceptorContext) {
        InvocationType invocationType = (InvocationType)interceptorContext.getPrivateData(InvocationType.class);
        try {
            interceptorContext.putPrivateData(InvocationType.class, (Object)InvocationType.SET_ENTITY_CONTEXT);
            CmpEntityBeanContext context = new CmpEntityBeanContext(this);
            this.setEjbContext(context);
            this.getInstance().setEntityContext((EntityContext)context);
            this.getComponent().getStoreManager().activateEntity(context);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            interceptorContext.putPrivateData(InvocationType.class, (Object)invocationType);
        }
    }

    public EntityBean getInstance() {
        EntityBean instance = super.getInstance();
        if (instance instanceof CmpProxy) {
            ((CmpProxy)CmpProxy.class.cast(instance)).setComponentInstance(this);
        }
        return instance;
    }

    public boolean isReloadRequired() {
        return !this.getEjbContext().isValid();
    }

    public void setReloadRequired(boolean reloadRequired) {
        this.getEjbContext().setValid(!reloadRequired);
    }

    public void reload() {
        try {
            CmpEntityBeanContext entityContext = this.getEjbContext();
            this.getComponent().getStoreManager().loadEntity(entityContext);
            entityContext.setValid(true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void store() {
        try {
            if (!this.isRemoved()) {
                this.invokeEjbStore();
                CmpEntityBeanContext context = this.getEjbContext();
                JDBCEntityPersistenceStore store = this.getComponent().getStoreManager();
                if (context.getPrimaryKeyUnchecked() != null && store.isStoreRequired(context)) {
                    store.storeEntity(context);
                }
            }
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    protected void invokeEjbStore() throws Exception {
        CmpEntityBeanComponent component = this.getComponent();
        if (component.getStoreManager().getCmpConfig().isCallEjbStoreOnClean()) {
            this.log.trace((Object)"invoke ejbStore on clean component");
            super.invokeEjbStore();
        } else if (component.getStoreManager().isStoreRequired(this.getEjbContext())) {
            this.log.trace((Object)"invoke ejbStore on dirty component");
            super.invokeEjbStore();
        }
    }

    public void passivate() {
        JDBCEntityPersistenceStore store = this.getComponent().getStoreManager();
        try {
            store.passivateEntity(this.getEjbContext());
            this.clearPrimaryKey();
            this.setRemoved(false);
        }
        catch (RemoteException e) {
            throw new WrappedRemoteException(e);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object invoke(CMRMessage message, Object ... params) {
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(params);
        interceptorContext.putPrivateData(Component.class, (Object)this.getComponent());
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.putPrivateData(CMRMessage.class, (Object)message);
        interceptorContext.putPrivateData(InternalInvocationMarker.class, (Object)InternalInvocationMarker.INSTANCE);
        try {
            return this.relationshipInterceptor.processInvocation(interceptorContext);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToInvokeRelationshipRequest(e);
        }
    }
}

