/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.MBeanServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.DiscardAttributesTransformer;
import org.jboss.as.controller.transform.DiscardUndefinedAttributesTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.chained.ChainedOperationTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformationContext;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformerEntry;
import org.jboss.as.txn.TransactionLogger;
import org.jboss.as.txn.TransactionMessages;
import org.jboss.as.txn.subsystem.LogStoreDefinition;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.LogStoreTransactionDefinition;
import org.jboss.as.txn.subsystem.LogStoreTransactionParticipantDefinition;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem10Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem11Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem12Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystem13Parser;
import org.jboss.as.txn.subsystem.TransactionSubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class TransactionExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "transactions";
    public static final String RESOLVE_OBJECT_STORE_PATH = "resolve-object-store-path";
    private static final String RESOURCE_NAME = TransactionExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final ServiceName MBEAN_SERVER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "server"});
    static final PathElement LOG_STORE_PATH = PathElement.pathElement((String)"log-store", (String)"log-store");
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"transactions");
    static final PathElement PARTECIPANT_PATH = PathElement.pathElement((String)"participants");
    static final PathElement TRANSACTION_PATH = PathElement.pathElement((String)"transactions");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, TransactionExtension.class.getClassLoader(), true, false);
    }

    static MBeanServer getMBeanServer(OperationContext context) {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController serviceController = serviceRegistry.getService(MBEAN_SERVER_SERVICE_NAME);
        if (serviceController == null) {
            throw TransactionMessages.MESSAGES.jmxSubsystemNotInstalled();
        }
        return (MBeanServer)serviceController.getValue();
    }

    public void initialize(ExtensionContext context) {
        TransactionLogger.ROOT_LOGGER.debug("Initializing Transactions Extension");
        LogStoreResource resource = new LogStoreResource();
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        TransactionSubsystemRootResourceDefinition rootResourceDefinition = new TransactionSubsystemRootResourceDefinition(registerRuntimeOnly);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)rootResourceDefinition);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        if (context.getProcessType().isServer()) {
            ResolvePathHandler objectStorePathHandler = ResolvePathHandler.Builder.of((String)RESOLVE_OBJECT_STORE_PATH, (PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_PATH).setRelativeToAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.OBJECT_STORE_RELATIVE_TO).build();
            registration.registerOperationHandler(objectStorePathHandler.getOperationDefinition(), (OperationStepHandler)objectStorePathHandler);
            ResolvePathHandler resolvePathHandler = ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setPathAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.PATH).setRelativeToAttribute((AttributeDefinition)TransactionSubsystemRootResourceDefinition.RELATIVE_TO).build();
            registration.registerOperationHandler(resolvePathHandler.getOperationDefinition(), (OperationStepHandler)resolvePathHandler);
        }
        ManagementResourceRegistration logStoreChild = registration.registerSubModel((ResourceDefinition)new LogStoreDefinition(resource));
        if (registerRuntimeOnly) {
            ManagementResourceRegistration transactionChild = logStoreChild.registerSubModel((ResourceDefinition)new LogStoreTransactionDefinition(resource));
            transactionChild.registerSubModel((ResourceDefinition)LogStoreTransactionParticipantDefinition.INSTANCE);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)TransactionSubsystem13Parser.INSTANCE);
        if (context.isRegisterTransformers()) {
            TransactionExtension.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_0.getUriString(), (XMLElementReader)TransactionSubsystem10Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_1.getUriString(), (XMLElementReader)TransactionSubsystem11Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_2.getUriString(), (XMLElementReader)TransactionSubsystem12Parser.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.TRANSACTIONS_1_3.getUriString(), (XMLElementReader)TransactionSubsystem13Parser.INSTANCE);
    }

    private static void registerTransformers(SubsystemRegistration subsystem) {
        DiscardUndefinedAttributesTransformer discardJdbcStoreTransformer = new DiscardUndefinedAttributesTransformer(TransactionSubsystemRootResourceDefinition.attributes_1_2);
        ChainedResourceTransformerEntry addUUIDTransformer = new ChainedResourceTransformerEntry(){

            public void transformResource(ChainedResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode model = resource.getModel();
                if (!model.hasDefined(TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID.getName())) {
                    model.get(TransactionSubsystemRootResourceDefinition.PROCESS_ID_UUID.getName()).set(false);
                }
            }
        };
        ModelVersion version111 = ModelVersion.create((int)1, (int)1, (int)1);
        TransformersSubRegistration transformers111 = subsystem.registerModelTransformers((ModelVersionRange)version111, (ResourceTransformer)new ChainedResourceTransformer(new ChainedResourceTransformerEntry[]{UnneededJDBCStoreTransformer.INSTANCE, discardJdbcStoreTransformer, addUUIDTransformer}));
        transformers111.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{UnneededJDBCStoreTransformer.INSTANCE, discardJdbcStoreTransformer}));
        transformers111.registerOperationTransformer("write-attribute", discardJdbcStoreTransformer.getWriteAttributeTransformer());
        transformers111.registerOperationTransformer("undefine-attribute", discardJdbcStoreTransformer.getUndefineAttributeTransformer());
        ModelVersion version110 = ModelVersion.create((int)1, (int)1, (int)0);
        RejectExpressionValuesTransformer reject = new RejectExpressionValuesTransformer(TransactionSubsystemRootResourceDefinition.attributes);
        TransformersSubRegistration registration = subsystem.registerModelTransformers((ModelVersionRange)version110, (ResourceTransformer)new ChainedResourceTransformer(new ChainedResourceTransformerEntry[]{UnneededJDBCStoreTransformer.INSTANCE, discardJdbcStoreTransformer, reject.getChainedTransformer(), addUUIDTransformer}));
        registration.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{UnneededJDBCStoreTransformer.INSTANCE, discardJdbcStoreTransformer, reject.getChainedTransformer()}));
        registration.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{discardJdbcStoreTransformer.getWriteAttributeTransformer(), reject.getWriteAttributeTransformer()}));
        registration.registerOperationTransformer("undefine-attribute", discardJdbcStoreTransformer.getUndefineAttributeTransformer());
    }

    static class UnneededJDBCStoreTransformer
    extends DiscardAttributesTransformer {
        private static final UnneededJDBCStoreTransformer INSTANCE = new UnneededJDBCStoreTransformer();

        private UnneededJDBCStoreTransformer() {
            super((DiscardAttributesTransformer.DiscardApprover)new DiscardAttributesTransformer.AttributeValueDiscardApprover(TransactionSubsystemRootResourceDefinition.USE_JDBC_STORE.getName(), new ModelNode(false), true), TransactionSubsystemRootResourceDefinition.attributes_1_2);
        }
    }
}

