/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.util.Properties;
import org.infinispan.loaders.jdbc.AbstractJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.DatabaseType;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;

public abstract class AbstractNonDelegatingJdbcCacheStoreConfig
extends AbstractJdbcCacheStoreConfig {
    private static final long serialVersionUID = 842757200078048889L;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 2048;
    public static final int DEFAULT_LOCK_ACQUISITION_TIMEOUT = 60000;
    private int lockConcurrencyLevel = 2048;
    private long lockAcquistionTimeout = 60000L;
    protected TableManipulation tableManipulation = new TableManipulation();
    protected boolean manageConnectionFactory = true;

    protected AbstractNonDelegatingJdbcCacheStoreConfig() {
    }

    protected AbstractNonDelegatingJdbcCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig, TableManipulation tableManipulation) {
        super(connectionFactoryConfig);
        this.tableManipulation = tableManipulation;
        Properties p = this.getProperties();
        this.setProperty(tableManipulation.getTableNamePrefix(), "tableNamePrefix", p);
        this.setProperty(tableManipulation.getIdColumnName(), "idColumnName", p);
        this.setProperty(tableManipulation.getIdColumnType(), "idColumnType", p);
        this.setProperty(tableManipulation.getDataColumnName(), "dataColumnName", p);
        this.setProperty(tableManipulation.getDataColumnType(), "dataColumnType", p);
        this.setProperty(tableManipulation.getTimestampColumnName(), "timestampColumnName", p);
        this.setProperty(tableManipulation.getTimestampColumnType(), "timestampColumnType", p);
    }

    public void setCacheName(String cacheName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCacheName(cacheName);
    }

    public void setIdColumnName(String idColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnName(idColumnName);
    }

    public void setDataColumnName(String dataColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnName(dataColumnName);
    }

    public void setTimestampColumnName(String timestampColumnName) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnName(timestampColumnName);
    }

    public void setTimestampColumnType(String timestampColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setTimestampColumnType(timestampColumnType);
    }

    public TableManipulation getTableManipulation() {
        return this.tableManipulation;
    }

    public void setIdColumnType(String idColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setIdColumnType(idColumnType);
    }

    public void setDataColumnType(String dataColumnType) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDataColumnType(dataColumnType);
    }

    public void setDropTableOnExit(boolean dropTableOnExit) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setDropTableOnExit(dropTableOnExit);
    }

    public void setCreateTableOnStart(boolean createTableOnStart) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setCreateTableOnStart(createTableOnStart);
    }

    public boolean isManageConnectionFactory() {
        return this.manageConnectionFactory;
    }

    public void setTableManipulation(TableManipulation tableManipulation) {
        this.testImmutability("tableManipulation");
        this.tableManipulation = tableManipulation;
    }

    public void setFetchSize(int fetchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setFetchSize(fetchSize);
    }

    public void setBatchSize(int batchSize) {
        this.testImmutability("tableManipulation");
        this.tableManipulation.setBatchSize(batchSize);
    }

    public int getFetchSize() {
        return this.tableManipulation.getFetchSize();
    }

    public int getBatchSize() {
        return this.tableManipulation.getBatchSize();
    }

    public String getDatabaseType() {
        return this.tableManipulation.databaseType == null ? "" : this.tableManipulation.databaseType.toString();
    }

    public void setDatabaseType(String dbType) {
        if (dbType != null) {
            this.tableManipulation.databaseType = DatabaseType.valueOf(dbType.toUpperCase().trim());
        }
    }

    public void setDatabaseType(DatabaseType dbType) {
        if (dbType != null) {
            this.tableManipulation.databaseType = dbType;
        }
    }

    @Override
    public AbstractNonDelegatingJdbcCacheStoreConfig clone() {
        AbstractNonDelegatingJdbcCacheStoreConfig result = (AbstractNonDelegatingJdbcCacheStoreConfig)super.clone();
        result.tableManipulation = this.tableManipulation.clone();
        return result;
    }

    @Override
    public String toString() {
        return "AbstractNonDelegatingJdbcCacheStoreConfig{lockConcurrencyLevel=" + this.lockConcurrencyLevel + ", lockAcquistionTimeout=" + this.lockAcquistionTimeout + ", tableManipulation=" + this.tableManipulation + ", manageConnectionFactory=" + this.manageConnectionFactory + "} " + super.toString();
    }
}

