/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.persistence.impl.journal.BatchingIDGenerator;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.journal.LargeServerMessageImpl;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.utils.Base64;
import org.hornetq.utils.XidCodecSupport;

public final class DescribeJournal {
    public static final void describeBindingsJournal(String bindingsDir) throws Exception {
        NIOSequentialFileFactory bindingsFF = new NIOSequentialFileFactory(bindingsDir, null);
        JournalImpl bindings = new JournalImpl(0x100000, 2, -1, 0, (SequentialFileFactory)bindingsFF, "hornetq-bindings", "bindings", 1);
        DescribeJournal.describeJournal((SequentialFileFactory)bindingsFF, bindings, bindingsDir);
    }

    public static final void describeMessagesJournal(String messagesDir) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(messagesDir, null);
        ConfigurationImpl defaultValues = new ConfigurationImpl();
        JournalImpl messagesJournal = new JournalImpl(defaultValues.getJournalFileSize(), defaultValues.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        DescribeJournal.describeJournal((SequentialFileFactory)messagesFF, messagesJournal, messagesDir);
    }

    private static void describeJournal(SequentialFileFactory fileFactory, JournalImpl journal, String path) throws Exception {
        List files = journal.orderFiles();
        final PrintStream out = System.out;
        out.println("Journal path: " + path);
        for (JournalFile file : files) {
            out.println("#" + file + " (size=" + file.getFile().size() + ")");
            JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@UpdateTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo));
                }

                public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@Update;" + DescribeJournal.describeRecord(recordInfo));
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    out.println("operation@Rollback;txID=" + transactionID);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    out.println("operation@Prepare,txID=" + transactionID + ",numberOfRecords=" + numberOfRecords + ",extraData=" + DescribeJournal.encode(extraData) + ", xid=" + DescribeJournal.toXid(extraData));
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@DeleteRecordTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo));
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    out.println("operation@DeleteRecord;recordID=" + recordID);
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    out.println("operation@Commit;txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecordTX;txID=" + transactionID + "," + DescribeJournal.describeRecord(recordInfo));
                }

                public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecord;" + DescribeJournal.describeRecord(recordInfo));
                }

                public void markAsDataFile(JournalFile file1) {
                }
            });
        }
        out.println();
        out.println("### Surviving Records Summary ###");
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        journal.start();
        final StringBuffer bufferFailingTransactions = new StringBuffer();
        int messageCount = 0;
        HashMap<Long, Integer> messageRefCounts = new HashMap<Long, Integer>();
        int preparedMessageCount = 0;
        HashMap<Long, Integer> preparedMessageRefCount = new HashMap<Long, Integer>();
        journal.load(records, preparedTransactions, new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records1, List<RecordInfo> recordsToDelete) {
                bufferFailingTransactions.append("Transaction " + transactionID + " failed with these records:\n");
                for (RecordInfo info : records1) {
                    bufferFailingTransactions.append("- " + DescribeJournal.describeRecord(info) + "\n");
                }
                for (RecordInfo info : recordsToDelete) {
                    bufferFailingTransactions.append("- " + DescribeJournal.describeRecord(info) + " <marked to delete>\n");
                }
            }
        }, false);
        for (RecordInfo info : records) {
            Integer count;
            Object ref;
            Object o = DescribeJournal.newObjectEncoding(info);
            if (info.getUserRecordType() == 31) {
                ++messageCount;
            } else if (info.getUserRecordType() == 32) {
                ref = (ReferenceDescribe)o;
                count = (Integer)messageRefCounts.get(((ReferenceDescribe)ref).refEncoding.queueID);
                if (count == null) {
                    count = 1;
                    messageRefCounts.put(((ReferenceDescribe)ref).refEncoding.queueID, count);
                } else {
                    messageRefCounts.put(((ReferenceDescribe)ref).refEncoding.queueID, count + 1);
                }
            } else if (info.getUserRecordType() == 33) {
                ref = (JournalStorageManager.AckDescribe)o;
                count = (Integer)messageRefCounts.get(((JournalStorageManager.AckDescribe)ref).refEncoding.queueID);
                if (count == null) {
                    messageRefCounts.put(((JournalStorageManager.AckDescribe)ref).refEncoding.queueID, 0);
                } else {
                    messageRefCounts.put(((JournalStorageManager.AckDescribe)ref).refEncoding.queueID, count - 1);
                }
            }
            out.println(DescribeJournal.describeRecord(info, o));
        }
        out.println();
        out.println("### Prepared TX ###");
        for (PreparedTransactionInfo tx : preparedTransactions) {
            out.println(tx.id);
            for (RecordInfo info : tx.records) {
                Object o = DescribeJournal.newObjectEncoding(info);
                out.println("- " + DescribeJournal.describeRecord(info, o));
                if (info.getUserRecordType() == 31) {
                    ++preparedMessageCount;
                    continue;
                }
                if (info.getUserRecordType() != 32) continue;
                ReferenceDescribe ref = (ReferenceDescribe)o;
                Integer count = (Integer)preparedMessageRefCount.get(ref.refEncoding.queueID);
                if (count == null) {
                    count = 1;
                    preparedMessageRefCount.put(ref.refEncoding.queueID, count);
                    continue;
                }
                preparedMessageRefCount.put(ref.refEncoding.queueID, count + 1);
            }
            for (RecordInfo info : tx.recordsToDelete) {
                out.println("- " + DescribeJournal.describeRecord(info) + " <marked to delete>");
            }
        }
        String missingTX = bufferFailingTransactions.toString();
        if (missingTX.length() > 0) {
            out.println();
            out.println("### Failed Transactions (Missing commit/prepare/rollback record) ###");
        }
        out.println(bufferFailingTransactions.toString());
        out.println("### Message Counts ###");
        out.println("message count=" + messageCount);
        out.println("message reference count");
        for (Map.Entry longIntegerEntry : messageRefCounts.entrySet()) {
            System.out.println("queue id " + longIntegerEntry.getKey() + ",count=" + longIntegerEntry.getValue());
        }
        out.println("prepared message count=" + preparedMessageCount);
        for (Map.Entry longIntegerEntry : preparedMessageRefCount.entrySet()) {
            System.out.println("queue id " + longIntegerEntry.getKey() + ",count=" + longIntegerEntry.getValue());
        }
        journal.stop();
    }

    private static String describeRecord(RecordInfo info) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";" + DescribeJournal.newObjectEncoding(info);
    }

    private static String describeRecord(RecordInfo info, Object o) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";" + o;
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }

    private static Xid toXid(byte[] data) {
        try {
            return XidCodecSupport.decodeXid((HornetQBuffer)HornetQBuffers.wrappedBuffer((byte[])data));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object newObjectEncoding(RecordInfo info) {
        return DescribeJournal.newObjectEncoding(info, null);
    }

    public static Object newObjectEncoding(RecordInfo info, JournalStorageManager storageManager) {
        HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])info.data);
        long id = info.id;
        byte rec = info.getUserRecordType();
        switch (rec) {
            case 29: {
                JournalStorageManager.PendingLargeMessageEncoding lmEncoding = new JournalStorageManager.PendingLargeMessageEncoding();
                lmEncoding.decode(buffer);
                return lmEncoding;
            }
            case 30: {
                LargeServerMessageImpl largeMessage = new LargeServerMessageImpl(storageManager);
                JournalStorageManager.LargeMessageEncoding messageEncoding = new JournalStorageManager.LargeMessageEncoding(largeMessage);
                messageEncoding.decode(buffer);
                return new MessageDescribe((Message)largeMessage);
            }
            case 31: {
                ServerMessageImpl message = new ServerMessageImpl(rec, 50);
                message.decode(buffer);
                return new MessageDescribe((Message)message);
            }
            case 32: {
                JournalStorageManager.RefEncoding encoding = new JournalStorageManager.RefEncoding();
                encoding.decode(buffer);
                return new ReferenceDescribe(encoding);
            }
            case 33: {
                JournalStorageManager.RefEncoding encoding = new JournalStorageManager.RefEncoding();
                encoding.decode(buffer);
                return new JournalStorageManager.AckDescribe(encoding);
            }
            case 34: {
                JournalStorageManager.DeliveryCountUpdateEncoding updateDeliveryCount = new JournalStorageManager.DeliveryCountUpdateEncoding();
                updateDeliveryCount.decode(buffer);
                return updateDeliveryCount;
            }
            case 35: {
                if (info.isUpdate) {
                    JournalStorageManager.PageUpdateTXEncoding pageUpdate = new JournalStorageManager.PageUpdateTXEncoding();
                    pageUpdate.decode(buffer);
                    return pageUpdate;
                }
                PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                pageTransactionInfo.decode(buffer);
                pageTransactionInfo.setRecordID(info.id);
                return pageTransactionInfo;
            }
            case 36: {
                JournalStorageManager.ScheduledDeliveryEncoding encoding = new JournalStorageManager.ScheduledDeliveryEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 37: {
                JournalStorageManager.DuplicateIDEncoding encoding = new JournalStorageManager.DuplicateIDEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 38: {
                JournalStorageManager.HeuristicCompletionEncoding encoding = new JournalStorageManager.HeuristicCompletionEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 39: {
                JournalStorageManager.CursorAckRecordEncoding encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 40: {
                JournalStorageManager.PageCountRecord encoding = new JournalStorageManager.PageCountRecord();
                encoding.decode(buffer);
                return encoding;
            }
            case 42: {
                PageCompleteCursorAckRecordEncoding encoding = new PageCompleteCursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 41: {
                JournalStorageManager.PageCountRecordInc encoding = new JournalStorageManager.PageCountRecordInc();
                encoding.decode(buffer);
                return encoding;
            }
            case 21: {
                return JournalStorageManager.newBindingEncoding(id, buffer);
            }
            case 24: {
                BatchingIDGenerator.IDCounterEncoding idReturn = new BatchingIDGenerator.IDCounterEncoding();
                idReturn.decode(buffer);
                return idReturn;
            }
            case 20: {
                return JournalStorageManager.newGroupEncoding(id, buffer);
            }
            case 25: {
                return JournalStorageManager.newAddressEncoding(id, buffer);
            }
            case 26: {
                return JournalStorageManager.newSecurityRecord(id, buffer);
            }
        }
        return null;
    }

    public static final class ReferenceDescribe {
        public JournalStorageManager.RefEncoding refEncoding;

        public ReferenceDescribe(JournalStorageManager.RefEncoding refEncoding) {
            this.refEncoding = refEncoding;
        }

        public String toString() {
            return "AddRef;" + this.refEncoding;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.refEncoding == null ? 0 : this.refEncoding.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReferenceDescribe)) {
                return false;
            }
            ReferenceDescribe other = (ReferenceDescribe)obj;
            return !(this.refEncoding == null ? other.refEncoding != null : !this.refEncoding.equals(other.refEncoding));
        }
    }

    public static final class MessageDescribe {
        Message msg;

        public MessageDescribe(Message msg) {
            this.msg = msg;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.msg.isLargeMessage() ? "LargeMessage(" : "Message(");
            buffer.append("messageID=" + this.msg.getMessageID());
            buffer.append(";properties=[");
            Set properties = this.msg.getPropertyNames();
            for (SimpleString prop : properties) {
                Object value = this.msg.getObjectProperty(prop);
                if (value instanceof byte[]) {
                    buffer.append(prop + "=" + Arrays.toString((byte[])value) + ",");
                    continue;
                }
                buffer.append(prop + "=" + value + ",");
            }
            buffer.append("#properties = " + properties.size());
            buffer.append("]");
            buffer.append(" - " + this.msg.toString());
            return buffer.toString();
        }
    }

    private static final class PageCompleteCursorAckRecordEncoding
    extends JournalStorageManager.CursorAckRecordEncoding {
        private PageCompleteCursorAckRecordEncoding() {
        }

        @Override
        public String toString() {
            return "PGComplete [queueID=" + this.queueID + ", position=" + this.position + "]";
        }
    }
}

