/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hornetq.api.core.BroadcastEndpointFactoryConfiguration;
import org.hornetq.api.core.BroadcastGroupConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.JGroupsBroadcastGroupConfiguration;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.UDPBroadcastGroupConfiguration;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.DefaultSensitiveStringCodec;
import org.hornetq.utils.PasswordMaskingUtil;
import org.hornetq.utils.SensitiveDataCodec;
import org.hornetq.utils.XMLConfigurationUtil;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileConfigurationParser {
    private static final String CONFIGURATION_SCHEMA_URL = "schema/hornetq-configuration.xsd";
    public static final String SECURITY_ELEMENT_NAME = "security-setting";
    private static final String PERMISSION_ELEMENT_NAME = "permission";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String ROLES_ATTR_NAME = "roles";
    static final String CREATEDURABLEQUEUE_NAME = "createDurableQueue";
    private static final String DELETEDURABLEQUEUE_NAME = "deleteDurableQueue";
    private static final String CREATE_NON_DURABLE_QUEUE_NAME = "createNonDurableQueue";
    private static final String DELETE_NON_DURABLE_QUEUE_NAME = "deleteNonDurableQueue";
    private static final String CREATETEMPQUEUE_NAME = "createTempQueue";
    private static final String DELETETEMPQUEUE_NAME = "deleteTempQueue";
    private static final String SEND_NAME = "send";
    private static final String CONSUME_NAME = "consume";
    private static final String MANAGE_NAME = "manage";
    private static final String DEAD_LETTER_ADDRESS_NODE_NAME = "dead-letter-address";
    private static final String EXPIRY_ADDRESS_NODE_NAME = "expiry-address";
    private static final String EXPIRY_DELAY_NODE_NAME = "expiry-delay";
    private static final String REDELIVERY_DELAY_NODE_NAME = "redelivery-delay";
    private static final String REDELIVERY_DELAY_MULTIPLIER_NODE_NAME = "redelivery-delay-multiplier";
    private static final String MAX_REDELIVERY_DELAY_NODE_NAME = "max-redelivery-delay";
    private static final String MAX_DELIVERY_ATTEMPTS = "max-delivery-attempts";
    private static final String MAX_SIZE_BYTES_NODE_NAME = "max-size-bytes";
    private static final String ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME = "address-full-policy";
    private static final String PAGE_SIZE_BYTES_NODE_NAME = "page-size-bytes";
    private static final String PAGE_MAX_CACHE_SIZE_NODE_NAME = "page-max-cache-size";
    private static final String MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME = "message-counter-history-day-limit";
    private static final String LVQ_NODE_NAME = "last-value-queue";
    private static final String REDISTRIBUTION_DELAY_NODE_NAME = "redistribution-delay";
    private static final String SEND_TO_DLA_ON_NO_ROUTE = "send-to-dla-on-no-route";
    private boolean validateAIO = false;

    public boolean isValidateAIO() {
        return this.validateAIO;
    }

    public void setValidateAIO(boolean validateAIO) {
        this.validateAIO = validateAIO;
    }

    public Configuration parseMainConfig(InputStream input) throws Exception {
        InputStreamReader reader = new InputStreamReader(input);
        String xml = XMLUtil.readerToString((Reader)reader);
        xml = XMLUtil.replaceSystemProps((String)xml);
        Element e = XMLUtil.stringToElement((String)xml);
        ConfigurationImpl config = new ConfigurationImpl();
        this.parseMainConfig(e, config);
        return config;
    }

    public void parseMainConfig(Element e, Configuration config) throws Exception {
        int i;
        NodeList incomingInterceptorNodes;
        XMLUtil.validate((Node)e, (String)CONFIGURATION_SCHEMA_URL);
        config.setName(XMLConfigurationUtil.getString(e, "name", config.getName(), Validators.NO_CHECK));
        NodeList elems = e.getElementsByTagName("clustered");
        if (elems != null && elems.getLength() > -1) {
            HornetQServerLogger.LOGGER.deprecatedConfigurationOption("clustered");
        }
        config.setCheckForLiveServer(XMLConfigurationUtil.getBoolean(e, "check-for-live-server", config.isClustered()));
        config.setAllowAutoFailBack(XMLConfigurationUtil.getBoolean(e, "allow-failback", config.isClustered()));
        config.setBackupGroupName(XMLConfigurationUtil.getString(e, "backup-group-name", config.getBackupGroupName(), Validators.NO_CHECK));
        config.setFailbackDelay(XMLConfigurationUtil.getLong(e, "failback-delay", config.getFailbackDelay(), Validators.GT_ZERO));
        config.setFailoverOnServerShutdown(XMLConfigurationUtil.getBoolean(e, "failover-on-shutdown", config.isFailoverOnServerShutdown()));
        config.setReplicationClustername(XMLConfigurationUtil.getString(e, "replication-clustername", null, Validators.NO_CHECK));
        config.setBackup(XMLConfigurationUtil.getBoolean(e, "backup", config.isBackup()));
        config.setSharedStore(XMLConfigurationUtil.getBoolean(e, "shared-store", config.isSharedStore()));
        config.setFileDeploymentEnabled(XMLConfigurationUtil.getBoolean(e, "file-deployment-enabled", config instanceof FileConfiguration));
        config.setPersistenceEnabled(XMLConfigurationUtil.getBoolean(e, "persistence-enabled", config.isPersistenceEnabled()));
        config.setPersistDeliveryCountBeforeDelivery(XMLConfigurationUtil.getBoolean(e, "persist-delivery-count-before-delivery", config.isPersistDeliveryCountBeforeDelivery()));
        config.setScheduledThreadPoolMaxSize(XMLConfigurationUtil.getInteger(e, "scheduled-thread-pool-max-size", config.getScheduledThreadPoolMaxSize(), Validators.GT_ZERO));
        config.setThreadPoolMaxSize(XMLConfigurationUtil.getInteger(e, "thread-pool-max-size", config.getThreadPoolMaxSize(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setSecurityEnabled(XMLConfigurationUtil.getBoolean(e, "security-enabled", config.isSecurityEnabled()));
        config.setJMXManagementEnabled(XMLConfigurationUtil.getBoolean(e, "jmx-management-enabled", config.isJMXManagementEnabled()));
        config.setJMXDomain(XMLConfigurationUtil.getString(e, "jmx-domain", config.getJMXDomain(), Validators.NOT_NULL_OR_EMPTY));
        config.setSecurityInvalidationInterval(XMLConfigurationUtil.getLong(e, "security-invalidation-interval", config.getSecurityInvalidationInterval(), Validators.GT_ZERO));
        config.setConnectionTTLOverride(XMLConfigurationUtil.getLong(e, "connection-ttl-override", config.getConnectionTTLOverride(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setEnabledAsyncConnectionExecution(XMLConfigurationUtil.getBoolean(e, "async-connection-execution-enabled", config.isAsyncConnectionExecutionEnabled()));
        config.setTransactionTimeout(XMLConfigurationUtil.getLong(e, "transaction-timeout", config.getTransactionTimeout(), Validators.GT_ZERO));
        config.setTransactionTimeoutScanPeriod(XMLConfigurationUtil.getLong(e, "transaction-timeout-scan-period", config.getTransactionTimeoutScanPeriod(), Validators.GT_ZERO));
        config.setMessageExpiryScanPeriod(XMLConfigurationUtil.getLong(e, "message-expiry-scan-period", config.getMessageExpiryScanPeriod(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMessageExpiryThreadPriority(XMLConfigurationUtil.getInteger(e, "message-expiry-thread-priority", config.getMessageExpiryThreadPriority(), Validators.THREAD_PRIORITY_RANGE));
        config.setIDCacheSize(XMLConfigurationUtil.getInteger(e, "id-cache-size", config.getIDCacheSize(), Validators.GT_ZERO));
        config.setPersistIDCache(XMLConfigurationUtil.getBoolean(e, "persist-id-cache", config.isPersistIDCache()));
        config.setManagementAddress(new SimpleString(XMLConfigurationUtil.getString(e, "management-address", config.getManagementAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setManagementNotificationAddress(new SimpleString(XMLConfigurationUtil.getString(e, "management-notification-address", config.getManagementNotificationAddress().toString(), Validators.NOT_NULL_OR_EMPTY)));
        config.setMaskPassword(XMLConfigurationUtil.getBoolean(e, "mask-password", false));
        config.setPasswordCodec(XMLConfigurationUtil.getString(e, "password-codec", DefaultSensitiveStringCodec.class.getName(), Validators.NOT_NULL_OR_EMPTY));
        String passwordText = XMLConfigurationUtil.getString(e, "cluster-password", null, Validators.NO_CHECK);
        boolean maskText = config.isMaskPassword();
        if (passwordText != null) {
            if (maskText) {
                SensitiveDataCodec codec = PasswordMaskingUtil.getCodec((String)config.getPasswordCodec());
                config.setClusterPassword((String)codec.decode((Object)passwordText));
            } else {
                config.setClusterPassword(passwordText);
            }
        }
        config.setClusterUser(XMLConfigurationUtil.getString(e, "cluster-user", config.getClusterUser(), Validators.NO_CHECK));
        NodeList interceptorNodes = e.getElementsByTagName("remoting-interceptors");
        ArrayList<String> incomingInterceptorList = new ArrayList<String>();
        if (interceptorNodes.getLength() > 0) {
            NodeList interceptors = interceptorNodes.item(0).getChildNodes();
            for (int i2 = 0; i2 < interceptors.getLength(); ++i2) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i2).getNodeName())) continue;
                String clazz = interceptors.item(i2).getTextContent();
                incomingInterceptorList.add(clazz);
            }
        }
        if ((incomingInterceptorNodes = e.getElementsByTagName("remoting-incoming-interceptors")).getLength() > 0) {
            NodeList interceptors = incomingInterceptorNodes.item(0).getChildNodes();
            for (int i3 = 0; i3 < interceptors.getLength(); ++i3) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i3).getNodeName())) continue;
                String clazz = interceptors.item(i3).getTextContent();
                incomingInterceptorList.add(clazz);
            }
        }
        config.setIncomingInterceptorClassNames(incomingInterceptorList);
        NodeList outgoingInterceptorNodes = e.getElementsByTagName("remoting-outgoing-interceptors");
        ArrayList<String> outgoingInterceptorList = new ArrayList<String>();
        if (outgoingInterceptorNodes.getLength() > 0) {
            NodeList interceptors = outgoingInterceptorNodes.item(0).getChildNodes();
            for (i = 0; i < interceptors.getLength(); ++i) {
                if (!"class-name".equalsIgnoreCase(interceptors.item(i).getNodeName())) continue;
                String clazz = interceptors.item(i).getTextContent();
                outgoingInterceptorList.add(clazz);
            }
        }
        config.setOutgoingInterceptorClassNames(outgoingInterceptorList);
        NodeList connectorNodes = e.getElementsByTagName("connector");
        for (i = 0; i < connectorNodes.getLength(); ++i) {
            Element connectorNode = (Element)connectorNodes.item(i);
            TransportConfiguration connectorConfig = this.parseTransportConfiguration(connectorNode, config);
            if (connectorConfig.getName() == null) {
                HornetQServerLogger.LOGGER.connectorWithNoName();
                continue;
            }
            if (config.getConnectorConfigurations().containsKey(connectorConfig.getName())) {
                HornetQServerLogger.LOGGER.connectorAlreadyDeployed(connectorConfig.getName());
                continue;
            }
            config.getConnectorConfigurations().put(connectorConfig.getName(), connectorConfig);
        }
        NodeList acceptorNodes = e.getElementsByTagName("acceptor");
        for (int i4 = 0; i4 < acceptorNodes.getLength(); ++i4) {
            Element acceptorNode = (Element)acceptorNodes.item(i4);
            TransportConfiguration acceptorConfig = this.parseTransportConfiguration(acceptorNode, config);
            config.getAcceptorConfigurations().add(acceptorConfig);
        }
        NodeList bgNodes = e.getElementsByTagName("broadcast-group");
        for (int i5 = 0; i5 < bgNodes.getLength(); ++i5) {
            Element bgNode = (Element)bgNodes.item(i5);
            this.parseBroadcastGroupConfiguration(bgNode, config);
        }
        NodeList dgNodes = e.getElementsByTagName("discovery-group");
        for (int i6 = 0; i6 < dgNodes.getLength(); ++i6) {
            Element dgNode = (Element)dgNodes.item(i6);
            this.parseDiscoveryGroupConfiguration(dgNode, config);
        }
        NodeList brNodes = e.getElementsByTagName("bridge");
        for (int i7 = 0; i7 < brNodes.getLength(); ++i7) {
            Element mfNode = (Element)brNodes.item(i7);
            this.parseBridgeConfiguration(mfNode, config);
        }
        NodeList gaNodes = e.getElementsByTagName("grouping-handler");
        for (int i8 = 0; i8 < gaNodes.getLength(); ++i8) {
            Element gaNode = (Element)gaNodes.item(i8);
            this.parseGroupingHandlerConfiguration(gaNode, config);
        }
        NodeList ccNodes = e.getElementsByTagName("cluster-connection");
        for (int i9 = 0; i9 < ccNodes.getLength(); ++i9) {
            Element ccNode = (Element)ccNodes.item(i9);
            this.parseClusterConnectionConfiguration(ccNode, config);
        }
        NodeList dvNodes = e.getElementsByTagName("divert");
        for (int i10 = 0; i10 < dvNodes.getLength(); ++i10) {
            Element dvNode = (Element)dvNodes.item(i10);
            this.parseDivertConfiguration(dvNode, config);
        }
        config.setLargeMessagesDirectory(XMLConfigurationUtil.getString(e, "large-messages-directory", config.getLargeMessagesDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setBindingsDirectory(XMLConfigurationUtil.getString(e, "bindings-directory", config.getBindingsDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateBindingsDir(XMLConfigurationUtil.getBoolean(e, "create-bindings-dir", config.isCreateBindingsDir()));
        config.setJournalDirectory(XMLConfigurationUtil.getString(e, "journal-directory", config.getJournalDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setPageMaxConcurrentIO(XMLConfigurationUtil.getInteger(e, "page-max-concurrent-io", 5, Validators.MINUS_ONE_OR_GT_ZERO));
        config.setPagingDirectory(XMLConfigurationUtil.getString(e, "paging-directory", config.getPagingDirectory(), Validators.NOT_NULL_OR_EMPTY));
        config.setCreateJournalDir(XMLConfigurationUtil.getBoolean(e, "create-journal-dir", config.isCreateJournalDir()));
        String s = XMLConfigurationUtil.getString(e, "journal-type", config.getJournalType().toString(), Validators.JOURNAL_TYPE);
        if (s.equals(JournalType.NIO.toString())) {
            config.setJournalType(JournalType.NIO);
        } else if (s.equals(JournalType.ASYNCIO.toString())) {
            boolean supportsAIO = AIOSequentialFileFactory.isSupported();
            if (supportsAIO) {
                config.setJournalType(JournalType.ASYNCIO);
            } else {
                if (this.validateAIO) {
                    HornetQServerLogger.LOGGER.AIONotFound();
                }
                config.setJournalType(JournalType.NIO);
            }
        }
        config.setJournalSyncTransactional(XMLConfigurationUtil.getBoolean(e, "journal-sync-transactional", config.isJournalSyncTransactional()));
        config.setJournalSyncNonTransactional(XMLConfigurationUtil.getBoolean(e, "journal-sync-non-transactional", config.isJournalSyncNonTransactional()));
        config.setJournalFileSize(XMLConfigurationUtil.getInteger(e, "journal-file-size", config.getJournalFileSize(), Validators.GT_ZERO));
        int journalBufferTimeout = XMLConfigurationUtil.getInteger(e, "journal-buffer-timeout", config.getJournalType() == JournalType.ASYNCIO ? 500000 : 3333333, Validators.GT_ZERO);
        int journalBufferSize = XMLConfigurationUtil.getInteger(e, "journal-buffer-size", config.getJournalType() == JournalType.ASYNCIO ? 501760 : 501760, Validators.GT_ZERO);
        int journalMaxIO = XMLConfigurationUtil.getInteger(e, "journal-max-io", config.getJournalType() == JournalType.ASYNCIO ? 500 : 1, Validators.GT_ZERO);
        if (config.getJournalType() == JournalType.ASYNCIO) {
            config.setJournalBufferTimeout_AIO(journalBufferTimeout);
            config.setJournalBufferSize_AIO(journalBufferSize);
            config.setJournalMaxIO_AIO(journalMaxIO);
        } else {
            config.setJournalBufferTimeout_NIO(journalBufferTimeout);
            config.setJournalBufferSize_NIO(journalBufferSize);
            config.setJournalMaxIO_NIO(journalMaxIO);
        }
        config.setJournalMinFiles(XMLConfigurationUtil.getInteger(e, "journal-min-files", config.getJournalMinFiles(), Validators.GT_ZERO));
        config.setJournalCompactMinFiles(XMLConfigurationUtil.getInteger(e, "journal-compact-min-files", config.getJournalCompactMinFiles(), Validators.GE_ZERO));
        config.setJournalCompactPercentage(XMLConfigurationUtil.getInteger(e, "journal-compact-percentage", config.getJournalCompactPercentage(), Validators.PERCENTAGE));
        config.setLogJournalWriteRate(XMLConfigurationUtil.getBoolean(e, "log-journal-write-rate", false));
        config.setJournalPerfBlastPages(XMLConfigurationUtil.getInteger(e, "perf-blast-pages", -1, Validators.MINUS_ONE_OR_GT_ZERO));
        config.setRunSyncSpeedTest(XMLConfigurationUtil.getBoolean(e, "run-sync-speed-test", config.isRunSyncSpeedTest()));
        config.setWildcardRoutingEnabled(XMLConfigurationUtil.getBoolean(e, "wild-card-routing-enabled", config.isWildcardRoutingEnabled()));
        config.setMessageCounterEnabled(XMLConfigurationUtil.getBoolean(e, "message-counter-enabled", config.isMessageCounterEnabled()));
        config.setMessageCounterSamplePeriod(XMLConfigurationUtil.getLong(e, "message-counter-sample-period", config.getMessageCounterSamplePeriod(), Validators.GT_ZERO));
        config.setMessageCounterMaxDayHistory(XMLConfigurationUtil.getInteger(e, "message-counter-max-day-history", config.getMessageCounterMaxDayHistory(), Validators.GT_ZERO));
        config.setServerDumpInterval(XMLConfigurationUtil.getLong(e, "server-dump-interval", config.getServerDumpInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        config.setMemoryWarningThreshold(XMLConfigurationUtil.getInteger(e, "memory-warning-threshold", config.getMemoryWarningThreshold(), Validators.PERCENTAGE));
        config.setMemoryMeasureInterval(XMLConfigurationUtil.getLong(e, "memory-measure-interval", config.getMemoryMeasureInterval(), Validators.MINUS_ONE_OR_GT_ZERO));
        this.parseAddressSettings(e, config);
        this.parseQueues(e, config);
        this.parseSecurity(e, config);
        NodeList connectorServiceConfigs = e.getElementsByTagName("connector-service");
        ArrayList<ConnectorServiceConfiguration> configs = new ArrayList<ConnectorServiceConfiguration>();
        for (int i11 = 0; i11 < connectorServiceConfigs.getLength(); ++i11) {
            Element node = (Element)connectorServiceConfigs.item(i11);
            configs.add(this.parseConnectorService(node));
        }
        config.setConnectorServiceConfigurations(configs);
    }

    private void parseSecurity(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("security-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName(SECURITY_ELEMENT_NAME);
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, Set<Role>> securityItem = this.parseSecurityRoles(list.item(i));
                config.getSecurityRoles().put((String)securityItem.getA(), (Set<Role>)securityItem.getB());
            }
        }
    }

    private void parseQueues(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("queues");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("queue");
            for (int i = 0; i < list.getLength(); ++i) {
                CoreQueueConfiguration queueConfig = this.parseQueueConfiguration(list.item(i));
                config.getQueueConfigurations().add(queueConfig);
            }
        }
    }

    private void parseAddressSettings(Element e, Configuration config) {
        NodeList elements = e.getElementsByTagName("address-settings");
        if (elements.getLength() != 0) {
            Element node = (Element)elements.item(0);
            NodeList list = node.getElementsByTagName("address-setting");
            for (int i = 0; i < list.getLength(); ++i) {
                Pair<String, AddressSettings> addressSettings = this.parseAddressSettings(list.item(i));
                config.getAddressesSettings().put((String)addressSettings.getA(), (AddressSettings)addressSettings.getB());
            }
        }
    }

    protected Pair<String, Set<Role>> parseSecurityRoles(Node node) {
        String match = node.getAttributes().getNamedItem("match").getNodeValue();
        HashSet<Role> securityRoles = new HashSet<Role>();
        Pair securityMatch = new Pair((Object)match, securityRoles);
        ArrayList<String> send = new ArrayList<String>();
        ArrayList<String> consume = new ArrayList<String>();
        ArrayList<String> createDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteDurableQueue = new ArrayList<String>();
        ArrayList<String> createNonDurableQueue = new ArrayList<String>();
        ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
        ArrayList<String> manageRoles = new ArrayList<String>();
        ArrayList<String> allRoles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String[] roles;
            Node child = children.item(i);
            if (!PERMISSION_ELEMENT_NAME.equalsIgnoreCase(child.getNodeName())) continue;
            String type = child.getAttributes().getNamedItem(TYPE_ATTR_NAME).getNodeValue();
            String roleString = child.getAttributes().getNamedItem(ROLES_ATTR_NAME).getNodeValue();
            for (String role : roles = roleString.split(",")) {
                if (SEND_NAME.equals(type)) {
                    send.add(role.trim());
                } else if (CONSUME_NAME.equals(type)) {
                    consume.add(role.trim());
                } else if (CREATEDURABLEQUEUE_NAME.equals(type)) {
                    createDurableQueue.add(role.trim());
                } else if (DELETEDURABLEQUEUE_NAME.equals(type)) {
                    deleteDurableQueue.add(role.trim());
                } else if (CREATE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETE_NON_DURABLE_QUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (CREATETEMPQUEUE_NAME.equals(type)) {
                    createNonDurableQueue.add(role.trim());
                } else if (DELETETEMPQUEUE_NAME.equals(type)) {
                    deleteNonDurableQueue.add(role.trim());
                } else if (MANAGE_NAME.equals(type)) {
                    manageRoles.add(role.trim());
                }
                if (allRoles.contains(role.trim())) continue;
                allRoles.add(role.trim());
            }
        }
        for (String role : allRoles) {
            securityRoles.add(new Role(role, send.contains(role), consume.contains(role), createDurableQueue.contains(role), deleteDurableQueue.contains(role), createNonDurableQueue.contains(role), deleteNonDurableQueue.contains(role), manageRoles.contains(role)));
        }
        return securityMatch;
    }

    protected Pair<String, AddressSettings> parseAddressSettings(Node node) {
        String match = node.getAttributes().getNamedItem("match").getNodeValue();
        NodeList children = node.getChildNodes();
        AddressSettings addressSettings = new AddressSettings();
        Pair setting = new Pair((Object)match, (Object)addressSettings);
        for (int i = 0; i < children.getLength(); ++i) {
            SimpleString queueName;
            Node child = children.item(i);
            if (DEAD_LETTER_ADDRESS_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                queueName = new SimpleString(child.getTextContent());
                addressSettings.setDeadLetterAddress(queueName);
                continue;
            }
            if (EXPIRY_ADDRESS_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                queueName = new SimpleString(child.getTextContent());
                addressSettings.setExpiryAddress(queueName);
                continue;
            }
            if (EXPIRY_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setExpiryDelay(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setRedeliveryDelay(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (REDELIVERY_DELAY_MULTIPLIER_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setRedeliveryMultiplier(Double.valueOf(child.getTextContent()));
                continue;
            }
            if (MAX_REDELIVERY_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMaxRedeliveryDelay(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (MAX_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMaxSizeBytes(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (PAGE_SIZE_BYTES_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setPageSizeBytes(Long.valueOf(child.getTextContent()));
                continue;
            }
            if (PAGE_MAX_CACHE_SIZE_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setPageCacheMaxSize(Integer.valueOf(child.getTextContent()));
                continue;
            }
            if (MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMessageCounterHistoryDayLimit(Integer.valueOf(child.getTextContent()));
                continue;
            }
            if (ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                String value = child.getTextContent().trim();
                Validators.ADDRESS_FULL_MESSAGE_POLICY_TYPE.validate(ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, value);
                AddressFullMessagePolicy policy = null;
                if (value.equals(AddressFullMessagePolicy.BLOCK.toString())) {
                    policy = AddressFullMessagePolicy.BLOCK;
                } else if (value.equals(AddressFullMessagePolicy.DROP.toString())) {
                    policy = AddressFullMessagePolicy.DROP;
                } else if (value.equals(AddressFullMessagePolicy.PAGE.toString())) {
                    policy = AddressFullMessagePolicy.PAGE;
                } else if (value.equals(AddressFullMessagePolicy.FAIL.toString())) {
                    policy = AddressFullMessagePolicy.FAIL;
                }
                addressSettings.setAddressFullMessagePolicy(policy);
                continue;
            }
            if (LVQ_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setLastValueQueue(Boolean.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (MAX_DELIVERY_ATTEMPTS.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setMaxDeliveryAttempts(Integer.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (REDISTRIBUTION_DELAY_NODE_NAME.equalsIgnoreCase(child.getNodeName())) {
                addressSettings.setRedistributionDelay(Long.valueOf(child.getTextContent().trim()));
                continue;
            }
            if (!SEND_TO_DLA_ON_NO_ROUTE.equalsIgnoreCase(child.getNodeName())) continue;
            addressSettings.setSendToDLAOnNoRoute(Boolean.valueOf(child.getTextContent().trim()));
        }
        return setting;
    }

    protected CoreQueueConfiguration parseQueueConfiguration(Node node) {
        String name = node.getAttributes().getNamedItem("name").getNodeValue();
        String address = null;
        String filterString = null;
        boolean durable = true;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("address")) {
                address = child.getTextContent().trim();
                continue;
            }
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("durable")) continue;
            durable = Boolean.parseBoolean(child.getTextContent().trim());
        }
        return new CoreQueueConfiguration(address, name, filterString, durable);
    }

    private TransportConfiguration parseTransportConfiguration(Element e, Configuration mainConfig) {
        Node nameNode = e.getAttributes().getNamedItem("name");
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = XMLConfigurationUtil.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (mainConfig.isMaskPassword()) {
            params.put("hornetq.usemaskedpassword", mainConfig.isMaskPassword());
            if (mainConfig.getPasswordCodec() != null) {
                params.put("hornetq.passwordcodec", mainConfig.getPasswordCodec());
            }
        }
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem("value");
            params.put(key, nValue.getTextContent());
        }
        return new TransportConfiguration(clazz, params, name);
    }

    private void parseBroadcastGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        ArrayList<String> connectorNames = new ArrayList<String>();
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("connector-ref")) continue;
            String connectorName = XMLConfigurationUtil.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
            connectorNames.add(connectorName);
        }
        long broadcastPeriod = XMLConfigurationUtil.getLong(e, "broadcast-period", 2000L, Validators.GT_ZERO);
        String localAddress = XMLConfigurationUtil.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = XMLConfigurationUtil.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = XMLConfigurationUtil.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = XMLConfigurationUtil.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = XMLConfigurationUtil.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = XMLConfigurationUtil.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactoryConfiguration = jgroupsFile != null ? new JGroupsBroadcastGroupConfiguration(jgroupsFile, jgroupsChannel) : new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localAddress, localBindPort);
        BroadcastGroupConfiguration config = new BroadcastGroupConfiguration(name, broadcastPeriod, connectorNames, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
        mainConfig.getBroadcastGroupConfigurations().add(config);
    }

    private void parseDiscoveryGroupConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        long discoveryInitialWaitTimeout = XMLConfigurationUtil.getLong(e, "initial-wait-timeout", 10000L, Validators.GT_ZERO);
        long refreshTimeout = XMLConfigurationUtil.getLong(e, "refresh-timeout", 10000L, Validators.GT_ZERO);
        String localBindAddress = XMLConfigurationUtil.getString(e, "local-bind-address", null, Validators.NO_CHECK);
        int localBindPort = XMLConfigurationUtil.getInteger(e, "local-bind-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String groupAddress = XMLConfigurationUtil.getString(e, "group-address", null, Validators.NO_CHECK);
        int groupPort = XMLConfigurationUtil.getInteger(e, "group-port", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String jgroupsFile = XMLConfigurationUtil.getString(e, "jgroups-file", null, Validators.NO_CHECK);
        String jgroupsChannel = XMLConfigurationUtil.getString(e, "jgroups-channel", null, Validators.NO_CHECK);
        Object endpointFactoryConfiguration = jgroupsFile != null ? new JGroupsBroadcastGroupConfiguration(jgroupsFile, jgroupsChannel) : new UDPBroadcastGroupConfiguration(groupAddress, groupPort, localBindAddress, localBindPort);
        DiscoveryGroupConfiguration config = new DiscoveryGroupConfiguration(name, refreshTimeout, discoveryInitialWaitTimeout, (BroadcastEndpointFactoryConfiguration)endpointFactoryConfiguration);
        if (mainConfig.getDiscoveryGroupConfigurations().containsKey(name)) {
            HornetQServerLogger.LOGGER.discoveryGroupAlreadyDeployed(name);
            return;
        }
        mainConfig.getDiscoveryGroupConfigurations().put(name, config);
    }

    private void parseClusterConnectionConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        String address = XMLConfigurationUtil.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String connectorName = XMLConfigurationUtil.getString(e, "connector-ref", null, Validators.NOT_NULL_OR_EMPTY);
        boolean duplicateDetection = XMLConfigurationUtil.getBoolean(e, "use-duplicate-detection", true);
        boolean forwardWhenNoConsumers = XMLConfigurationUtil.getBoolean(e, "forward-when-no-consumers", false);
        int maxHops = XMLConfigurationUtil.getInteger(e, "max-hops", 1, Validators.GE_ZERO);
        long clientFailureCheckPeriod = XMLConfigurationUtil.getLong(e, "check-period", 30000L, Validators.GT_ZERO);
        long connectionTTL = XMLConfigurationUtil.getLong(e, "connection-ttl", 60000L, Validators.GT_ZERO);
        long retryInterval = XMLConfigurationUtil.getLong(e, "retry-interval", 500L, Validators.GT_ZERO);
        long callTimeout = XMLConfigurationUtil.getLong(e, "call-timeout", 30000L, Validators.GT_ZERO);
        long callFailoverTimeout = XMLConfigurationUtil.getLong(e, "call-failover-timeout", -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        double retryIntervalMultiplier = XMLConfigurationUtil.getDouble(e, "retry-interval-multiplier", 1.0, Validators.GT_ZERO);
        int minLargeMessageSize = XMLConfigurationUtil.getInteger(e, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = XMLConfigurationUtil.getLong(e, "max-retry-interval", 2000L, Validators.GT_ZERO);
        int reconnectAttempts = XMLConfigurationUtil.getInteger(e, "reconnect-attempts", -1, Validators.MINUS_ONE_OR_GE_ZERO);
        int confirmationWindowSize = XMLConfigurationUtil.getInteger(e, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        long clusterNotificationInterval = XMLConfigurationUtil.getLong(e, "notification-interval", 1000L, Validators.GT_ZERO);
        int clusterNotificationAttempts = XMLConfigurationUtil.getInteger(e, "notification-attempts", 2, Validators.GT_ZERO);
        String discoveryGroupName = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        boolean allowDirectConnectionsOnly = false;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            Node attr = child.getAttributes().getNamedItem("allow-direct-connections-only");
            if (attr != null) {
                allowDirectConnectionsOnly = "true".equalsIgnoreCase(attr.getNodeValue()) || allowDirectConnectionsOnly;
            }
            this.getStaticConnectors(staticConnectorNames, child);
        }
        ClusterConnectionConfiguration config = discoveryGroupName == null ? new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectorNames, allowDirectConnectionsOnly, clusterNotificationInterval, clusterNotificationAttempts) : new ClusterConnectionConfiguration(name, address, connectorName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, retryIntervalMultiplier, maxRetryInterval, reconnectAttempts, callTimeout, callFailoverTimeout, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName, clusterNotificationInterval, clusterNotificationAttempts);
        mainConfig.getClusterConfigurations().add(config);
    }

    private void parseGroupingHandlerConfiguration(Element node, Configuration mainConfiguration) {
        String name = node.getAttribute("name");
        String type = XMLConfigurationUtil.getString(node, TYPE_ATTR_NAME, null, Validators.NOT_NULL_OR_EMPTY);
        String address = XMLConfigurationUtil.getString(node, "address", null, Validators.NOT_NULL_OR_EMPTY);
        Integer timeout = XMLConfigurationUtil.getInteger(node, "timeout", 5000, Validators.GT_ZERO);
        mainConfiguration.setGroupingHandlerConfiguration(new GroupingHandlerConfiguration(new SimpleString(name), type.equals(GroupingHandlerConfiguration.TYPE.LOCAL.getType()) ? GroupingHandlerConfiguration.TYPE.LOCAL : GroupingHandlerConfiguration.TYPE.REMOTE, new SimpleString(address), timeout));
    }

    private void parseBridgeConfiguration(Element brNode, Configuration mainConfig) throws Exception {
        String name = brNode.getAttribute("name");
        String queueName = XMLConfigurationUtil.getString(brNode, "queue-name", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = XMLConfigurationUtil.getString(brNode, "forwarding-address", null, Validators.NO_CHECK);
        String transformerClassName = XMLConfigurationUtil.getString(brNode, "transformer-class-name", null, Validators.NO_CHECK);
        int confirmationWindowSize = XMLConfigurationUtil.getInteger(brNode, "confirmation-window-size", 0x100000, Validators.GT_ZERO);
        long retryInterval = XMLConfigurationUtil.getLong(brNode, "retry-interval", 2000L, Validators.GT_ZERO);
        long clientFailureCheckPeriod = XMLConfigurationUtil.getLong(brNode, "check-period", 30000L, Validators.GT_ZERO);
        long connectionTTL = XMLConfigurationUtil.getLong(brNode, "connection-ttl", 60000L, Validators.GT_ZERO);
        int minLargeMessageSize = XMLConfigurationUtil.getInteger(brNode, "min-large-message-size", 102400, Validators.GT_ZERO);
        long maxRetryInterval = XMLConfigurationUtil.getLong(brNode, "max-retry-interval", 2000L, Validators.GT_ZERO);
        double retryIntervalMultiplier = XMLConfigurationUtil.getDouble(brNode, "retry-interval-multiplier", 1.0, Validators.GT_ZERO);
        int reconnectAttempts = XMLConfigurationUtil.getInteger(brNode, "reconnect-attempts", -1, Validators.MINUS_ONE_OR_GE_ZERO);
        boolean useDuplicateDetection = XMLConfigurationUtil.getBoolean(brNode, "use-duplicate-detection", true);
        String user = XMLConfigurationUtil.getString(brNode, "user", "HORNETQ.CLUSTER.ADMIN.USER", Validators.NO_CHECK);
        NodeList clusterPassNodes = brNode.getElementsByTagName("password");
        String password = null;
        boolean maskPassword = mainConfig.isMaskPassword();
        SensitiveDataCodec codec = null;
        if (clusterPassNodes.getLength() > 0) {
            Node passNode = clusterPassNodes.item(0);
            password = passNode.getTextContent();
        }
        if (password != null) {
            if (maskPassword) {
                codec = PasswordMaskingUtil.getCodec((String)mainConfig.getPasswordCodec());
                password = (String)codec.decode((Object)password);
            }
        } else {
            password = "CHANGE ME!!";
        }
        boolean ha = XMLConfigurationUtil.getBoolean(brNode, "ha", false);
        String filterString = null;
        ArrayList<String> staticConnectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = brNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeName().equals("filter")) {
                filterString = child.getAttributes().getNamedItem("string").getNodeValue();
                continue;
            }
            if (child.getNodeName().equals("discovery-group-ref")) {
                discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
                continue;
            }
            if (!child.getNodeName().equals("static-connectors")) continue;
            this.getStaticConnectors(staticConnectorNames, child);
        }
        BridgeConfiguration config = !staticConnectorNames.isEmpty() ? new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, staticConnectorNames, ha, user, password) : new BridgeConfiguration(name, queueName, forwardingAddress, filterString, transformerClassName, minLargeMessageSize, clientFailureCheckPeriod, connectionTTL, retryInterval, maxRetryInterval, retryIntervalMultiplier, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, discoveryGroupName, ha, user, password);
        mainConfig.getBridgeConfigurations().add(config);
    }

    private void getStaticConnectors(List<String> staticConnectorNames, Node child) {
        NodeList children2 = ((Element)child).getElementsByTagName("connector-ref");
        for (int k = 0; k < children2.getLength(); ++k) {
            Element child2 = (Element)children2.item(k);
            String connectorName = child2.getChildNodes().item(0).getNodeValue();
            staticConnectorNames.add(connectorName);
        }
    }

    private void parseDivertConfiguration(Element e, Configuration mainConfig) {
        String name = e.getAttribute("name");
        String routingName = XMLConfigurationUtil.getString(e, "routing-name", null, Validators.NO_CHECK);
        String address = XMLConfigurationUtil.getString(e, "address", null, Validators.NOT_NULL_OR_EMPTY);
        String forwardingAddress = XMLConfigurationUtil.getString(e, "forwarding-address", null, Validators.NOT_NULL_OR_EMPTY);
        boolean exclusive = XMLConfigurationUtil.getBoolean(e, "exclusive", false);
        String transformerClassName = XMLConfigurationUtil.getString(e, "transformer-class-name", null, Validators.NO_CHECK);
        String filterString = null;
        NodeList children = e.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (!child.getNodeName().equals("filter")) continue;
            filterString = child.getAttributes().getNamedItem("string").getNodeValue();
        }
        DivertConfiguration config = new DivertConfiguration(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName);
        mainConfig.getDivertConfigurations().add(config);
    }

    private ConnectorServiceConfiguration parseConnectorService(Element e) {
        Node nameNode = e.getAttributes().getNamedItem("name");
        String name = nameNode != null ? nameNode.getNodeValue() : null;
        String clazz = XMLConfigurationUtil.getString(e, "factory-class", null, Validators.NOT_NULL_OR_EMPTY);
        HashMap<String, Object> params = new HashMap<String, Object>();
        NodeList paramsNodes = e.getElementsByTagName("param");
        for (int i = 0; i < paramsNodes.getLength(); ++i) {
            Node paramNode = paramsNodes.item(i);
            NamedNodeMap attributes = paramNode.getAttributes();
            Node nkey = attributes.getNamedItem("key");
            String key = nkey.getTextContent();
            Node nValue = attributes.getNamedItem("value");
            params.put(key, nValue.getTextContent());
        }
        return new ConnectorServiceConfiguration(clazz, params, name);
    }
}

