/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.hornetq.core.server.HornetQMessageBundle;

public final class ClusterConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 8948303813427795935L;
    private final String name;
    private final String address;
    private final String connectorName;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private long callTimeout;
    private long callFailoverTimeout;
    private boolean duplicateDetection;
    private boolean forwardWhenNoConsumers;
    private final List<String> staticConnectors;
    private final String discoveryGroupName;
    private final int maxHops;
    private final int confirmationWindowSize;
    private final boolean allowDirectConnectionsOnly;
    private int minLargeMessageSize;
    private final long clusterNotificationInterval;
    private final int clusterNotificationAttempts;

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<String> staticConnectors, boolean allowDirectConnectionsOnly) {
        this(name, address, connectorName, 102400, 30000L, 60000L, retryInterval, 1.0, 2000L, -1, 30000L, -1L, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, staticConnectors, allowDirectConnectionsOnly, 1000L, 2);
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, long callTimeout, long callFAiloverTimeout, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<String> staticConnectors, boolean allowDirectConnectionsOnly, long clusterNotificationInterval, int clusterNotificationAttempts) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        if (retryInterval <= 0L) {
            throw HornetQMessageBundle.BUNDLE.invalidRetryInterval(retryInterval);
        }
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.staticConnectors = staticConnectors != null ? staticConnectors : Collections.emptyList();
        this.duplicateDetection = duplicateDetection;
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFAiloverTimeout;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
        this.minLargeMessageSize = minLargeMessageSize;
        this.clusterNotificationInterval = clusterNotificationInterval;
        this.clusterNotificationAttempts = clusterNotificationAttempts;
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName) {
        this(name, address, connectorName, 102400, 30000L, 60000L, retryInterval, 1.0, 2000L, -1, 30000L, -1L, duplicateDetection, forwardWhenNoConsumers, maxHops, confirmationWindowSize, discoveryGroupName, 1000L, 2);
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, int minLargeMessageSize, long clientFailureCheckPeriod, long connectionTTL, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, long callTimeout, long callFailoverTimeout, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName, long clusterNotificationInterval, int clusterNotificationAttempts) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        this.connectionTTL = connectionTTL;
        this.retryInterval = retryInterval;
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.reconnectAttempts = reconnectAttempts;
        this.callTimeout = callTimeout;
        this.callFailoverTimeout = callFailoverTimeout;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = discoveryGroupName;
        this.clusterNotificationInterval = clusterNotificationInterval;
        this.clusterNotificationAttempts = clusterNotificationAttempts;
        this.staticConnectors = Collections.emptyList();
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.minLargeMessageSize = minLargeMessageSize;
        this.allowDirectConnectionsOnly = false;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    public boolean isForwardWhenNoConsumers() {
        return this.forwardWhenNoConsumers;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean isAllowDirectConnectionsOnly() {
        return this.allowDirectConnectionsOnly;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
    }

    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    public void setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public void setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
    }

    public void setCallFailoverTimeout(long callFailoverTimeout) {
        this.callFailoverTimeout = callFailoverTimeout;
    }

    public void setDuplicateDetection(boolean duplicateDetection) {
        this.duplicateDetection = duplicateDetection;
    }

    public void setForwardWhenNoConsumers(boolean forwardWhenNoConsumers) {
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
    }

    public long getClusterNotificationInterval() {
        return this.clusterNotificationInterval;
    }

    public int getClusterNotificationAttempts() {
        return this.clusterNotificationAttempts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.allowDirectConnectionsOnly ? 1231 : 1237);
        result = 31 * result + (int)(this.callFailoverTimeout ^ this.callFailoverTimeout >>> 32);
        result = 31 * result + (int)(this.callTimeout ^ this.callTimeout >>> 32);
        result = 31 * result + (int)(this.clientFailureCheckPeriod ^ this.clientFailureCheckPeriod >>> 32);
        result = 31 * result + this.clusterNotificationAttempts;
        result = 31 * result + (int)(this.clusterNotificationInterval ^ this.clusterNotificationInterval >>> 32);
        result = 31 * result + this.confirmationWindowSize;
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        result = 31 * result + (this.connectorName == null ? 0 : this.connectorName.hashCode());
        result = 31 * result + (this.discoveryGroupName == null ? 0 : this.discoveryGroupName.hashCode());
        result = 31 * result + (this.duplicateDetection ? 1231 : 1237);
        result = 31 * result + (this.forwardWhenNoConsumers ? 1231 : 1237);
        result = 31 * result + this.maxHops;
        result = 31 * result + (int)(this.maxRetryInterval ^ this.maxRetryInterval >>> 32);
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        long temp = Double.doubleToLongBits(this.retryIntervalMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.staticConnectors == null ? 0 : ((Object)this.staticConnectors).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterConnectionConfiguration other = (ClusterConnectionConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.allowDirectConnectionsOnly != other.allowDirectConnectionsOnly) {
            return false;
        }
        if (this.callFailoverTimeout != other.callFailoverTimeout) {
            return false;
        }
        if (this.callTimeout != other.callTimeout) {
            return false;
        }
        if (this.clientFailureCheckPeriod != other.clientFailureCheckPeriod) {
            return false;
        }
        if (this.clusterNotificationAttempts != other.clusterNotificationAttempts) {
            return false;
        }
        if (this.clusterNotificationInterval != other.clusterNotificationInterval) {
            return false;
        }
        if (this.confirmationWindowSize != other.confirmationWindowSize) {
            return false;
        }
        if (this.connectionTTL != other.connectionTTL) {
            return false;
        }
        if (this.connectorName == null ? other.connectorName != null : !this.connectorName.equals(other.connectorName)) {
            return false;
        }
        if (this.discoveryGroupName == null ? other.discoveryGroupName != null : !this.discoveryGroupName.equals(other.discoveryGroupName)) {
            return false;
        }
        if (this.duplicateDetection != other.duplicateDetection) {
            return false;
        }
        if (this.forwardWhenNoConsumers != other.forwardWhenNoConsumers) {
            return false;
        }
        if (this.maxHops != other.maxHops) {
            return false;
        }
        if (this.maxRetryInterval != other.maxRetryInterval) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.reconnectAttempts != other.reconnectAttempts) {
            return false;
        }
        if (this.retryInterval != other.retryInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.retryIntervalMultiplier) != Double.doubleToLongBits(other.retryIntervalMultiplier)) {
            return false;
        }
        return !(this.staticConnectors == null ? other.staticConnectors != null : !((Object)this.staticConnectors).equals(other.staticConnectors));
    }
}

