/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.interceptor.SBInvocationInterceptor;
import org.jboss.as.jpa.interceptor.SFSBCreateInterceptor;
import org.jboss.as.jpa.interceptor.SFSBDestroyInterceptor;
import org.jboss.as.jpa.interceptor.SFSBInvocationInterceptor;
import org.jboss.as.jpa.interceptor.SFSBPreCreateInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.InterceptorFactory;

public class JPAInterceptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof SessionBeanComponentDescription)) continue;
            JpaLogger.JPA_LOGGER.tracef("registering session bean interceptors for component '%s' in '%s'", (Object)component.getComponentName(), (Object)deploymentUnit.getName());
            this.registerSessionBeanInterceptors((SessionBeanComponentDescription)component, deploymentUnit);
        }
    }

    private void registerSessionBeanInterceptors(SessionBeanComponentDescription componentDescription, DeploymentUnit deploymentUnit) {
        if (componentDescription.isStateful()) {
            componentDescription.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addPostConstructInterceptor(SFSBPreCreateInterceptor.FACTORY, 1024);
                    configuration.addPostConstructInterceptor((InterceptorFactory)new SFSBCreateInterceptor.Factory(), 2560);
                    configuration.addPreDestroyInterceptor((InterceptorFactory)new SFSBDestroyInterceptor.Factory(), 1280);
                    configuration.addComponentInterceptor(SFSBInvocationInterceptor.FACTORY, 1376, false);
                    configuration.getInterceptorContextKeys().add("org.jboss.as.jpa.InterceptorContextKey");
                }
            });
        }
        if (componentDescription.isStateful() || componentDescription.isStateless()) {
            componentDescription.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    configuration.addComponentInterceptor(SBInvocationInterceptor.FACTORY, 1536, false);
                }
            });
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

