/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.AbstractListenerImpl;
import org.infinispan.notifications.ClassLoaderAwareListenable;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.EventImpl;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheNotifierImpl
extends AbstractListenerImpl
implements CacheNotifier,
ClassLoaderAwareListenable {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(16);
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryCreatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryRemovedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryVisitedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryModifiedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryActivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryLoadedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntriesEvictedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionRegisteredListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionCompletedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> dataRehashedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> topologyChangedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryEvictedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    private Cache<Object, Object> cache;

    public CacheNotifierImpl() {
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntriesEvicted.class, this.cacheEntriesEvictedListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
        this.listenersMap.put(DataRehashed.class, this.dataRehashedListeners);
        this.listenersMap.put(TopologyChanged.class, this.topologyChangedListeners);
        this.listenersMap.put(CacheEntryEvicted.class, this.cacheEntryEvictedListeners);
    }

    @Inject
    void injectDependencies(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations() {
        return allowedListeners;
    }

    @Override
    public void notifyCacheEntryCreated(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryCreatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_CREATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryCreatedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryModified(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryModifiedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_MODIFIED);
            e.setOriginLocal(originLocal);
            e.setValue(value);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryModifiedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryRemoved(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryRemovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_REMOVED);
            e.setOriginLocal(originLocal);
            e.setValue(value);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryRemovedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryVisited(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryVisitedListeners.isEmpty()) {
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_VISITED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryVisitedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntriesEvicted(Collection<InternalCacheEntry> entries, InvocationContext ctx) {
        if (!entries.isEmpty()) {
            if (!this.cacheEntriesEvictedListeners.isEmpty()) {
                EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                Map<Object, Object> evictedKeysAndValues = InfinispanCollections.transformCollectionToMap(entries, new InfinispanCollections.MapMakerFunction<Object, Object, InternalCacheEntry>(){

                    @Override
                    public Map.Entry<Object, Object> transform(final InternalCacheEntry input) {
                        return new Map.Entry<Object, Object>(){

                            @Override
                            public Object getKey() {
                                return input.getKey();
                            }

                            @Override
                            public Object getValue() {
                                return input.getValue();
                            }

                            @Override
                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                });
                e.setEntries(evictedKeysAndValues);
                for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntriesEvictedListeners) {
                    listener.invoke(e);
                }
            }
            if (!this.cacheEntryEvictedListeners.isEmpty()) {
                for (InternalCacheEntry ice : entries) {
                    EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
                    e.setKey(ice.getKey());
                    e.setValue(ice.getValue());
                    for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryEvictedListeners) {
                        listener.invoke(e);
                    }
                }
            }
        }
    }

    @Override
    public void notifyCacheEntryEvicted(Object key, Object value, InvocationContext ctx) {
        EventImpl<Object, Object> e;
        if (!this.cacheEntriesEvictedListeners.isEmpty()) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            e.setEntries(Collections.singletonMap(key, value));
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntriesEvictedListeners) {
                listener.invoke(e);
            }
        }
        if (!this.cacheEntryEvictedListeners.isEmpty()) {
            e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_EVICTED);
            e.setKey(key);
            e.setValue(value);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryEvictedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryInvalidated(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryInvalidatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_INVALIDATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryInvalidatedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryLoaded(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryLoadedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_LOADED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryLoadedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheEntryActivated(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryActivatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_ACTIVATED);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            this.setTx(ctx, e);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryActivatedListeners) {
                listener.invoke(e);
            }
        }
    }

    private void setTx(InvocationContext ctx, EventImpl<Object, Object> e) {
        if (ctx != null && ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setTransactionId(tx);
        }
    }

    @Override
    public void notifyCacheEntryPassivated(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryPassivatedListeners.isEmpty()) {
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.CACHE_ENTRY_PASSIVATED);
            e.setPre(pre);
            e.setKey(key);
            e.setValue(value);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryPassivatedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_COMPLETED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(transaction);
            e.setTransactionSuccessful(successful);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTransactionRegistered(GlobalTransaction globalTransaction, InvocationContext ctx) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.TRANSACTION_REGISTERED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(globalTransaction);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyDataRehashed(Collection<Address> oldView, Collection<Address> newView, int newTopologyId, boolean pre) {
        if (!this.dataRehashedListeners.isEmpty()) {
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.DATA_REHASHED);
            e.setPre(pre);
            e.setMembersAtStart(oldView);
            e.setMembersAtEnd(newView);
            e.setNewTopologyId(newTopologyId);
            for (AbstractListenerImpl.ListenerInvocation listener : this.dataRehashedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTopologyChanged(ConsistentHash oldConsistentHash, ConsistentHash newConsistentHash, int newTopologyId, boolean pre) {
        if (!this.topologyChangedListeners.isEmpty()) {
            EventImpl<Object, Object> e = EventImpl.createEvent(this.cache, Event.Type.TOPOLOGY_CHANGED);
            e.setPre(pre);
            e.setConsistentHashAtStart(oldConsistentHash);
            e.setConsistentHashAtEnd(newConsistentHash);
            e.setNewTopologyId(newTopologyId);
            for (AbstractListenerImpl.ListenerInvocation listener : this.topologyChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntriesEvicted.class, CacheEntriesEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
        allowedListeners.put(DataRehashed.class, DataRehashedEvent.class);
        allowedListeners.put(TopologyChanged.class, TopologyChangedEvent.class);
        allowedListeners.put(CacheEntryEvicted.class, CacheEntryEvictedEvent.class);
    }
}

