/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.base;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.rpc.RpcManager;

public abstract class BaseRpcInterceptor
extends CommandInterceptor {
    protected RpcManager rpcManager;
    protected boolean defaultSynchronous;

    @Inject
    public void inject(RpcManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    @Start
    public void init() {
        this.defaultSynchronous = this.cacheConfiguration.clustering().cacheMode().isSynchronous();
    }

    protected final boolean isSynchronous(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.FORCE_SYNCHRONOUS)) {
            return true;
        }
        if (command.hasFlag(Flag.FORCE_ASYNCHRONOUS)) {
            return false;
        }
        return this.defaultSynchronous;
    }

    protected final boolean isLocalModeForced(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldInvokeRemotely;
        boolean bl = shouldInvokeRemotely = ctx.isOriginLocal() && (ctx.hasModifications() || !((LocalTxInvocationContext)ctx).getRemoteLocksAcquired().isEmpty());
        if (this.getLog().isTraceEnabled()) {
            boolean hasRemoteLocksAcquired = ctx.isOriginLocal() && !((LocalTxInvocationContext)ctx).getRemoteLocksAcquired().isEmpty();
            this.getLog().tracef("Should invoke remotely? %s. isLocal=%s, hasModifications=%s, hasRemoteLocksAcquired=%s", new Object[]{shouldInvokeRemotely, ctx.isOriginLocal(), ctx.hasModifications(), hasRemoteLocksAcquired});
        }
        return shouldInvokeRemotely;
    }
}

