/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.DataContainerConfiguration;
import org.infinispan.configuration.cache.DeadlockDetectionConfiguration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LoadersConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StoreAsBinaryConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.UnsafeConfiguration;
import org.infinispan.configuration.cache.VersioningConfiguration;

public class Configuration {
    private final ClassLoader classLoader;
    private final ClusteringConfiguration clusteringConfiguration;
    private final CustomInterceptorsConfiguration customInterceptorsConfiguration;
    private final DataContainerConfiguration dataContainerConfiguration;
    private final DeadlockDetectionConfiguration deadlockDetectionConfiguration;
    private final EvictionConfiguration evictionConfiguration;
    private final ExpirationConfiguration expirationConfiguration;
    private final IndexingConfiguration indexingConfiguration;
    private final InvocationBatchingConfiguration invocationBatchingConfiguration;
    private final JMXStatisticsConfiguration jmxStatisticsConfiguration;
    private final LoadersConfiguration loadersConfiguration;
    private final LockingConfiguration lockingConfiguration;
    private final StoreAsBinaryConfiguration storeAsBinaryConfiguration;
    private final TransactionConfiguration transactionConfiguration;
    private final VersioningConfiguration versioningConfiguration;
    private final UnsafeConfiguration unsafeConfiguration;
    private final Map<Class<?>, ?> moduleConfiguration;
    private final SitesConfiguration sites;

    Configuration(ClusteringConfiguration clusteringConfiguration, CustomInterceptorsConfiguration customInterceptorsConfiguration, DataContainerConfiguration dataContainerConfiguration, DeadlockDetectionConfiguration deadlockDetectionConfiguration, EvictionConfiguration evictionConfiguration, ExpirationConfiguration expirationConfiguration, IndexingConfiguration indexingConfiguration, InvocationBatchingConfiguration invocationBatchingConfiguration, JMXStatisticsConfiguration jmxStatisticsConfiguration, LoadersConfiguration loadersConfiguration, LockingConfiguration lockingConfiguration, StoreAsBinaryConfiguration storeAsBinaryConfiguration, TransactionConfiguration transactionConfiguration, UnsafeConfiguration unsafeConfiguration, VersioningConfiguration versioningConfiguration, List<?> modules, SitesConfiguration sites, ClassLoader cl) {
        this.clusteringConfiguration = clusteringConfiguration;
        this.customInterceptorsConfiguration = customInterceptorsConfiguration;
        this.dataContainerConfiguration = dataContainerConfiguration;
        this.deadlockDetectionConfiguration = deadlockDetectionConfiguration;
        this.evictionConfiguration = evictionConfiguration;
        this.expirationConfiguration = expirationConfiguration;
        this.indexingConfiguration = indexingConfiguration;
        this.invocationBatchingConfiguration = invocationBatchingConfiguration;
        this.jmxStatisticsConfiguration = jmxStatisticsConfiguration;
        this.loadersConfiguration = loadersConfiguration;
        this.lockingConfiguration = lockingConfiguration;
        this.storeAsBinaryConfiguration = storeAsBinaryConfiguration;
        this.transactionConfiguration = transactionConfiguration;
        this.unsafeConfiguration = unsafeConfiguration;
        this.versioningConfiguration = versioningConfiguration;
        HashMap modulesMap = new HashMap();
        for (Object module : modules) {
            modulesMap.put(module.getClass(), module);
        }
        this.moduleConfiguration = Collections.unmodifiableMap(modulesMap);
        this.sites = sites;
        this.classLoader = cl;
    }

    @Deprecated
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public ClusteringConfiguration clustering() {
        return this.clusteringConfiguration;
    }

    public CustomInterceptorsConfiguration customInterceptors() {
        return this.customInterceptorsConfiguration;
    }

    public DataContainerConfiguration dataContainer() {
        return this.dataContainerConfiguration;
    }

    public DeadlockDetectionConfiguration deadlockDetection() {
        return this.deadlockDetectionConfiguration;
    }

    public EvictionConfiguration eviction() {
        return this.evictionConfiguration;
    }

    public ExpirationConfiguration expiration() {
        return this.expirationConfiguration;
    }

    public IndexingConfiguration indexing() {
        return this.indexingConfiguration;
    }

    public InvocationBatchingConfiguration invocationBatching() {
        return this.invocationBatchingConfiguration;
    }

    public JMXStatisticsConfiguration jmxStatistics() {
        return this.jmxStatisticsConfiguration;
    }

    public LoadersConfiguration loaders() {
        return this.loadersConfiguration;
    }

    public LockingConfiguration locking() {
        return this.lockingConfiguration;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.moduleConfiguration.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.moduleConfiguration;
    }

    public StoreAsBinaryConfiguration storeAsBinary() {
        return this.storeAsBinaryConfiguration;
    }

    public TransactionConfiguration transaction() {
        return this.transactionConfiguration;
    }

    public UnsafeConfiguration unsafe() {
        return this.unsafeConfiguration;
    }

    public SitesConfiguration sites() {
        return this.sites;
    }

    public VersioningConfiguration versioning() {
        return this.versioningConfiguration;
    }

    public String toString() {
        return "Configuration{classLoader=" + this.classLoader + ", clustering=" + this.clusteringConfiguration + ", customInterceptors=" + this.customInterceptorsConfiguration + ", dataContainer=" + this.dataContainerConfiguration + ", deadlockDetection=" + this.deadlockDetectionConfiguration + ", eviction=" + this.evictionConfiguration + ", expiration=" + this.expirationConfiguration + ", indexing=" + this.indexingConfiguration + ", invocationBatching=" + this.invocationBatchingConfiguration + ", jmxStatistics=" + this.jmxStatisticsConfiguration + ", loaders=" + this.loadersConfiguration + ", locking=" + this.lockingConfiguration + ", modules=" + this.moduleConfiguration + ", storeAsBinary=" + this.storeAsBinaryConfiguration + ", transaction=" + this.transactionConfiguration + ", versioning=" + this.versioningConfiguration + ", unsafe=" + this.unsafeConfiguration + ", sites=" + this.sites + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        if (this.clusteringConfiguration != null ? !this.clusteringConfiguration.equals(that.clusteringConfiguration) : that.clusteringConfiguration != null) {
            return false;
        }
        if (this.customInterceptorsConfiguration != null ? !this.customInterceptorsConfiguration.equals(that.customInterceptorsConfiguration) : that.customInterceptorsConfiguration != null) {
            return false;
        }
        if (this.dataContainerConfiguration != null ? !this.dataContainerConfiguration.equals(that.dataContainerConfiguration) : that.dataContainerConfiguration != null) {
            return false;
        }
        if (this.deadlockDetectionConfiguration != null ? !this.deadlockDetectionConfiguration.equals(that.deadlockDetectionConfiguration) : that.deadlockDetectionConfiguration != null) {
            return false;
        }
        if (this.evictionConfiguration != null ? !this.evictionConfiguration.equals(that.evictionConfiguration) : that.evictionConfiguration != null) {
            return false;
        }
        if (this.expirationConfiguration != null ? !this.expirationConfiguration.equals(that.expirationConfiguration) : that.expirationConfiguration != null) {
            return false;
        }
        if (this.indexingConfiguration != null ? !this.indexingConfiguration.equals(that.indexingConfiguration) : that.indexingConfiguration != null) {
            return false;
        }
        if (this.invocationBatchingConfiguration != null ? !this.invocationBatchingConfiguration.equals(that.invocationBatchingConfiguration) : that.invocationBatchingConfiguration != null) {
            return false;
        }
        if (this.jmxStatisticsConfiguration != null ? !this.jmxStatisticsConfiguration.equals(that.jmxStatisticsConfiguration) : that.jmxStatisticsConfiguration != null) {
            return false;
        }
        if (this.loadersConfiguration != null ? !this.loadersConfiguration.equals(that.loadersConfiguration) : that.loadersConfiguration != null) {
            return false;
        }
        if (this.lockingConfiguration != null ? !this.lockingConfiguration.equals(that.lockingConfiguration) : that.lockingConfiguration != null) {
            return false;
        }
        if (this.moduleConfiguration != null ? !((Object)this.moduleConfiguration).equals(that.moduleConfiguration) : that.moduleConfiguration != null) {
            return false;
        }
        if (this.storeAsBinaryConfiguration != null ? !this.storeAsBinaryConfiguration.equals(that.storeAsBinaryConfiguration) : that.storeAsBinaryConfiguration != null) {
            return false;
        }
        if (this.transactionConfiguration != null ? !this.transactionConfiguration.equals(that.transactionConfiguration) : that.transactionConfiguration != null) {
            return false;
        }
        if (this.unsafeConfiguration != null ? !this.unsafeConfiguration.equals(that.unsafeConfiguration) : that.unsafeConfiguration != null) {
            return false;
        }
        if (this.sites != null ? !this.sites.equals(that.sites) : that.sites != null) {
            return false;
        }
        return !(this.versioningConfiguration != null ? !this.versioningConfiguration.equals(that.versioningConfiguration) : that.versioningConfiguration != null);
    }

    public int hashCode() {
        int result = this.classLoader != null ? this.classLoader.hashCode() : 0;
        result = 31 * result + (this.clusteringConfiguration != null ? this.clusteringConfiguration.hashCode() : 0);
        result = 31 * result + (this.customInterceptorsConfiguration != null ? this.customInterceptorsConfiguration.hashCode() : 0);
        result = 31 * result + (this.dataContainerConfiguration != null ? this.dataContainerConfiguration.hashCode() : 0);
        result = 31 * result + (this.deadlockDetectionConfiguration != null ? this.deadlockDetectionConfiguration.hashCode() : 0);
        result = 31 * result + (this.evictionConfiguration != null ? this.evictionConfiguration.hashCode() : 0);
        result = 31 * result + (this.expirationConfiguration != null ? this.expirationConfiguration.hashCode() : 0);
        result = 31 * result + (this.indexingConfiguration != null ? this.indexingConfiguration.hashCode() : 0);
        result = 31 * result + (this.invocationBatchingConfiguration != null ? this.invocationBatchingConfiguration.hashCode() : 0);
        result = 31 * result + (this.jmxStatisticsConfiguration != null ? this.jmxStatisticsConfiguration.hashCode() : 0);
        result = 31 * result + (this.loadersConfiguration != null ? this.loadersConfiguration.hashCode() : 0);
        result = 31 * result + (this.lockingConfiguration != null ? this.lockingConfiguration.hashCode() : 0);
        result = 31 * result + (this.moduleConfiguration != null ? ((Object)this.moduleConfiguration).hashCode() : 0);
        result = 31 * result + (this.storeAsBinaryConfiguration != null ? this.storeAsBinaryConfiguration.hashCode() : 0);
        result = 31 * result + (this.transactionConfiguration != null ? this.transactionConfiguration.hashCode() : 0);
        result = 31 * result + (this.versioningConfiguration != null ? this.versioningConfiguration.hashCode() : 0);
        result = 31 * result + (this.unsafeConfiguration != null ? this.unsafeConfiguration.hashCode() : 0);
        result = 31 * result + (this.sites != null ? this.sites.hashCode() : 0);
        return result;
    }
}

