/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.hash;

import java.io.ObjectInput;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.marshall.exts.NoStateExternalizer;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.Util;

public class MurmurHash2Compat
implements Hash {
    private static final int M = 1540483477;
    private static final int R = 24;
    private static final int H = -1;

    @Override
    public final int hash(byte[] payload) {
        int h = -1;
        int len = payload.length;
        int offset = 0;
        while (len >= 4) {
            int k = payload[offset];
            k |= payload[offset + 1] << 8;
            k |= payload[offset + 2] << 16;
            k |= payload[offset + 3] << 24;
            k *= 1540483477;
            k ^= k >> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
            len -= 4;
            offset += 4;
        }
        switch (len) {
            case 3: {
                h ^= payload[offset + 2] << 16;
            }
            case 2: {
                h ^= payload[offset + 1] << 8;
            }
            case 1: {
                h ^= payload[offset];
                h *= 1540483477;
            }
        }
        h ^= h >> 13;
        h *= 1540483477;
        h ^= h >> 15;
        return h;
    }

    @Override
    public final int hash(int hashcode) {
        byte[] b = new byte[]{(byte)hashcode, (byte)(hashcode >> 8), (byte)(hashcode >> 16), (byte)(hashcode >> 24)};
        return this.hash(b);
    }

    @Override
    public final int hash(Object o) {
        if (o instanceof byte[]) {
            return this.hash((byte[])o);
        }
        if (o instanceof String) {
            return this.hash(((String)o).getBytes());
        }
        if (o instanceof ByteArrayKey) {
            return this.hash(((ByteArrayKey)o).getData());
        }
        return this.hash(o.hashCode());
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass();
    }

    public static class Externalizer
    extends NoStateExternalizer<MurmurHash2Compat> {
        @Override
        public Set<Class<? extends MurmurHash2Compat>> getTypeClasses() {
            return Util.asSet(MurmurHash2Compat.class);
        }

        @Override
        public MurmurHash2Compat readObject(ObjectInput input) {
            return new MurmurHash2Compat();
        }

        @Override
        public Integer getId() {
            return 72;
        }
    }
}

