/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.transport.Transport;

public class WebHelper {
    public static Log logger = LogFactory.getLog(WebHelper.class);
    public static final String UDDI_CLIENT_MANAGER_NAME = "uddi.client.manager.name";
    public static final String UDDI_CLIENT_CONFIG_FILE = "uddi.client.config.file";
    public static final String JUDDI_CLIENT_MANAGER_NAME = "juddi.client.manager.name";
    public static final String JUDDI_CLIENT_TRANSPORT = "juddi.client.transport";

    public static UDDIClerkManager getUDDIClerkManager(ServletContext servletContext) throws ConfigurationException {
        String clientConfigFile;
        if (servletContext.getAttribute(JUDDI_CLIENT_MANAGER_NAME) != null) {
            String managerName = String.valueOf(servletContext.getAttribute(JUDDI_CLIENT_MANAGER_NAME));
            return UDDIClientContainer.getUDDIClerkManager(managerName);
        }
        String managerName = servletContext.getInitParameter(UDDI_CLIENT_MANAGER_NAME);
        if (managerName != null) {
            try {
                UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(managerName);
                logger.info((Object)("Manager " + managerName + " was already started."));
                servletContext.setAttribute(JUDDI_CLIENT_MANAGER_NAME, (Object)managerName);
                return manager;
            }
            catch (ConfigurationException ce) {
                logger.debug((Object)("Manager " + managerName + " is not yet started."));
            }
        }
        if ((clientConfigFile = servletContext.getInitParameter(UDDI_CLIENT_CONFIG_FILE)) == null) {
            clientConfigFile = "META-INF/uddi.xml";
        }
        logger.info((Object)("Reading the managerName from the clientConfig file " + clientConfigFile));
        UDDIClerkManager manager = new UDDIClerkManager(clientConfigFile);
        if (clientConfigFile == null && manager.getName() == null) {
            logger.warn((Object)"Deprecated, manager name set to 'default', however it should be provided in the uddi.xml");
            managerName = "default";
        }
        if (manager.getName() == null) {
            throw new ConfigurationException("A manager name needs to be specified in the client config file.");
        }
        logger.info((Object)("Starting Clerk Manager " + manager.getName() + "..."));
        manager.start();
        UDDIClientContainer.addClerkManager(manager);
        servletContext.setAttribute(JUDDI_CLIENT_MANAGER_NAME, (Object)managerName);
        return manager;
    }

    public static UDDINode getUDDIHomeNode(ServletContext servletContext) throws ConfigurationException {
        UDDIClerkManager manager = WebHelper.getUDDIClerkManager(servletContext);
        return manager.getClientConfig().getHomeNode();
    }

    public static Transport getTransport(ServletContext servletContext) throws ConfigurationException, ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Transport transport = (Transport)servletContext.getAttribute(JUDDI_CLIENT_TRANSPORT);
        if (transport == null) {
            UDDIClerkManager manager = WebHelper.getUDDIClerkManager(servletContext);
            UDDINode node = manager.getClientConfig().getHomeNode();
            Class<?> transportClass = ClassUtil.forName(node.getProxyTransport(), Transport.class);
            transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(manager.getName(), node.getName());
            servletContext.setAttribute(JUDDI_CLIENT_TRANSPORT, (Object)transport);
        }
        return transport;
    }

    public static Transport getTransport(ServletContext servletContext, UDDINode remoteNode) throws ConfigurationException, ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Transport transport = (Transport)servletContext.getAttribute("juddi.client.transport-" + remoteNode.getName());
        if (transport == null) {
            UDDIClerkManager manager = WebHelper.getUDDIClerkManager(servletContext);
            Class<?> transportClass = ClassUtil.forName(remoteNode.getProxyTransport(), Transport.class);
            transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(manager.getName(), remoteNode.getName());
            servletContext.setAttribute("juddi.client.transport-" + remoteNode.getName(), (Object)transport);
        }
        return transport;
    }
}

