/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.annotations.UDDIService;
import org.apache.juddi.v3.annotations.UDDIServiceBinding;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessor {
    private static final String KEYED_REFERENCE = "keyedReference=";
    private static final String KEY_NAME = "keyName=";
    private static final String KEY_VALUE = "keyValue=";
    private static final String TMODEL_KEY = "tModelKey=";
    private Log log = LogFactory.getLog(AnnotationProcessor.class);

    public Collection<BusinessService> readServiceAnnotations(String[] classesWithAnnotations, Properties properties) {
        ArrayList<BusinessService> services = new ArrayList<BusinessService>();
        for (String className : classesWithAnnotations) {
            try {
                BusinessService service = this.readServiceAnnotations(className, properties);
                services.add(service);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return services;
    }

    public BusinessService readServiceAnnotations(String classWithAnnotations, Properties properties) throws ClassNotFoundException {
        BusinessService service = new BusinessService();
        Class<?> clazz = ClassUtil.forName(classWithAnnotations, this.getClass());
        UDDIService uddiService = clazz.getAnnotation(UDDIService.class);
        WebService webServiceAnnotation = clazz.getAnnotation(WebService.class);
        if (uddiService != null) {
            BindingTemplate bindingTemplate;
            String lang = "en";
            if (uddiService.lang() != null) {
                lang = uddiService.lang();
            }
            Name name = new Name();
            name.setLang(lang);
            service.setBusinessKey(TokenResolver.replaceTokens(uddiService.businessKey(), properties));
            service.setServiceKey(TokenResolver.replaceTokens(uddiService.serviceKey(), properties));
            if (!"".equals(uddiService.serviceName())) {
                name.setValue(TokenResolver.replaceTokens(uddiService.serviceName(), properties));
            } else if (webServiceAnnotation != null && !"".equals(webServiceAnnotation.serviceName())) {
                name.setValue(webServiceAnnotation.serviceName());
            } else {
                name.setValue(clazz.getSimpleName());
            }
            service.getName().add(name);
            Description description = new Description();
            description.setLang(lang);
            description.setValue(TokenResolver.replaceTokens(uddiService.description(), properties));
            service.getDescription().add(description);
            if (!"".equals(uddiService.categoryBag())) {
                CategoryBag categoryBag = this.parseCategoryBag(uddiService.categoryBag());
                service.setCategoryBag(categoryBag);
            }
            if ((bindingTemplate = this.parseServiceBinding(clazz, lang, webServiceAnnotation, properties)) != null) {
                bindingTemplate.setServiceKey(service.getServiceKey());
                if (service.getBindingTemplates() == null) {
                    service.setBindingTemplates(new BindingTemplates());
                }
                service.getBindingTemplates().getBindingTemplate().add(bindingTemplate);
            }
        } else {
            this.log.error((Object)("Missing UDDIService annotation in class " + classWithAnnotations));
        }
        return service;
    }

    protected BindingTemplate parseServiceBinding(Class<?> classWithAnnotations, String lang, WebService webServiceAnnotation, Properties properties) {
        BindingTemplate bindingTemplate = null;
        UDDIServiceBinding uddiServiceBinding = classWithAnnotations.getAnnotation(UDDIServiceBinding.class);
        if (uddiServiceBinding != null) {
            bindingTemplate = new BindingTemplate();
            bindingTemplate.setBindingKey(TokenResolver.replaceTokens(uddiServiceBinding.bindingKey(), properties));
            String bindingLang = String.valueOf(lang);
            if (uddiServiceBinding.lang() != null) {
                bindingLang = TokenResolver.replaceTokens(uddiServiceBinding.lang(), properties);
            }
            Description bindingDescription = new Description();
            bindingDescription.setLang(bindingLang);
            bindingDescription.setValue(TokenResolver.replaceTokens(uddiServiceBinding.description(), properties));
            bindingTemplate.getDescription().add(bindingDescription);
            AccessPoint accessPoint = new AccessPoint();
            accessPoint.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
            if (!"".equals(uddiServiceBinding.accessPointType())) {
                accessPoint.setUseType(uddiServiceBinding.accessPointType());
            }
            if (!"".equals(uddiServiceBinding.accessPoint())) {
                String endPoint = uddiServiceBinding.accessPoint();
                endPoint = TokenResolver.replaceTokens(endPoint, properties);
                this.log.debug((Object)("AccessPoint EndPoint=" + endPoint));
                accessPoint.setValue(endPoint);
            } else if (webServiceAnnotation != null && webServiceAnnotation.wsdlLocation() != null) {
                accessPoint.setValue(webServiceAnnotation.wsdlLocation());
            }
            bindingTemplate.setAccessPoint(accessPoint);
            if (!"".equals(uddiServiceBinding.tModelKeys())) {
                String[] tModelKeys;
                for (String tModelKey : tModelKeys = uddiServiceBinding.tModelKeys().split(",")) {
                    TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
                    instanceInfo.setTModelKey(tModelKey);
                    if (bindingTemplate.getTModelInstanceDetails() == null) {
                        bindingTemplate.setTModelInstanceDetails(new TModelInstanceDetails());
                    }
                    bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo().add(instanceInfo);
                }
            }
            if (!"".equals(uddiServiceBinding.categoryBag())) {
                CategoryBag categoryBag = this.parseCategoryBag(uddiServiceBinding.categoryBag());
                bindingTemplate.setCategoryBag(categoryBag);
            }
        } else {
            this.log.error((Object)("Missing UDDIServiceBinding annotation in class " + classWithAnnotations));
        }
        return bindingTemplate;
    }

    protected CategoryBag parseCategoryBag(String categoryBagStr) {
        CategoryBag categoryBag = new CategoryBag();
        this.log.debug((Object)("CategoryBag Annotation=" + categoryBagStr));
        if (!"".equals(categoryBagStr)) {
            String[] sections;
            for (String section : sections = categoryBagStr.split(",")) {
                if (section.startsWith(KEYED_REFERENCE)) {
                    String keyedReferenceStr = section.substring(KEYED_REFERENCE.length(), section.length());
                    this.log.debug((Object)("Found KeyedReference=" + keyedReferenceStr));
                    String[] keyedReferences = keyedReferenceStr.split(";");
                    KeyedReference keyedReference = new KeyedReference();
                    for (String key : keyedReferences) {
                        if (key.startsWith(KEY_NAME)) {
                            keyedReference.setKeyName(key.substring(KEY_NAME.length(), key.length()));
                        }
                        if (key.startsWith(KEY_VALUE)) {
                            keyedReference.setKeyValue(key.substring(KEY_VALUE.length(), key.length()));
                        }
                        if (!key.startsWith(TMODEL_KEY)) continue;
                        keyedReference.setTModelKey(key.substring(TMODEL_KEY.length(), key.length()));
                    }
                    this.log.debug((Object)("KeyedReference = keyName=" + keyedReference.getKeyName() + " " + KEY_VALUE + keyedReference.getKeyValue() + " " + TMODEL_KEY + keyedReference.getTModelKey()));
                    categoryBag.getKeyedReference().add(keyedReference);
                    continue;
                }
                this.log.warn((Object)("Ignoring " + section));
            }
        }
        return categoryBag;
    }
}

