/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.RejectExpressionValuesChainedTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.chained.ChainedOperationTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformationContext;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformer;
import org.jboss.as.controller.transform.chained.ChainedResourceTransformerEntry;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.dmr.ModelNode;

class SystemPropertyTransformers {
    static final RejectExpressionValuesChainedTransformer rejectExpressions = new RejectExpressionValuesChainedTransformer(new AttributeDefinition[]{SystemPropertyResourceDefinition.VALUE, SystemPropertyResourceDefinition.BOOT_TIME});

    SystemPropertyTransformers() {
    }

    static void registerTransformers120(TransformersSubRegistration parent) {
        TransformersSubRegistration reg = parent.registerSubResource(SystemPropertyResourceDefinition.PATH, (ResourceTransformer)new ChainedResourceTransformer(new ChainedResourceTransformerEntry[]{new ChainedResourceTransformerEntry(){

            public void transformResource(ChainedResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ModelNode model = resource.getModel();
                if (!model.hasDefined("boot-time")) {
                    model.get("boot-time").set(true);
                }
            }
        }, rejectExpressions}));
        reg.registerOperationTransformer("add", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformed = operation.clone();
                if (!transformed.hasDefined("boot-time")) {
                    transformed.get("boot-time").set(true);
                }
                return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
            }
        }, rejectExpressions}));
        OperationTransformer forceTrue = new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                ModelNode transformed = operation;
                if (transformed.get("name").asString().equals("boot-time") && !(transformed = transformed.clone()).get("value").isDefined()) {
                    transformed.get("value").set(true);
                    if ("undefine-attribute".equals(transformed.get("operation").asString())) {
                        transformed.get("operation").set("write-attribute");
                    }
                }
                return new OperationTransformer.TransformedOperation(transformed, OperationResultTransformer.ORIGINAL_RESULT);
            }
        };
        reg.registerOperationTransformer("write-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{forceTrue, rejectExpressions}));
        reg.registerOperationTransformer("undefine-attribute", (OperationTransformer)new ChainedOperationTransformer(new OperationTransformer[]{forceTrue, rejectExpressions}));
    }
}

