/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainOperationContext;
import org.jboss.as.domain.controller.plan.ConcurrentGroupServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ConcurrentServerGroupUpdateTask;
import org.jboss.as.domain.controller.plan.ConcurrentUpdateTask;
import org.jboss.as.domain.controller.plan.RollingServerGroupUpdateTask;
import org.jboss.as.domain.controller.plan.RollingUpdateTask;
import org.jboss.as.domain.controller.plan.RunningServerUpdateTask;
import org.jboss.as.domain.controller.plan.ServerRestartTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class RolloutPlanController
implements ServerUpdateTask.ServerUpdateResultHandler {
    private final boolean rollbackAcrossGroups;
    private final Runnable rootTask;
    private final Map<String, ServerUpdatePolicy> updatePolicies = new HashMap<String, ServerUpdatePolicy>();
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;
    private final ServerTaskExecutor taskExecutor;
    private final DomainOperationContext domainOperationContext;
    private final ConcurrentMap<String, Map<ServerIdentity, ModelNode>> serverResults = new ConcurrentHashMap<String, Map<ServerIdentity, ModelNode>>();

    public RolloutPlanController(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup, ModelNode rolloutPlan, DomainOperationContext domainOperationContext, ServerTaskExecutor taskExecutor, ExecutorService executor) {
        this.domainOperationContext = domainOperationContext;
        this.taskExecutor = taskExecutor;
        this.rollbackAcrossGroups = !rolloutPlan.hasDefined("rollback-across-groups") || rolloutPlan.get("rollback-across-groups").asBoolean();
        this.shutdown = rolloutPlan.hasDefined("shutdown") && rolloutPlan.get("shutdown").asBoolean();
        this.gracefulShutdownPeriod = rolloutPlan.hasDefined("graceful-shutdown-timeout") ? (long)rolloutPlan.get("graceful-shutdown-timeout").asInt() : -1L;
        ArrayList<Runnable> rollingTasks = new ArrayList<Runnable>();
        this.rootTask = new RollingUpdateTask(rollingTasks);
        if (rolloutPlan.hasDefined("in-series")) {
            ConcurrentGroupServerUpdatePolicy predecessor = null;
            for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                ArrayList<Runnable> seriesTasks = new ArrayList<Runnable>();
                rollingTasks.add(new ConcurrentUpdateTask(seriesTasks, executor));
                HashSet<String> groupNames = new HashSet<String>();
                ArrayList<Property> groupPolicies = new ArrayList<Property>();
                if (series.hasDefined("concurrent-groups")) {
                    for (Property pol : series.get("concurrent-groups").asPropertyList()) {
                        groupNames.add(pol.getName());
                        groupPolicies.add(pol);
                    }
                } else {
                    Property pol = series.require("server-group").asProperty();
                    groupNames.add(pol.getName());
                    groupPolicies.add(pol);
                }
                ConcurrentGroupServerUpdatePolicy parent = new ConcurrentGroupServerUpdatePolicy(predecessor, groupNames);
                for (Property prop : groupPolicies) {
                    String serverGroupName = prop.getName();
                    Map<ServerIdentity, ModelNode> groupEntry = opsByGroup.get(serverGroupName);
                    if (groupEntry == null) continue;
                    ArrayList<ServerUpdateTask> groupTasks = new ArrayList<ServerUpdateTask>();
                    ModelNode policyNode = prop.getValue();
                    boolean rollingGroup = policyNode.hasDefined("rolling-to-servers") && policyNode.get("rolling-to-servers").asBoolean();
                    Set<ServerIdentity> servers = groupEntry.keySet();
                    int maxFailures = 0;
                    if (policyNode.hasDefined("max-failure-percentage")) {
                        int pct = policyNode.get("max-failure-percentage").asInt();
                        maxFailures = servers.size() * pct / 100;
                    } else if (policyNode.hasDefined("max-failed-servers")) {
                        maxFailures = policyNode.get("max-failed-servers").asInt();
                    }
                    ServerUpdatePolicy policy = new ServerUpdatePolicy(parent, serverGroupName, servers, maxFailures);
                    seriesTasks.add(rollingGroup ? new RollingServerGroupUpdateTask(groupTasks, policy, taskExecutor, this) : new ConcurrentServerGroupUpdateTask(groupTasks, policy, taskExecutor, this));
                    this.updatePolicies.put(serverGroupName, policy);
                    for (Map.Entry<ServerIdentity, ModelNode> entry : groupEntry.entrySet()) {
                        groupTasks.add(this.createServerTask(entry.getKey(), entry.getValue(), policy));
                    }
                }
            }
        }
    }

    public Result execute() {
        this.rootTask.run();
        Result result = null;
        for (ServerUpdatePolicy policy : this.updatePolicies.values()) {
            if (policy.isFailed()) {
                this.domainOperationContext.setServerGroupRollback(policy.getServerGroupName(), true);
                if (this.rollbackAcrossGroups) {
                    this.domainOperationContext.setCompleteRollback(true);
                }
                result = result == null || result == Result.FAILED ? Result.FAILED : Result.PARTIAL;
                continue;
            }
            this.domainOperationContext.setServerGroupRollback(policy.getServerGroupName(), false);
            result = result == null || result == Result.SUCCESS ? Result.SUCCESS : Result.PARTIAL;
        }
        return result;
    }

    @Override
    public void handleServerUpdateResult(ServerIdentity serverId, ModelNode response) {
        Map existing;
        Map<ServerIdentity, Object> groupResults;
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("From %s received %s", serverId, response);
        }
        if ((groupResults = (ConcurrentHashMap<ServerIdentity, ModelNode>)this.serverResults.get(serverId.getServerGroupName())) == null) {
            groupResults = new ConcurrentHashMap<ServerIdentity, ModelNode>();
        }
        if ((existing = (Map)this.serverResults.putIfAbsent(serverId.getServerGroupName(), groupResults)) != null) {
            groupResults = existing;
        }
        groupResults.put(serverId, response);
    }

    private ServerUpdateTask createServerTask(ServerIdentity serverIdentity, ModelNode serverOp, ServerUpdatePolicy policy) {
        ServerUpdateTask result = this.shutdown ? new ServerRestartTask(serverIdentity, policy, this, this.gracefulShutdownPeriod) : new RunningServerUpdateTask(serverIdentity, serverOp, policy, this);
        return result;
    }

    public static enum Result {
        SUCCESS,
        PARTIAL,
        FAILED;

    }
}

