/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfig;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class StrictMaxPoolAdd
extends AbstractAddStepHandler {
    public static final StrictMaxPoolAdd INSTANCE = new StrictMaxPoolAdd();

    protected void populateModel(ModelNode operation, ModelNode strictMaxPoolModel) throws OperationFailedException {
        for (AttributeDefinition attr : StrictMaxPoolResourceDefinition.ATTRIBUTES.values()) {
            attr.validateAndSet(operation, strictMaxPoolModel);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode strictMaxPoolModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ServiceController serviceController = this.installRuntimeService(context, operation, strictMaxPoolModel, verificationHandler);
        serviceControllers.add(serviceController);
    }

    ServiceController installRuntimeService(OperationContext context, ModelNode operation, ModelNode strictMaxPoolModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String poolName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        int maxPoolSize = StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.resolveModelAttribute(context, strictMaxPoolModel).asInt();
        long timeout = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.resolveModelAttribute(context, strictMaxPoolModel).asLong();
        String unit = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.resolveModelAttribute(context, strictMaxPoolModel).asString();
        StrictMaxPoolConfig strictMaxPoolConfig = new StrictMaxPoolConfig(poolName, maxPoolSize, timeout, TimeUnit.valueOf(unit));
        PoolConfigService poolConfigService = new PoolConfigService(strictMaxPoolConfig);
        ServiceName serviceName = PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName});
        ServiceBuilder svcBuilder = context.getServiceTarget().addService(serviceName, (Service)poolConfigService);
        if (verificationHandler != null) {
            svcBuilder.addListener((ServiceListener)verificationHandler);
        }
        return svcBuilder.install();
    }
}

