/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public abstract class PassivationStoreAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;
    private AttributeDefinition MAX_SIZE_ATTR = null;

    PassivationStoreAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
        for (AttributeDefinition attribute : attributes) {
            if (!attribute.getName().equals("max-size")) continue;
            this.MAX_SIZE_ATTR = attribute;
            break;
        }
        if (this.MAX_SIZE_ATTR == null) {
            throw new IllegalArgumentException("MAX_SIZE should be one of attributes");
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        serviceControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    abstract Collection<ServiceController<?>> installRuntimeServices(OperationContext var1, ModelNode var2, ModelNode var3, ServiceVerificationHandler var4) throws OperationFailedException;

    ServiceController<?> installBackingCacheEntryStoreSourceService(BackingCacheEntryStoreSourceService<?, ?, ?, ?> service, OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        Object config = service.getValue();
        config.setIdleTimeout(PassivationStoreResourceDefinition.IDLE_TIMEOUT.resolveModelAttribute(context, model).asLong());
        config.setIdleTimeoutUnit(TimeUnit.valueOf(PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.resolveModelAttribute(context, model).asString()));
        ModelNode maxSizeModel = this.MAX_SIZE_ATTR.resolveModelAttribute(context, model);
        if (maxSizeModel.isDefined()) {
            config.setMaxSize(maxSizeModel.asInt());
        }
        ServiceBuilder<?> builder = service.build(context.getServiceTarget());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }
}

