/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.clustering.registry.RegistryCollector;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.RemoteAsyncInvocationCancelStatusService;
import org.jboss.as.ejb3.remote.protocol.versionone.ChannelAssociation;
import org.jboss.as.ejb3.remote.protocol.versionone.VersionOneProtocolChannelReceiver;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.AbstractStreamServerService;
import org.jboss.as.remoting.InjectedSocketBindingStreamServerService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.ConstantContextSelector;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientTransactionContext;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.ServiceRegistrationException;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class EJBRemoteConnectorService
implements Service<EJBRemoteConnectorService> {
    private static final String EJB_CHANNEL_NAME = "jboss.ejb";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "connector"});
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjectedValue = new InjectedValue();
    private final InjectedValue<EJBRemoteTransactionsRepository> ejbRemoteTransactionsRepositoryInjectedValue = new InjectedValue();
    private final InjectedValue<RegistryCollector> clusterRegistryCollector = new InjectedValue();
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private final InjectedValue<RemoteAsyncInvocationCancelStatusService> remoteAsyncInvocationCancelStatus = new InjectedValue();
    private final InjectedValue<TransactionManager> txManager = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> txSyncRegistry = new InjectedValue();
    private final ServiceName remotingConnectorServiceName;
    private volatile Registration registration;
    private volatile InjectedSocketBindingStreamServerService remotingServer;
    private final byte serverProtocolVersion;
    private final String[] supportedMarshallingStrategies;
    private final OptionMap channelCreationOptions;

    public EJBRemoteConnectorService(byte serverProtocolVersion, String[] supportedMarshallingStrategies, ServiceName remotingConnectorServiceName) {
        this(serverProtocolVersion, supportedMarshallingStrategies, remotingConnectorServiceName, OptionMap.EMPTY);
    }

    public EJBRemoteConnectorService(byte serverProtocolVersion, String[] supportedMarshallingStrategies, ServiceName remotingConnectorServiceName, OptionMap channelCreationOptions) {
        this.serverProtocolVersion = serverProtocolVersion;
        this.supportedMarshallingStrategies = supportedMarshallingStrategies;
        this.remotingConnectorServiceName = remotingConnectorServiceName;
        this.channelCreationOptions = channelCreationOptions;
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer serviceContainer = context.getController().getServiceContainer();
        ServiceController streamServerServiceController = serviceContainer.getRequiredService(this.remotingConnectorServiceName);
        AbstractStreamServerService streamServerService = (AbstractStreamServerService)streamServerServiceController.getService();
        if (streamServerService instanceof InjectedSocketBindingStreamServerService) {
            this.remotingServer = (InjectedSocketBindingStreamServerService)streamServerService;
        }
        ChannelOpenListener channelOpenListener = new ChannelOpenListener(serviceContainer);
        try {
            this.registration = ((Endpoint)this.endpointValue.getValue()).registerService(EJB_CHANNEL_NAME, (OpenListener)channelOpenListener, this.channelCreationOptions);
        }
        catch (ServiceRegistrationException e) {
            throw new StartException((Throwable)e);
        }
        EJBClientTransactionContext ejbClientTransactionContext = EJBClientTransactionContext.create((TransactionManager)((TransactionManager)this.txManager.getValue()), (TransactionSynchronizationRegistry)((TransactionSynchronizationRegistry)this.txSyncRegistry.getValue()));
        EJBClientTransactionContext.setSelector((ContextSelector)new ConstantContextSelector((Object)ejbClientTransactionContext));
    }

    public void stop(StopContext context) {
        this.remotingServer = null;
        this.registration.close();
        EJBClientTransactionContext.setSelector((ContextSelector)new ConstantContextSelector(null));
    }

    public EJBRemoteConnectorService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.txManager;
    }

    public Injector<TransactionSynchronizationRegistry> getTxSyncRegistryInjector() {
        return this.txSyncRegistry;
    }

    SocketBinding getEJBRemoteConnectorSocketBinding() {
        if (this.remotingServer == null) {
            return null;
        }
        return this.remotingServer.getSocketBinding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVersionMessage(ChannelAssociation channelAssociation) throws IOException {
        MessageOutputStream messageOutputStream;
        try {
            messageOutputStream = channelAssociation.acquireChannelMessageOutputStream();
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failedToOpenMessageOutputStream(e);
        }
        DataOutputStream outputStream = new DataOutputStream((OutputStream)messageOutputStream);
        try {
            outputStream.write(this.serverProtocolVersion);
            PackedInteger.writePackedInteger((DataOutput)outputStream, (int)this.supportedMarshallingStrategies.length);
            for (int i = 0; i < this.supportedMarshallingStrategies.length; ++i) {
                outputStream.writeUTF(this.supportedMarshallingStrategies[i]);
            }
        }
        finally {
            channelAssociation.releaseChannelMessageOutputStream(messageOutputStream);
            outputStream.close();
        }
    }

    public InjectedValue<ExecutorService> getExecutorService() {
        return this.executorService;
    }

    public Injector<DeploymentRepository> getDeploymentRepositoryInjector() {
        return this.deploymentRepositoryInjectedValue;
    }

    public Injector<EJBRemoteTransactionsRepository> getEJBRemoteTransactionsRepositoryInjector() {
        return this.ejbRemoteTransactionsRepositoryInjectedValue;
    }

    public Injector<RegistryCollector> getClusterRegistryCollectorInjector() {
        return this.clusterRegistryCollector;
    }

    public Injector<ServerEnvironment> getServerEnvironmentInjector() {
        return this.serverEnvironment;
    }

    public Injector<RemoteAsyncInvocationCancelStatusService> getAsyncInvocationCancelStatusInjector() {
        return this.remoteAsyncInvocationCancelStatus;
    }

    private boolean isSupportedMarshallingStrategy(String strategy) {
        return Arrays.asList(this.supportedMarshallingStrategies).contains(strategy);
    }

    private MarshallerFactory getMarshallerFactory(String marshallerStrategy) {
        MarshallerFactory marshallerFactory = Marshalling.getProvidedMarshallerFactory((String)marshallerStrategy);
        if (marshallerFactory == null) {
            throw EjbMessages.MESSAGES.failedToFindMarshallerFactoryForStrategy(marshallerStrategy);
        }
        return marshallerFactory;
    }

    private class ClientVersionMessageReceiver
    implements Channel.Receiver {
        private final ServiceContainer serviceContainer;
        private final ChannelAssociation channelAssociation;

        ClientVersionMessageReceiver(ServiceContainer serviceContainer, ChannelAssociation channelAssociation) {
            this.serviceContainer = serviceContainer;
            this.channelAssociation = channelAssociation;
        }

        public void handleError(Channel channel, IOException error) {
            EjbLogger.EJB3_LOGGER.closingChannel(channel, error);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void handleEnd(Channel channel) {
            EjbLogger.EJB3_LOGGER.closingChannelOnChannelEnd(channel);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dataInputStream = new DataInputStream((InputStream)messageInputStream);
            try {
                byte version = dataInputStream.readByte();
                String clientMarshallingStrategy = dataInputStream.readUTF();
                EjbLogger.ROOT_LOGGER.debug("Client with protocol version " + version + " and marshalling strategy " + clientMarshallingStrategy + " trying to communicate on " + channel);
                if (!EJBRemoteConnectorService.this.isSupportedMarshallingStrategy(clientMarshallingStrategy)) {
                    EjbLogger.EJB3_LOGGER.unsupportedClientMarshallingStrategy(clientMarshallingStrategy, channel);
                    channel.close();
                    return;
                }
                switch (version) {
                    case 1: {
                        MarshallerFactory marshallerFactory = EJBRemoteConnectorService.this.getMarshallerFactory(clientMarshallingStrategy);
                        DeploymentRepository deploymentRepository = (DeploymentRepository)EJBRemoteConnectorService.this.deploymentRepositoryInjectedValue.getValue();
                        RegistryCollector clientMappingRegistryCollector = (RegistryCollector)EJBRemoteConnectorService.this.clusterRegistryCollector.getValue();
                        RemoteAsyncInvocationCancelStatusService asyncInvocationCancelStatus = (RemoteAsyncInvocationCancelStatusService)EJBRemoteConnectorService.this.remoteAsyncInvocationCancelStatus.getValue();
                        VersionOneProtocolChannelReceiver receiver = new VersionOneProtocolChannelReceiver(this.channelAssociation, deploymentRepository, (EJBRemoteTransactionsRepository)EJBRemoteConnectorService.this.ejbRemoteTransactionsRepositoryInjectedValue.getValue(), (RegistryCollector<String, List<ClientMapping>>)clientMappingRegistryCollector, marshallerFactory, (ExecutorService)EJBRemoteConnectorService.this.executorService.getValue(), asyncInvocationCancelStatus);
                        receiver.startReceiving();
                        return;
                    }
                    default: {
                        throw EjbMessages.MESSAGES.ejbRemoteServiceCannotHandleClientVersion(version);
                    }
                }
            }
            catch (IOException e) {
                EjbLogger.ROOT_LOGGER.exceptionOnChannel(e, channel, messageInputStream);
                IoUtils.safeClose((Closeable)channel);
                return;
            }
            finally {
                IoUtils.safeClose((Closeable)messageInputStream);
            }
        }
    }

    private class ChannelOpenListener
    implements OpenListener {
        private final ServiceContainer serviceContainer;

        ChannelOpenListener(ServiceContainer serviceContainer) {
            this.serviceContainer = serviceContainer;
        }

        public void channelOpened(Channel channel) {
            ChannelAssociation channelAssociation = new ChannelAssociation(channel);
            EjbLogger.ROOT_LOGGER.tracef("Welcome %s to the jboss.ejb channel", channel);
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    EjbLogger.ROOT_LOGGER.tracef("channel %s closed", closed);
                }
            });
            try {
                EJBRemoteConnectorService.this.sendVersionMessage(channelAssociation);
            }
            catch (IOException e) {
                EjbLogger.EJB3_LOGGER.closingChannel(channel, e);
                IoUtils.safeClose((Closeable)channel);
            }
            channel.receiveMessage((Channel.Receiver)new ClientVersionMessageReceiver(this.serviceContainer, channelAssociation));
        }

        public void registrationTerminated() {
        }
    }
}

