/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.jaxb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBMarshaller {
    private static Log logger = LogFactory.getLog(JAXBMarshaller.class);
    public static final String PACKAGE_UDDIAPI = "org.uddi.api_v3";
    public static final String PACKAGE_SUBSCRIPTION = "org.uddi.sub_v3";
    public static final String PACKAGE_JUDDIAPI = "org.apache.juddi.api_v3";
    public static final String PACKAGE_JUDDI = "org.apache.juddi";
    private static final Map<String, JAXBContext> JAXBContexts = new HashMap<String, JAXBContext>();

    private static JAXBContext getContext(String packageName) {
        if (!JAXBContexts.containsKey(packageName)) {
            try {
                JAXBContexts.put(packageName, JAXBContext.newInstance((String)packageName));
            }
            catch (JAXBException e) {
                logger.error((Object)("Initialization of JAXBMarshaller failed:" + (Object)((Object)e)), (Throwable)e);
                throw new ExceptionInInitializerError(e);
            }
        }
        return JAXBContexts.get(packageName);
    }

    public static Object unmarshallFromInputStream(InputStream inputStream, String thePackage) throws JAXBException {
        Object obj = null;
        if (inputStream != null) {
            JAXBContext jc = JAXBMarshaller.getContext(thePackage);
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            obj = ((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
        } else {
            logger.error((Object)"A null input stream was provided");
        }
        return obj;
    }

    public static Object unmarshallFromFileResource(String fileName, String thePackage) throws JAXBException, IOException {
        Object obj = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (url == null) {
            logger.error((Object)("Could not find resource: " + fileName));
        } else {
            InputStream resourceStream = url.openStream();
            obj = JAXBMarshaller.unmarshallFromInputStream(resourceStream, thePackage);
        }
        return obj;
    }

    public static Object unmarshallFromString(String rawObject, String thePackage) throws JAXBException {
        Object obj = null;
        if (rawObject != null && rawObject.length() > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(rawObject.getBytes());
            obj = JAXBMarshaller.unmarshallFromInputStream(bais, thePackage);
        } else {
            logger.error((Object)"The raw object provided is null or empty");
        }
        return obj;
    }

    public static String marshallToString(Object object, String thePackage) {
        String rawObject = null;
        try {
            JAXBContext jc = JAXBMarshaller.getContext(thePackage);
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)baos);
            rawObject = baos.toString();
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return rawObject;
    }

    public static Element marshallToElement(Object object, String thePackage, Element element) throws JAXBException {
        JAXBContext jc = JAXBMarshaller.getContext(thePackage);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal(object, (Node)element);
        return element;
    }

    public static Object unmarshallFromElement(Element element, String thePackage) throws JAXBException {
        JAXBContext jc = JAXBMarshaller.getContext(thePackage);
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object obj = ((JAXBElement)unmarshaller.unmarshal((Node)element)).getValue();
        return obj;
    }
}

