/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logmanager;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.logmanager.HandlerConfigurationImpl;
import org.jboss.as.logging.logmanager.LogContextConfigurationImpl;
import org.jboss.as.logging.resolvers.FileResolver;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;

public final class ConfigurationPersistence
implements Configurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String ENCODING = "utf-8";
    private static final Object PROP_CONFIG_LOCK = new Object();
    private static final String PROPERTIES_FILE = "logging.properties";
    private static final byte[] NOTE_MESSAGE = String.format("# Note this file has been generated and will be overwritten if a%n# logging subsystem has been defined in the XML configuration.%n%n", new Object[0]).getBytes();
    private final LogContextConfigurationImpl config;

    public ConfigurationPersistence() {
        this(LogContext.getSystemLogContext());
    }

    public ConfigurationPersistence(LogContext logContext) {
        this.config = new LogContextConfigurationImpl(logContext);
    }

    public static ConfigurationPersistence getOrCreateConfigurationPersistence() {
        return ConfigurationPersistence.getOrCreateConfigurationPersistence(LogContext.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationPersistence getOrCreateConfigurationPersistence(LogContext logContext) {
        Logger root;
        ConfigurationPersistence result = (ConfigurationPersistence)logContext.getAttachment("", Configurator.ATTACHMENT_KEY);
        if (result == null && (result = (ConfigurationPersistence)(root = logContext.getLogger("")).getAttachment(Configurator.ATTACHMENT_KEY)) == null) {
            Object object = PROP_CONFIG_LOCK;
            synchronized (object) {
                ConfigurationPersistence current;
                result = (ConfigurationPersistence)logContext.getAttachment("", Configurator.ATTACHMENT_KEY);
                if (result == null) {
                    result = (ConfigurationPersistence)root.getAttachment(Configurator.ATTACHMENT_KEY);
                }
                if (result == null && (current = (ConfigurationPersistence)root.attachIfAbsent(Configurator.ATTACHMENT_KEY, (Object)(result = new ConfigurationPersistence(logContext)))) != null) {
                    result = current;
                }
            }
        }
        return result;
    }

    public static ConfigurationPersistence getConfigurationPersistence(LogContext logContext) {
        if (logContext == null) {
            return null;
        }
        return (ConfigurationPersistence)logContext.getAttachment("", Configurator.ATTACHMENT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream, ENCODING));
            inputStream.close();
        }
        finally {
            ConfigurationPersistence.safeClose(inputStream);
        }
        this.configure(properties);
    }

    public void prepare() {
        this.config.prepare();
    }

    public void commit() {
        this.config.commit();
    }

    public void rollback() {
        this.config.forget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogContextConfiguration getLogContextConfiguration() {
        LogContextConfigurationImpl logContextConfigurationImpl = this.config;
        synchronized (logContextConfigurationImpl) {
            return this.config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(OperationContext context) {
        String loggingConfig;
        switch (context.getProcessType()) {
            case DOMAIN_SERVER: {
                loggingConfig = FileResolver.resolvePath(context, "jboss.server.data.dir", PROPERTIES_FILE);
                break;
            }
            default: {
                loggingConfig = FileResolver.resolvePath(context, "jboss.server.config.dir", PROPERTIES_FILE);
            }
        }
        if (loggingConfig == null) {
            LoggingLogger.ROOT_LOGGER.pathManagerServiceNotStarted();
        } else {
            File configFile = new File(loggingConfig);
            LogContextConfigurationImpl logContextConfigurationImpl = this.config;
            synchronized (logContextConfigurationImpl) {
                try {
                    this.config.commit();
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(configFile);
                        out.write(NOTE_MESSAGE);
                        this.writeConfiguration(out);
                        out.close();
                        LoggingLogger.ROOT_LOGGER.tracef("Logging configuration file '%s' successfully written.", configFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        try {
                            throw LoggingMessages.MESSAGES.failedToWriteConfigurationFile(e, configFile);
                        }
                        catch (Throwable throwable) {
                            ConfigurationPersistence.safeClose(out);
                            throw throwable;
                        }
                    }
                    ConfigurationPersistence.safeClose(out);
                }
                finally {
                    this.config.forget();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfiguration(OutputStream outputStream) throws IOException {
        try {
            PrintStream out = new PrintStream(outputStream, true, ENCODING);
            try {
                HashSet<String> implicitHandlers = new HashSet<String>();
                HashSet<String> implicitFormatters = new HashSet<String>();
                HashSet<String> implicitErrorManagers = new HashSet<String>();
                List<String> loggerNames = this.config.getLoggerNames();
                ConfigurationPersistence.writePropertyComment(out, "Additional loggers to configure (the root logger is always configured)");
                ConfigurationPersistence.writeProperty(out, "loggers", ConfigurationPersistence.toCsvString(loggerNames));
                LoggerConfiguration rootLogger = this.config.getLoggerConfiguration("");
                ConfigurationPersistence.writeLoggerConfiguration(out, rootLogger, implicitHandlers);
                loggerNames.remove("");
                for (String loggerName : loggerNames) {
                    ConfigurationPersistence.writeLoggerConfiguration(out, this.config.getLoggerConfiguration(loggerName), implicitHandlers);
                }
                List<String> allHandlerNames = this.config.getHandlerNames();
                ArrayList<String> explicitHandlerNames = new ArrayList<String>(allHandlerNames);
                explicitHandlerNames.removeAll(implicitHandlers);
                if (!explicitHandlerNames.isEmpty()) {
                    ConfigurationPersistence.writePropertyComment(out, "Additional handlers to configure");
                    ConfigurationPersistence.writeProperty(out, "handlers", ConfigurationPersistence.toCsvString(explicitHandlerNames));
                    out.println();
                }
                for (String handlerName : allHandlerNames) {
                    ConfigurationPersistence.writeHandlerConfiguration(out, this.config.getHandlerConfiguration(handlerName), implicitHandlers, implicitFormatters, implicitErrorManagers);
                }
                List<String> allFilterNames = this.config.getFilterNames();
                if (!allFilterNames.isEmpty()) {
                    ConfigurationPersistence.writePropertyComment(out, "Additional filters to configure");
                    ConfigurationPersistence.writeProperty(out, "filters", ConfigurationPersistence.toCsvString(allFilterNames));
                    out.println();
                }
                for (String filterName : allFilterNames) {
                    ConfigurationPersistence.writeFilterConfiguration(out, this.config.getFilterConfiguration(filterName));
                }
                List<String> allFormatterNames = this.config.getFormatterNames();
                ArrayList<String> explicitFormatterNames = new ArrayList<String>(allFormatterNames);
                explicitFormatterNames.removeAll(implicitFormatters);
                if (!explicitFormatterNames.isEmpty()) {
                    ConfigurationPersistence.writePropertyComment(out, "Additional formatters to configure");
                    ConfigurationPersistence.writeProperty(out, "formatters", ConfigurationPersistence.toCsvString(explicitFormatterNames));
                    out.println();
                }
                for (String formatterName : allFormatterNames) {
                    ConfigurationPersistence.writeFormatterConfiguration(out, this.config.getFormatterConfiguration(formatterName));
                }
                List<String> allErrorManagerNames = this.config.getErrorManagerNames();
                ArrayList<String> explicitErrorManagerNames = new ArrayList<String>(allErrorManagerNames);
                explicitErrorManagerNames.removeAll(implicitErrorManagers);
                if (!explicitErrorManagerNames.isEmpty()) {
                    ConfigurationPersistence.writePropertyComment(out, "Additional errorManagers to configure");
                    ConfigurationPersistence.writeProperty(out, "errorManagers", ConfigurationPersistence.toCsvString(explicitErrorManagerNames));
                    out.println();
                }
                for (String errorManagerName : allErrorManagerNames) {
                    ConfigurationPersistence.writeErrorManagerConfiguration(out, this.config.getErrorManagerConfiguration(errorManagerName));
                }
                out.close();
            }
            finally {
                ConfigurationPersistence.safeClose(out);
            }
            outputStream.close();
        }
        finally {
            ConfigurationPersistence.safeClose(outputStream);
        }
    }

    private static void writeLoggerConfiguration(PrintStream out, LoggerConfiguration logger2, Set<String> implicitHandlers) throws IOException {
        if (logger2 != null) {
            List handlerNames;
            Boolean useParentHandlers;
            String filterName;
            out.println();
            String name = logger2.getName();
            String prefix = name.isEmpty() ? "logger." : "logger." + name + ".";
            String level = logger2.getLevel();
            if (level != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "level", level);
            }
            if ((filterName = logger2.getFilter()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "filter", filterName);
            }
            if ((useParentHandlers = logger2.getUseParentHandlers()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "useParentHandlers", useParentHandlers.toString());
            }
            if (!(handlerNames = logger2.getHandlerNames()).isEmpty()) {
                ConfigurationPersistence.writeProperty(out, prefix, "handlers", ConfigurationPersistence.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
        }
    }

    private static void writeHandlerConfiguration(PrintStream out, HandlerConfiguration handler, Set<String> implicitHandlers, Set<String> implicitFormatters, Set<String> implicitErrorManagers) throws IOException {
        if (handler != null) {
            List handlerNames;
            String errorManagerName;
            String formatterName;
            String filter;
            String encoding;
            String level;
            out.println();
            if (handler instanceof HandlerConfigurationImpl && ((HandlerConfigurationImpl)handler).isLog4jAppender()) {
                out.println("# Note: This is a log4j appender and will not work with normal log managers.");
                out.println("#       References to this appender should be removed if a different log manager is used.");
            }
            String name = handler.getName();
            String prefix = "handler." + name + ".";
            String className = handler.getClassName();
            ConfigurationPersistence.writeProperty(out, "handler.", name, className);
            String moduleName = handler.getModuleName();
            if (moduleName != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "module", moduleName);
            }
            if ((level = handler.getLevel()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "level", level);
            }
            if ((encoding = handler.getEncoding()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "encoding", encoding);
            }
            if ((filter = handler.getFilter()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "filter", filter);
            }
            if ((formatterName = handler.getFormatterName()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "formatter", formatterName);
                implicitFormatters.add(formatterName);
            }
            if ((errorManagerName = handler.getErrorManagerName()) != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "errorManager", errorManagerName);
                implicitErrorManagers.add(errorManagerName);
            }
            if (!(handlerNames = handler.getHandlerNames()).isEmpty()) {
                ConfigurationPersistence.writeProperty(out, prefix, "handlers", ConfigurationPersistence.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
            ConfigurationPersistence.writeProperties(out, prefix, (PropertyConfigurable)handler);
        }
    }

    private static void writeFilterConfiguration(PrintStream out, FilterConfiguration filter) throws IOException {
        if (filter != null) {
            out.println();
            String name = filter.getName();
            String prefix = "filter." + name + ".";
            String className = filter.getClassName();
            ConfigurationPersistence.writeProperty(out, "filter.", name, className);
            String moduleName = filter.getModuleName();
            if (moduleName != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "module", moduleName);
            }
            ConfigurationPersistence.writeProperties(out, prefix, (PropertyConfigurable)filter);
        }
    }

    private static void writeFormatterConfiguration(PrintStream out, FormatterConfiguration formatter) throws IOException {
        if (formatter != null) {
            out.println();
            String name = formatter.getName();
            String prefix = "formatter." + name + ".";
            String className = formatter.getClassName();
            ConfigurationPersistence.writeProperty(out, "formatter.", name, className);
            String moduleName = formatter.getModuleName();
            if (moduleName != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "module", moduleName);
            }
            ConfigurationPersistence.writeProperties(out, prefix, (PropertyConfigurable)formatter);
        }
    }

    private static void writeErrorManagerConfiguration(PrintStream out, ErrorManagerConfiguration errorManager) throws IOException {
        if (errorManager != null) {
            out.println();
            String name = errorManager.getName();
            String prefix = "errorManager." + name + ".";
            String className = errorManager.getClassName();
            ConfigurationPersistence.writeProperty(out, "errorManager.", name, className);
            String moduleName = errorManager.getModuleName();
            if (moduleName != null) {
                ConfigurationPersistence.writeProperty(out, prefix, "module", moduleName);
            }
            ConfigurationPersistence.writeProperties(out, prefix, (PropertyConfigurable)errorManager);
        }
    }

    private static void writePropertyComment(PrintStream out, String comment) {
        out.printf("%n# %s%n", comment);
    }

    private static void writeProperty(PrintStream out, String name, String value) throws IOException {
        ConfigurationPersistence.writeProperty(out, null, name, value);
    }

    private static void writeProperty(PrintStream out, String prefix, String name, String value) throws IOException {
        if (prefix == null) {
            ConfigurationPersistence.writeKey(out, name);
        } else {
            ConfigurationPersistence.writeKey(out, String.format("%s%s", prefix, name));
        }
        ConfigurationPersistence.writeValue(out, value);
        out.println();
    }

    private static void writeProperties(PrintStream out, String prefix, PropertyConfigurable propertyConfigurable) throws IOException {
        block6: {
            List names = propertyConfigurable.getPropertyNames();
            if (names.isEmpty()) break block6;
            List ctorProps = propertyConfigurable.getConstructorProperties();
            if (prefix == null) {
                ConfigurationPersistence.writeProperty(out, "properties", ConfigurationPersistence.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    ConfigurationPersistence.writeProperty(out, "constructorProperties", ConfigurationPersistence.toCsvString(ctorProps));
                }
                for (String name : names) {
                    ConfigurationPersistence.writeProperty(out, name, propertyConfigurable.getPropertyValueString(name));
                }
            } else {
                ConfigurationPersistence.writeProperty(out, prefix, "properties", ConfigurationPersistence.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    ConfigurationPersistence.writeProperty(out, prefix, "constructorProperties", ConfigurationPersistence.toCsvString(ctorProps));
                }
                for (String name : names) {
                    ConfigurationPersistence.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueString(name));
                }
            }
        }
    }

    private static String toCsvString(List<String> names) {
        StringBuilder result = new StringBuilder(1024);
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (name.isEmpty()) continue;
            result.append(name);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Properties properties) throws IOException {
        LogContextConfigurationImpl logContextConfigurationImpl = this.config;
        synchronized (logContextConfigurationImpl) {
            try {
                this.configureLogger(properties, "");
                for (String loggerName : ConfigurationPersistence.getStringCsvArray(properties, "loggers")) {
                    this.configureLogger(properties, loggerName);
                }
                for (String handlerName : ConfigurationPersistence.getStringCsvArray(properties, "handlers")) {
                    this.configureHandler(properties, handlerName);
                }
                for (String filterName : ConfigurationPersistence.getStringCsvArray(properties, "filters")) {
                    this.configureFilter(properties, filterName);
                }
                for (String formatterName : ConfigurationPersistence.getStringCsvArray(properties, "formatters")) {
                    this.configureFormatter(properties, formatterName);
                }
                for (String errorManagerName : ConfigurationPersistence.getStringCsvArray(properties, "errorManagers")) {
                    this.configureErrorManager(properties, errorManagerName);
                }
                this.config.commit();
            }
            finally {
                this.config.forget();
            }
        }
    }

    private void configureLogger(Properties properties, String loggerName) throws IOException {
        String filterName;
        if (this.config.getLoggerConfiguration(loggerName) != null) {
            return;
        }
        LoggerConfiguration loggerConfiguration = this.config.addLoggerConfiguration(loggerName);
        String levelName = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            loggerConfiguration.setLevel(levelName);
        }
        if ((filterName = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("logger", loggerName, "filter"))) != null) {
            loggerConfiguration.setFilter(filterName);
        }
        String[] handlerNames = ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("logger", loggerName, "handlers"));
        loggerConfiguration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        String useParentHandlersString = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("logger", loggerName, "useParentHandlers"));
        if (useParentHandlersString != null) {
            loggerConfiguration.setUseParentHandlers(Boolean.valueOf(Boolean.parseBoolean(useParentHandlersString)));
        }
    }

    private void configureFilter(Properties properties, String filterName) throws IOException {
        if (this.config.getFilterConfiguration(filterName) != null) {
            return;
        }
        FilterConfiguration configuration = this.config.addFilterConfiguration(ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("filter", filterName, "module")), ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("filter", filterName)), filterName, ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("filter", filterName, "constructorProperties")));
        this.configureProperties(properties, (PropertyConfigurable)configuration, ConfigurationPersistence.getKey("filter", filterName));
    }

    private void configureFormatter(Properties properties, String formatterName) throws IOException {
        if (this.config.getFormatterConfiguration(formatterName) != null) {
            return;
        }
        FormatterConfiguration configuration = this.config.addFormatterConfiguration(ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("formatter", formatterName, "module")), ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("formatter", formatterName)), formatterName, ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("formatter", formatterName, "constructorProperties")));
        this.configureProperties(properties, (PropertyConfigurable)configuration, ConfigurationPersistence.getKey("formatter", formatterName));
    }

    private void configureErrorManager(Properties properties, String errorManagerName) throws IOException {
        if (this.config.getErrorManagerConfiguration(errorManagerName) != null) {
            return;
        }
        ErrorManagerConfiguration configuration = this.config.addErrorManagerConfiguration(ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("errorManager", errorManagerName, "module")), ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("errorManager", errorManagerName)), errorManagerName, ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("errorManager", errorManagerName, "constructorProperties")));
        this.configureProperties(properties, (PropertyConfigurable)configuration, ConfigurationPersistence.getKey("errorManager", errorManagerName));
    }

    private void configureHandler(Properties properties, String handlerName) throws IOException {
        String errorManagerName;
        String encoding;
        String formatterName;
        String levelName;
        if (this.config.getHandlerConfiguration(handlerName) != null) {
            return;
        }
        HandlerConfiguration configuration = this.config.addHandlerConfiguration(ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "module")), ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName)), handlerName, ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("handler", handlerName, "constructorProperties")));
        String filter = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "filter"));
        if (filter != null) {
            configuration.setFilter(filter);
        }
        if ((levelName = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "level"))) != null) {
            configuration.setLevel(levelName);
        }
        if ((formatterName = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "formatter"))) != null) {
            configuration.setFormatterName(formatterName);
            this.configureFormatter(properties, formatterName);
        }
        if ((encoding = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "encoding"))) != null) {
            configuration.setEncoding(encoding);
        }
        if ((errorManagerName = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey("handler", handlerName, "errorManager"))) != null) {
            configuration.setErrorManagerName(errorManagerName);
            this.configureErrorManager(properties, errorManagerName);
        }
        String[] handlerNames = ConfigurationPersistence.getStringCsvArray(properties, ConfigurationPersistence.getKey("handler", handlerName, "handlers"));
        configuration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        this.configureProperties(properties, (PropertyConfigurable)configuration, ConfigurationPersistence.getKey("handler", handlerName));
    }

    private void configureProperties(Properties properties, PropertyConfigurable configurable, String prefix) throws IOException {
        List<String> propertyNames = ConfigurationPersistence.getStringCsvList(properties, ConfigurationPersistence.getKey(prefix, "properties"));
        for (String propertyName : propertyNames) {
            String valueString = ConfigurationPersistence.getStringProperty(properties, ConfigurationPersistence.getKey(prefix, propertyName));
            if (valueString == null) continue;
            configurable.setPropertyValueString(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        return properties.getProperty(key);
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String property = properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(ConfigurationPersistence.getStringCsvArray(properties, key)));
    }

    private static void writeValue(PrintStream out, String value) throws IOException {
        ConfigurationPersistence.writeSanitized(out, value, false);
    }

    private static void writeKey(PrintStream out, String key) throws IOException {
        ConfigurationPersistence.writeSanitized(out, key, true);
        out.append('=');
    }

    private static void writeSanitized(Appendable out, String string, boolean escapeSpaces) throws IOException {
        block8: for (int x = 0; x < string.length(); ++x) {
            char c = string.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpaces) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LoggingLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }
}

