/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.logging.AbstractHandlerDefinition;
import org.jboss.as.logging.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.CustomHandlerResourceDefinition;
import org.jboss.as.logging.FileHandlerResourceDefinition;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.LoggingRootResource;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.Namespace;
import org.jboss.as.logging.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.RootLoggerResourceDefinition;
import org.jboss.as.logging.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.stdio.LogContextStdioContextSelector;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.ContextClassLoaderLogContextSelector;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.LogManager;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public class LoggingExtension
implements Extension {
    private static final String RESOURCE_NAME = LoggingExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final String SUBSYSTEM_NAME = "logging";
    static final PathElement LOGGING_PROFILE_PATH = PathElement.pathElement((String)"logging-profile");
    static final ContextClassLoaderLogContextSelector CONTEXT_SELECTOR = new ContextClassLoaderLogContextSelector();
    static final GenericSubsystemDescribeHandler DESCRIBE_HANDLER = GenericSubsystemDescribeHandler.create((Comparator)LoggingChildResourceComparator.INSTANCE);
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new LoggingResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, LoggingExtension.class.getClassLoader());
    }

    public void initialize(ExtensionContext context) {
        if (!java.util.logging.LogManager.getLogManager().getClass().getName().equals(LogManager.class.getName())) {
            throw LoggingMessages.MESSAGES.extensionNotInitialized();
        }
        LogContext.setLogContextSelector((LogContextSelector)CONTEXT_SELECTOR);
        StdioContext.setStdioContextSelector((StdioContextSelector)new LogContextStdioContextSelector(StdioContext.getStdioContext()));
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)LoggingRootResource.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)DESCRIBE_HANDLER);
        ResolvePathHandler resolvePathHandler = context.getProcessType().isServer() ? ResolvePathHandler.Builder.of((PathManager)context.getPathManager()).setParentAttribute((AttributeDefinition)CommonAttributes.FILE).build() : null;
        this.registerSubModels(registration, resolvePathHandler, true);
        this.registerSubModels(registration.registerSubModel((ResourceDefinition)new SimpleResourceDefinition(LOGGING_PROFILE_PATH, (ResourceDescriptionResolver)LoggingExtension.getResourceDescriptionResolver(new String[0]), LoggingProfileOperations.ADD_PROFILE, LoggingProfileOperations.REMOVE_PROFILE)), resolvePathHandler, false);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
        subsystem.registerXMLElementWriter((XMLElementWriter)LoggingSubsystemParser.INSTANCE);
    }

    private void registerTransformers(SubsystemRegistration subsystem) {
        TransformersSubRegistration reg = subsystem.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0), new ResourceTransformer(){

            public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
                childContext.processChildren(resource);
            }
        });
        this.registerTransformersSubModels(reg, reg.registerSubResource(LOGGING_PROFILE_PATH, true));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.readable()) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUriString(), (XMLElementReader)LoggingSubsystemParser.INSTANCE);
        }
    }

    private void registerSubModels(ManagementResourceRegistration registration, ResolvePathHandler resolvePathHandler, boolean includeLegacyAttributes) {
        registration.registerSubModel((ResourceDefinition)new RootLoggerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new LoggerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new AsyncHandlerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new ConsoleHandlerResourceDefinition(includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new FileHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new PeriodicHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new SizeRotatingHandlerResourceDefinition(resolvePathHandler, includeLegacyAttributes));
        registration.registerSubModel((ResourceDefinition)new CustomHandlerResourceDefinition(includeLegacyAttributes));
    }

    private void registerTransformersSubModels(TransformersSubRegistration registration, TransformersSubRegistration loggingProfileReg) {
        this.registerTransformersSubModels(registration, loggingProfileReg, RootLoggerResourceDefinition.ROOT_LOGGER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC}), "add", "set-root-logger", "write-attribute", "add-handler", "remove-handler");
        this.registerTransformersSubModels(registration, loggingProfileReg, LoggerResourceDefinition.LOGGER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.CATEGORY, CommonAttributes.FILTER_SPEC}), "add", "write-attribute", "add-handler", "remove-handler");
        this.registerTransformersSubModels(registration, loggingProfileReg, AsyncHandlerResourceDefinition.ASYNC_HANDLER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties", "add-handler", "remove-handler");
        this.registerTransformersSubModels(registration, loggingProfileReg, ConsoleHandlerResourceDefinition.CONSOLE_HANDLER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties");
        this.registerTransformersSubModels(registration, loggingProfileReg, FileHandlerResourceDefinition.FILE_HANDLER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties");
        this.registerTransformersSubModels(registration, loggingProfileReg, PeriodicHandlerResourceDefinition.PERIODIC_HANDLER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties");
        this.registerTransformersSubModels(registration, loggingProfileReg, SizeRotatingHandlerResourceDefinition.SIZE_ROTATING_HANDLER_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.NAME, CommonAttributes.FILTER_SPEC, CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties");
        this.registerTransformersSubModels(registration, loggingProfileReg, CustomHandlerResourceDefinition.CUSTOM_HANDLE_PATH, new LoggingResourceTransformer(new AttributeDefinition[]{CommonAttributes.ENABLED}), "add", "write-attribute", "update-properties");
    }

    private void registerTransformersSubModels(TransformersSubRegistration registration, TransformersSubRegistration loggingProfileReg, PathElement pathElement, ResourceTransformer transformer, String ... operationNames) {
        TransformersSubRegistration reg = registration.registerSubResource(pathElement, transformer != null ? transformer : ResourceTransformer.DEFAULT);
        for (String operationName : operationNames) {
            reg.registerOperationTransformer(operationName, (OperationTransformer)LoggingOperationTransformer.INSTANCE);
        }
        loggingProfileReg.registerSubResource(pathElement, true);
    }

    private static String fixFormatPattern(String currentPattern) {
        return currentPattern.replaceAll("(%K\\{[a-zA-Z]*?})", "");
    }

    private static class LoggingResourceTransformer
    implements ResourceTransformer {
        AttributeDefinition[] removableAttributes;

        public LoggingResourceTransformer(AttributeDefinition ... removableAttributes) {
            this.removableAttributes = removableAttributes;
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            this.doTransform(context, address, resource);
            ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
            childContext.processChildren(resource);
        }

        void doTransform(ResourceTransformationContext context, PathAddress address, Resource resource) {
            ModelNode model = resource.getModel();
            for (AttributeDefinition attribute : this.removableAttributes) {
                if (!model.has(attribute.getName())) continue;
                model.remove(attribute.getName());
            }
            if (model.hasDefined(CommonAttributes.LEVEL.getName()) && model.get(CommonAttributes.LEVEL.getName()).asString().equals("ALL")) {
                model.remove(CommonAttributes.LEVEL.getName());
            }
            if (model.hasDefined(CommonAttributes.FORMATTER.getName())) {
                String currentPattern = model.get(CommonAttributes.FORMATTER.getName()).asString();
                model.get(CommonAttributes.FORMATTER.getName()).set(LoggingExtension.fixFormatPattern(currentPattern));
            }
        }
    }

    public static class LoggingChildResourceComparator
    implements Comparator<PathElement> {
        static final LoggingChildResourceComparator INSTANCE = new LoggingChildResourceComparator();
        static final int GREATER = 1;
        static final int EQUAL = 0;
        static final int LESS = -1;

        @Override
        public int compare(PathElement o1, PathElement o2) {
            String key2;
            String key1 = o1.getKey();
            int result = key1.compareTo(key2 = o2.getKey());
            if (result != 0) {
                if ("subsystem".equals(key1)) {
                    result = -1;
                } else if ("subsystem".equals(key2)) {
                    result = 1;
                } else if ("logging-profile".equals(key1)) {
                    result = -1;
                } else if ("logging-profile".equals(key2)) {
                    result = 1;
                } else if ("root-logger".equals(key1)) {
                    result = 1;
                } else if ("root-logger".equals(key2)) {
                    result = -1;
                } else if ("logger".equals(key1)) {
                    result = 1;
                } else if ("logger".equals(key2)) {
                    result = -1;
                } else if ("async-handler".equals(key1)) {
                    result = 1;
                } else if ("async-handler".equals(key2)) {
                    result = -1;
                }
            }
            return result;
        }
    }

    private static class LoggingResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private static final Map<String, String> COMMON_ATTRIBUTE_NAMES = new HashMap<String, String>();

        public LoggingResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
            super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName.split("\\.")[0])) {
                return bundle2.getString(this.getBundleKey(attributeName));
            }
            return super.getResourceAttributeDescription(attributeName, locale, bundle2);
        }

        public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
            }
            return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getBundleKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
        }

        public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
            }
            return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
        }

        public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(paramName)) {
                if (this.isReuseAttributesForAdd()) {
                    return bundle2.getString(this.getVariableBundleKey(paramName, "deprecated"));
                }
                return bundle2.getString(this.getVariableBundleKey(operationName, paramName, "deprecated"));
            }
            return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle2);
        }

        public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
            if (COMMON_ATTRIBUTE_NAMES.containsKey(attributeName)) {
                return bundle2.getString(this.getVariableBundleKey(attributeName, "deprecated"));
            }
            return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle2);
        }

        private String getBundleKey(String name) {
            return this.getVariableBundleKey(name, new String[0]);
        }

        private String getVariableBundleKey(String name, String ... variable) {
            String prefix = COMMON_ATTRIBUTE_NAMES.get(name.split("\\.")[0]);
            StringBuilder sb = prefix == null ? new StringBuilder(name) : new StringBuilder(prefix).append('.').append(name);
            if (variable != null) {
                for (String arg : variable) {
                    if (sb.length() > 0) {
                        sb.append('.');
                    }
                    sb.append(arg);
                }
            }
            return sb.toString();
        }

        static {
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.APPEND.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.AUTOFLUSH.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.CLASS.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENABLED.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ENCODING.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILE.getName(), "logging.handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FILTER_SPEC.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.FORMATTER.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.HANDLERS.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.LEVEL.getName(), "logging.common");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.MAX_BACKUP_INDEX.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.MODULE.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.OVERFLOW_ACTION.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.PATH.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.PROPERTIES.getName(), "logging.custom-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.QUEUE_LENGTH.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(PathResourceDefinition.RELATIVE_TO.getName(), null);
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.ROTATE_SIZE.getName(), "logging.size-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.SUBHANDLERS.getName(), "logging.async-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.SUFFIX.getName(), "logging.periodic-rotating-file-handler");
            COMMON_ATTRIBUTE_NAMES.put(CommonAttributes.TARGET.getName(), "logging.console-handler");
        }
    }

    private static class LoggingOperationTransformer
    extends AbstractOperationTransformer {
        static final LoggingOperationTransformer INSTANCE = new LoggingOperationTransformer();

        private LoggingOperationTransformer() {
        }

        protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
            String key = address.getLastElement().getKey();
            String name = address.getLastElement().getValue();
            String operationName = operation.get("operation").asString();
            if (operationName.equals("add-handler")) {
                if (key.equals("root-logger")) {
                    operation.get("operation").set("root-logger-assign-handler");
                } else if (key.equals("logger")) {
                    operation.get("operation").set("assign-handler");
                } else if (key.equals("async-handler")) {
                    operation.get("operation").set("assign-subhandler");
                }
            } else if (operationName.equals("remove-handler")) {
                if (key.equals("root-logger")) {
                    operation.get("operation").set("root-logger-unassign-handler");
                } else if (key.equals("logger")) {
                    operation.get("operation").set("unassign-handler");
                } else if (key.equals("async-handler")) {
                    operation.get("operation").set("unassign-subhandler");
                }
            } else if (operationName.equals("write-attribute")) {
                String attributeName = operation.get("name").asString();
                if (attributeName.equals(CommonAttributes.FORMATTER.getName())) {
                    String currentPattern = operation.get("value").asString();
                    operation.get("value").set(LoggingExtension.fixFormatPattern(currentPattern));
                } else if (attributeName.equals(CommonAttributes.FILTER_SPEC.getName())) {
                    operation.get("name").set(CommonAttributes.FILTER.getName());
                    String filterExpression = operation.get("value").asString();
                    operation.get("value").set(Filters.filterSpecToFilter(filterExpression));
                } else if (attributeName.equals(CommonAttributes.ENABLED.getName())) {
                    boolean enabled = operation.get("value").asBoolean();
                    if (enabled) {
                        operation.get("operation").set(AbstractHandlerDefinition.ENABLE_HANDLER.getName());
                    } else {
                        operation.get("operation").set(AbstractHandlerDefinition.DISABLE_HANDLER.getName());
                    }
                    operation.remove("name");
                    operation.remove("value");
                }
            } else if (operationName.equals("add")) {
                if ("logger".equals(key)) {
                    operation.get(CommonAttributes.CATEGORY.getName()).set(name);
                } else if (!"root-logger".equals(key)) {
                    operation.get(CommonAttributes.NAME.getName()).set(name);
                }
            } else if (operationName.equals("set-root-logger")) {
                operation.remove(CommonAttributes.NAME.getName());
            }
            if (operation.hasDefined(CommonAttributes.FORMATTER.getName())) {
                String currentPattern = operation.get(CommonAttributes.FORMATTER.getName()).asString();
                operation.get(CommonAttributes.FORMATTER.getName()).set(LoggingExtension.fixFormatPattern(currentPattern));
            }
            if (operation.hasDefined(CommonAttributes.FILTER_SPEC.getName())) {
                String filterExpression = operation.get(CommonAttributes.FILTER_SPEC.getName()).asString();
                operation.get(CommonAttributes.FILTER.getName()).set(Filters.filterSpecToFilter(filterExpression));
            }
            operation.remove(CommonAttributes.FILTER_SPEC.getName());
            operation.remove(CommonAttributes.ENABLED.getName());
            return operation;
        }
    }
}

