/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;

final class LoggerOperations {
    static LoggingOperations.LoggingRemoveOperationStepHandler REMOVE_LOGGER = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        public void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.loggerNotFound(loggerName));
            }
            logContextConfiguration.removeLoggerConfiguration(loggerName);
        }
    };
    public static LoggerUpdateOperationStepHandler ADD_HANDLER = new LoggerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            model.get(CommonAttributes.HANDLERS.getName()).add(operation.get(CommonAttributes.HANDLER_NAME.getName()));
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            String handlerName = CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString();
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            if (configuration.getHandlerNames().contains(handlerName)) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
            }
            LoggingLogger.ROOT_LOGGER.tracef("Adding handler '%s' to logger '%s' at '%s'", handlerName, LoggerOperations.getLogManagerLoggerName(loggerName), LoggingOperations.getAddress(operation));
            configuration.addHandlerName(handlerName);
        }
    };
    public static LoggerUpdateOperationStepHandler REMOVE_HANDLER = new LoggerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.HANDLER_NAME.validateAndSet(operation, model);
            String handlerName = model.get(CommonAttributes.HANDLER_NAME.getName()).asString();
            boolean found = false;
            List handlers = model.get(CommonAttributes.HANDLERS.getName()).asList();
            ArrayList<ModelNode> newHandlers = new ArrayList<ModelNode>(handlers.size());
            for (ModelNode handler : handlers) {
                if (handlerName.equals(handler.asString())) {
                    found = true;
                    continue;
                }
                newHandlers.add(handler);
            }
            if (found) {
                model.get(CommonAttributes.HANDLERS.getName()).set(newHandlers);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            configuration.removeHandlerName(CommonAttributes.HANDLER_NAME.resolveModelAttribute(context, model).asString());
        }
    };
    public static LoggerUpdateOperationStepHandler CHANGE_LEVEL = new LoggerUpdateOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            CommonAttributes.LEVEL.validateAndSet(operation, model);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LoggerConfiguration configuration, String name, ModelNode model) throws OperationFailedException {
            LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, model, configuration);
        }
    };

    LoggerOperations() {
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration) throws OperationFailedException {
        LoggerOperations.handleProperty(attribute, context, model, configuration, true);
    }

    private static void handleProperty(AttributeDefinition attribute, OperationContext context, ModelNode model, LoggerConfiguration configuration, boolean resolveValue) throws OperationFailedException {
        if (CommonAttributes.FILTER_SPEC.equals(attribute)) {
            ModelNode valueNode = resolveValue ? CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model) : model;
            String resolvedValue = valueNode.isDefined() ? valueNode.asString() : null;
            configuration.setFilter(resolvedValue);
        } else if (CommonAttributes.LEVEL.equals(attribute)) {
            String resolvedValue = resolveValue ? CommonAttributes.LEVEL.resolvePropertyValue(context, model) : CommonAttributes.LEVEL.resolver().resolveValue(context, model);
            configuration.setLevel(resolvedValue);
        } else if (CommonAttributes.HANDLERS.equals(attribute)) {
            Set<String> resolvedValue = resolveValue ? CommonAttributes.HANDLERS.resolvePropertyValue(context, model) : CommonAttributes.HANDLERS.resolver().resolveValue(context, model);
            configuration.setHandlerNames(resolvedValue);
        } else if (CommonAttributes.USE_PARENT_HANDLERS.equals(attribute)) {
            ModelNode useParentHandlers = resolveValue ? CommonAttributes.USE_PARENT_HANDLERS.resolveModelAttribute(context, model) : model;
            Boolean resolvedValue = useParentHandlers.isDefined() ? Boolean.valueOf(useParentHandlers.asBoolean()) : null;
            configuration.setUseParentHandlers(resolvedValue);
        }
    }

    private static String getLogManagerLoggerName(String name) {
        return name.equals("ROOT") ? "" : name;
    }

    public static class LoggerWriteAttributeHandler
    extends LoggingOperations.LoggingWriteAttributeHandler {
        protected LoggerWriteAttributeHandler(AttributeDefinition[] attributes) {
            super(attributes);
        }

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(addressName);
            if (logContextConfiguration.getLoggerNames().contains(loggerName)) {
                LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
                if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.LEVEL, context, value, configuration, false);
                } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (CommonAttributes.FILTER_SPEC.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.FILTER_SPEC, context, value, configuration, false);
                } else if (CommonAttributes.HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.HANDLERS, context, value, configuration, false);
                } else if (CommonAttributes.USE_PARENT_HANDLERS.getName().equals(attributeName)) {
                    LoggerOperations.handleProperty((AttributeDefinition)CommonAttributes.USE_PARENT_HANDLERS, context, value, configuration, false);
                }
            }
            return false;
        }
    }

    static final class LoggerAddOperationStepHandler
    extends LoggingOperations.LoggingAddOperationStepHandler {
        private final AttributeDefinition[] attributes;

        LoggerAddOperationStepHandler(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                if (CommonAttributes.FILTER.equals(attribute)) {
                    ModelNode filter = CommonAttributes.FILTER.validateOperation(operation);
                    if (!filter.isDefined()) continue;
                    String value = Filters.filterToFilterSpec(filter);
                    model.get(CommonAttributes.FILTER_SPEC.getName()).set(value);
                    continue;
                }
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding logger '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                configuration = logContextConfiguration.addLoggerConfiguration(loggerName);
            }
            for (AttributeDefinition attribute : this.attributes) {
                LoggerOperations.handleProperty(attribute, context, model, configuration);
            }
        }
    }

    static abstract class LoggerUpdateOperationStepHandler
    extends LoggingOperations.LoggingUpdateOperationStepHandler {
        LoggerUpdateOperationStepHandler() {
        }

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }

        @Override
        public final void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            String loggerName = LoggerOperations.getLogManagerLoggerName(name);
            LoggerConfiguration configuration = logContextConfiguration.getLoggerConfiguration(loggerName);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingMessages.MESSAGES.loggerConfigurationNotFound(loggerName));
            }
            this.performRuntime(context, operation, configuration, loggerName, model);
        }

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LoggerConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }
}

