/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.CaseParameterCorrector;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.LogHandlerListAttributeDefinition;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.PropertyObjectTypeAttributeDefinition;
import org.jboss.as.logging.Target;
import org.jboss.as.logging.correctors.FileCorrector;
import org.jboss.as.logging.resolvers.FileResolver;
import org.jboss.as.logging.resolvers.LevelResolver;
import org.jboss.as.logging.resolvers.OverflowActionResolver;
import org.jboss.as.logging.resolvers.SizeResolver;
import org.jboss.as.logging.resolvers.TargetResolver;
import org.jboss.as.logging.validators.FileValidator;
import org.jboss.as.logging.validators.LogLevelValidator;
import org.jboss.as.logging.validators.SizeValidator;
import org.jboss.as.logging.validators.SuffixValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.handlers.AsyncHandler;

public interface CommonAttributes {
    public static final PropertyAttributeDefinition APPEND = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("append", ModelType.BOOLEAN, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(true))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final String ASYNC_HANDLER = "async-handler";
    public static final PropertyAttributeDefinition AUTOFLUSH = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("autoflush", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setPropertyName("autoFlush").build();
    public static final SimpleAttributeDefinition CATEGORY = SimpleAttributeDefinitionBuilder.create((String)"category", (ModelType)ModelType.STRING, (boolean)true).build();
    public static final SimpleAttributeDefinition CLASS = SimpleAttributeDefinitionBuilder.create((String)"class", (ModelType)ModelType.STRING).setAllowExpression(false).build();
    public static final String CONSOLE_HANDLER = "console-handler";
    public static final String CUSTOM_HANDLER = "custom-handler";
    public static final PropertyAttributeDefinition ENABLED = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).build();
    public static final PropertyAttributeDefinition ENCODING = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("encoding", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).build();
    public static final String FILE_HANDLER = "file-handler";
    public static final PropertyAttributeDefinition FILTER_SPEC = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("filter-spec", ModelType.STRING, true).addAlternatives(new String[]{"filter"})).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).build();
    public static final PropertyAttributeDefinition FORMATTER = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("formatter", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                writer.writeStartElement(CommonAttributes.PATTERN_FORMATTER);
                String content = resourceModel.get(attribute.getName()).asString();
                writer.writeAttribute(PATTERN.getXmlName(), content);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    })).setDefaultValue(new ModelNode("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%E%n"))).build();
    public static final SimpleAttributeDefinition HANDLER = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"handler", (ModelType)ModelType.STRING).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).build();
    public static final LogHandlerListAttributeDefinition HANDLERS = ((LogHandlerListAttributeDefinition.Builder)LogHandlerListAttributeDefinition.Builder.of("handlers").setAllowNull(true)).build();
    public static final SimpleAttributeDefinition HANDLER_NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).build();
    public static final PropertyAttributeDefinition LEVEL = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("level", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).setCorrector(CaseParameterCorrector.TO_UPPER)).setDefaultValue(new ModelNode(Level.ALL.getName()))).setResolver(LevelResolver.INSTANCE).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final String LOGGER = "logger";
    public static final String LOGGING_PROFILE = "logging-profile";
    public static final String LOGGING_PROFILES = "logging-profiles";
    public static final PropertyAttributeDefinition MAX_BACKUP_INDEX = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("max-backup-index", ModelType.INT, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(1))).setPropertyName("maxBackupIndex").setValidator((ParameterValidator)new IntRangeValidator(1, true))).build();
    public static final SimpleAttributeDefinition MODULE = SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setAllowExpression(false).build();
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0))).build();
    public static final PropertyAttributeDefinition OVERFLOW_ACTION = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("overflow-action", ModelType.STRING).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                String content = resourceModel.get(attribute.getName()).asString().toLowerCase(Locale.ENGLISH);
                writer.writeAttribute("value", content);
                writer.writeEndElement();
            }
        }
    })).setDefaultValue(new ModelNode(AsyncHandler.OverflowAction.BLOCK.name()))).setPropertyName("overflowAction").setResolver(OverflowActionResolver.INSTANCE).setValidator((ParameterValidator)EnumValidator.create(AsyncHandler.OverflowAction.class, (boolean)false, (boolean)false))).build();
    public static final String PATTERN_FORMATTER = "pattern-formatter";
    public static final String PERIODIC_ROTATING_FILE_HANDLER = "periodic-rotating-file-handler";
    public static final SimpleMapAttributeDefinition PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("properties", true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            resourceModel = resourceModel.get(attribute.getName());
            writer.writeStartElement(attribute.getName());
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute("name", property.asProperty().getName());
                writer.writeAttribute("value", property.asProperty().getValue().asString());
            }
            writer.writeEndElement();
        }
    })).build();
    public static final PropertyAttributeDefinition QUEUE_LENGTH = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("queue-length", ModelType.INT).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setPropertyName("queueLength").setValidator((ParameterValidator)new IntRangeValidator(1, false))).build();
    public static final String ROOT_LOGGER = "root-logger";
    public static final String ROOT_LOGGER_ATTRIBUTE_NAME = "ROOT";
    public static final PropertyAttributeDefinition ROTATE_SIZE = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("rotate-size", ModelType.STRING).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode("2m"))).setPropertyName("rotateSize").setResolver(SizeResolver.INSTANCE).setValidator((ParameterValidator)new SizeValidator())).build();
    public static final String SIZE_ROTATING_FILE_HANDLER = "size-rotating-file-handler";
    public static final LogHandlerListAttributeDefinition SUBHANDLERS = ((LogHandlerListAttributeDefinition.Builder)LogHandlerListAttributeDefinition.Builder.of("subhandlers").setAllowNull(true)).build();
    public static final PropertyAttributeDefinition SUFFIX = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("suffix", ModelType.STRING).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setValidator((ParameterValidator)new SuffixValidator())).build();
    public static final PropertyAttributeDefinition TARGET = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("target", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).setDefaultValue(new ModelNode(Target.SYSTEM_OUT.toString()))).setResolver(TargetResolver.INSTANCE).setValidator((ParameterValidator)EnumValidator.create(Target.class, (boolean)true, (boolean)false))).build();
    public static final PropertyAttributeDefinition USE_PARENT_HANDLERS = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("use-parent-handlers", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setPropertyName("useParentHandlers").build();
    public static final PropertyObjectTypeAttributeDefinition FILE = ((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)PropertyObjectTypeAttributeDefinition.Builder.of("file", new AttributeDefinition[]{PathResourceDefinition.RELATIVE_TO, PathResourceDefinition.PATH}).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                ModelNode file = resourceModel.get(attribute.getName());
                PathResourceDefinition.RELATIVE_TO.marshallAsAttribute(file, marshallDefault, writer);
                PathResourceDefinition.PATH.marshallAsAttribute(file, marshallDefault, writer);
                writer.writeEndElement();
            }
        }
    })).setCorrector(FileCorrector.INSTANCE)).setPropertyName("fileName").setResolver(FileResolver.INSTANCE).setValidator((ParameterValidator)new FileValidator())).build();
    public static final String ROOT_LOGGER_NAME = "";
    public static final SimpleAttributeDefinition ACCEPT = SimpleAttributeDefinitionBuilder.create((String)"accept", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition CHANGE_LEVEL = SimpleAttributeDefinitionBuilder.create((String)"change-level", (ModelType)ModelType.STRING, (boolean)true).setCorrector(CaseParameterCorrector.TO_UPPER).setValidator((ParameterValidator)new LogLevelValidator(true)).build();
    public static final SimpleAttributeDefinition DENY = SimpleAttributeDefinitionBuilder.create((String)"deny", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition MATCH = SimpleAttributeDefinitionBuilder.create((String)"match", (ModelType)ModelType.STRING, (boolean)true).build();
    public static final SimpleAttributeDefinition MAX_INCLUSIVE = SimpleAttributeDefinitionBuilder.create((String)"max-inclusive", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition MAX_LEVEL = SimpleAttributeDefinitionBuilder.create((String)"max-level", (ModelType)ModelType.STRING, (boolean)true).setCorrector(CaseParameterCorrector.TO_UPPER).setValidator((ParameterValidator)new LogLevelValidator(true)).build();
    public static final SimpleAttributeDefinition MIN_INCLUSIVE = SimpleAttributeDefinitionBuilder.create((String)"min-inclusive", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition MIN_LEVEL = SimpleAttributeDefinitionBuilder.create((String)"min-level", (ModelType)ModelType.STRING, (boolean)true).setCorrector(CaseParameterCorrector.TO_UPPER).setValidator((ParameterValidator)new LogLevelValidator(true)).build();
    public static final SimpleAttributeDefinition NEW_LEVEL = SimpleAttributeDefinitionBuilder.create((String)"new-level", (ModelType)ModelType.STRING, (boolean)true).setCorrector(CaseParameterCorrector.TO_UPPER).setValidator((ParameterValidator)new LogLevelValidator(true)).build();
    public static final SimpleAttributeDefinition PATTERN = SimpleAttributeDefinitionBuilder.create((String)"pattern", (ModelType)ModelType.STRING).build();
    public static final SimpleAttributeDefinition REPLACEMENT = SimpleAttributeDefinitionBuilder.create((String)"replacement", (ModelType)ModelType.STRING).build();
    public static final SimpleAttributeDefinition REPLACE_ALL = SimpleAttributeDefinitionBuilder.create((String)"replace-all", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(true)).build();
    public static final ObjectTypeAttributeDefinition LEVEL_RANGE_LEGACY = ObjectTypeAttributeDefinition.Builder.of((String)"level-range", (AttributeDefinition[])new AttributeDefinition[]{MIN_LEVEL, MIN_INCLUSIVE, MAX_LEVEL, MAX_INCLUSIVE}).setAllowNull(true).build();
    public static final ObjectTypeAttributeDefinition REPLACE = ObjectTypeAttributeDefinition.Builder.of((String)"replace", (AttributeDefinition[])new AttributeDefinition[]{PATTERN, REPLACEMENT, REPLACE_ALL}).setAllowNull(true).build();
    public static final ObjectTypeAttributeDefinition NOT = ObjectTypeAttributeDefinition.Builder.of((String)"not", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, REPLACE}).setAllowNull(true).build();
    public static final ObjectTypeAttributeDefinition ALL = ObjectTypeAttributeDefinition.Builder.of((String)"all", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).setAllowNull(true).build();
    public static final ObjectTypeAttributeDefinition ANY = ObjectTypeAttributeDefinition.Builder.of((String)"any", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).setAllowNull(true).build();
    public static final ObjectTypeAttributeDefinition FILTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"filter", (AttributeDefinition[])new AttributeDefinition[]{ALL, ANY, ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).addAlternatives(new String[]{FILTER_SPEC.getName()})).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0))).setAllowNull(true).build();
    public static final String ADD_HANDLER_OPERATION_NAME = "add-handler";
    public static final String REMOVE_HANDLER_OPERATION_NAME = "remove-handler";
}

