/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.CommonAttributes;

enum Attribute {
    UNKNOWN((String)null),
    APPEND((AttributeDefinition)CommonAttributes.APPEND),
    AUTOFLUSH((AttributeDefinition)CommonAttributes.AUTOFLUSH),
    CATEGORY((AttributeDefinition)CommonAttributes.CATEGORY),
    CLASS((AttributeDefinition)CommonAttributes.CLASS),
    ENABLED((AttributeDefinition)CommonAttributes.ENABLED),
    MIN_INCLUSIVE((AttributeDefinition)CommonAttributes.MIN_INCLUSIVE),
    MIN_LEVEL((AttributeDefinition)CommonAttributes.MIN_LEVEL),
    MAX_BACKUP_INDEX((AttributeDefinition)CommonAttributes.MAX_BACKUP_INDEX),
    MAX_INCLUSIVE((AttributeDefinition)CommonAttributes.MAX_INCLUSIVE),
    MAX_LEVEL((AttributeDefinition)CommonAttributes.MAX_LEVEL),
    MODULE((AttributeDefinition)CommonAttributes.MODULE),
    NAME("name"),
    NEW_LEVEL((AttributeDefinition)CommonAttributes.NEW_LEVEL),
    OVERFLOW_ACTION((AttributeDefinition)CommonAttributes.OVERFLOW_ACTION),
    PATH((AttributeDefinition)PathResourceDefinition.PATH),
    PATTERN((AttributeDefinition)CommonAttributes.PATTERN),
    QUEUE_LENGTH((AttributeDefinition)CommonAttributes.QUEUE_LENGTH),
    RELATIVE_TO((AttributeDefinition)PathResourceDefinition.RELATIVE_TO),
    REPLACEMENT((AttributeDefinition)CommonAttributes.REPLACEMENT),
    REPLACE_ALL((AttributeDefinition)CommonAttributes.REPLACE_ALL),
    ROTATE_SIZE((AttributeDefinition)CommonAttributes.ROTATE_SIZE),
    SUFFIX((AttributeDefinition)CommonAttributes.SUFFIX),
    TARGET((AttributeDefinition)CommonAttributes.TARGET),
    USE_PARENT_HANDLERS((AttributeDefinition)CommonAttributes.USE_PARENT_HANDLERS),
    VALUE("value");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> MAP;

    private Attribute(AttributeDefinition definition) {
        this.name = definition == null ? null : definition.getXmlName();
        this.definition = definition;
    }

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public static Map<String, Attribute> getMap() {
        return MAP;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

