/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.AbstractConnectionMap;
import org.jgroups.blocks.Connection;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class TCPConnectionMap {
    protected final Mapper mapper;
    protected final InetAddress bind_addr;
    protected InetAddress client_bind_addr;
    protected int client_bind_port;
    protected final Address local_addr;
    protected final ServerSocket srv_sock;
    protected Receiver receiver;
    protected final long conn_expire_time;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected int recv_buf_size = 120000;
    protected int send_buf_size = 60000;
    protected int send_queue_size = 0;
    protected int sock_conn_timeout = 1000;
    protected boolean tcp_nodelay = false;
    protected int linger = -1;
    protected final Thread acceptor;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected volatile boolean use_send_queues = false;
    protected SocketFactory socket_factory = new DefaultSocketFactory();

    public TCPConnectionMap(String service_name, ThreadFactory f, SocketFactory socket_factory, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, ThreadGroup group) throws Exception {
        this(service_name, f, socket_factory, r, bind_addr, external_addr, external_port, srv_port, max_port, 0L, 0L, group);
    }

    public TCPConnectionMap(String service_name, ThreadFactory f, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time, ThreadGroup group) throws Exception {
        this(service_name, f, null, r, bind_addr, external_addr, external_port, srv_port, max_port, reaper_interval, conn_expire_time, group);
    }

    public TCPConnectionMap(String service_name, ThreadFactory f, SocketFactory socket_factory, Receiver r, InetAddress bind_addr, InetAddress external_addr, int external_port, int srv_port, int max_port, long reaper_interval, long conn_expire_time, ThreadGroup group) throws Exception {
        this.mapper = new Mapper(f, reaper_interval);
        this.receiver = r;
        this.bind_addr = bind_addr;
        this.conn_expire_time = conn_expire_time;
        if (socket_factory != null) {
            this.socket_factory = socket_factory;
        }
        this.srv_sock = Util.createServerSocket(this.socket_factory, service_name, bind_addr, srv_port, max_port);
        this.local_addr = external_addr != null ? (external_port <= 0 ? new IpAddress(external_addr, this.srv_sock.getLocalPort()) : new IpAddress(external_addr, external_port)) : (bind_addr != null ? new IpAddress(bind_addr, this.srv_sock.getLocalPort()) : new IpAddress(this.srv_sock.getLocalPort()));
        this.acceptor = f.newThread(new ConnectionAcceptor(), "ConnectionMap.Acceptor");
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.socket_factory = factory;
    }

    public InetAddress clientBindAddress() {
        return this.client_bind_addr;
    }

    public TCPConnectionMap clientBindAddress(InetAddress addr) {
        this.client_bind_addr = addr;
        return this;
    }

    public int clientBindPort() {
        return this.client_bind_port;
    }

    public TCPConnectionMap clientBindPort(int port) {
        this.client_bind_port = port;
        return this;
    }

    public void addConnectionMapListener(AbstractConnectionMap.ConnectionMapListener<TCPConnection> l) {
        this.mapper.addConnectionMapListener(l);
    }

    public void removeConnectionMapListener(AbstractConnectionMap.ConnectionMapListener<TCPConnection> l) {
        this.mapper.removeConnectionMapListener(l);
    }

    public void receive(Address sender, byte[] data, int offset, int length) {
        this.receiver.receive(sender, data, offset, length);
    }

    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("destination is null");
            }
            return;
        }
        if (data == null) {
            this.log.warn("data is null; discarding packet");
            return;
        }
        if (!this.running.get()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connection table is not running, discarding message to " + dest);
            }
            return;
        }
        if (dest.equals(this.local_addr)) {
            this.receive(this.local_addr, data, offset, length);
            return;
        }
        TCPConnection conn = this.mapper.getConnection(dest);
        if (conn != null) {
            try {
                conn.send(data, offset, length);
            }
            catch (Exception ex) {
                this.mapper.removeConnection(dest);
                throw ex;
            }
        }
    }

    public void start() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            this.acceptor.start();
            this.mapper.start();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                this.getSocketFactory().close(this.srv_sock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Util.interruptAndWaitToDie(this.acceptor);
            this.mapper.stop();
        }
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        block7: {
            block6: {
                try {
                    client_sock.setSendBufferSize(this.send_buf_size);
                }
                catch (IllegalArgumentException ex) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes", ex);
                }
            }
            try {
                client_sock.setReceiveBufferSize(this.recv_buf_size);
            }
            catch (IllegalArgumentException ex) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes", ex);
            }
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.tcp_nodelay);
        if (this.linger > 0) {
            client_sock.setSoLinger(true, this.linger);
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    public void setReceiveBufferSize(int recv_buf_size) {
        this.recv_buf_size = recv_buf_size;
    }

    public void setSocketConnectionTimeout(int sock_conn_timeout) {
        this.sock_conn_timeout = sock_conn_timeout;
    }

    public void setSendBufferSize(int send_buf_size) {
        this.send_buf_size = send_buf_size;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setTcpNodelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
    }

    public void setSendQueueSize(int send_queue_size) {
        this.send_queue_size = send_queue_size;
    }

    public void setUseSendQueues(boolean use_send_queues) {
        this.use_send_queues = use_send_queues;
    }

    public int getNumConnections() {
        return this.mapper.getNumConnections();
    }

    public boolean connectionEstablishedTo(Address addr) {
        return this.mapper.connectionEstablishedTo(addr);
    }

    public String printConnections() {
        return this.mapper.printConnections();
    }

    public void retainAll(Collection<Address> members) {
        this.mapper.retainAll(members);
    }

    public long getConnectionExpiryTimeout() {
        return this.conn_expire_time;
    }

    public int getSenderQueueSize() {
        return this.send_queue_size;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("local_addr=" + this.local_addr).append("\n");
        ret.append("connections (" + this.mapper.size() + "):\n");
        ret.append(this.mapper.toString());
        ret.append('\n');
        return ret.toString();
    }

    protected class Mapper
    extends AbstractConnectionMap<TCPConnection> {
        public Mapper(ThreadFactory factory) {
            super(factory);
        }

        public Mapper(ThreadFactory factory, long reaper_interval) {
            super(factory, reaper_interval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TCPConnection getConnectionUnderLock(Address dest) throws Exception {
            TCPConnection conn;
            this.getLock().lock();
            try {
                conn = (TCPConnection)this.conns.get(dest);
            }
            finally {
                this.getLock().unlock();
            }
            if (conn != null && conn.isOpen()) {
                return conn;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TCPConnection getConnection(Address dest) throws Exception {
            TCPConnection conn;
            block14: {
                conn = this.getConnectionUnderLock(dest);
                if (conn != null) {
                    return conn;
                }
                this.sock_creation_lock.lockInterruptibly();
                try {
                    conn = this.getConnectionUnderLock(dest);
                    if (conn != null) {
                        TCPConnection tCPConnection = conn;
                        return tCPConnection;
                    }
                    conn = new TCPConnection(dest);
                    conn.start(this.getThreadFactory());
                    this.addConnection(dest, conn);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("created socket to " + dest);
                    }
                }
                catch (Exception ex) {
                    TCPConnection existing;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("failed creating connection to " + dest);
                    }
                    if (conn == null) break block14;
                    this.getLock().lock();
                    try {
                        existing = (TCPConnection)this.conns.get(dest);
                        if (existing == null) {
                            this.removeConnection(dest);
                        }
                    }
                    finally {
                        this.getLock().unlock();
                    }
                    Util.close(conn);
                    conn = existing;
                }
                finally {
                    this.sock_creation_lock.unlock();
                }
            }
            return conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean connectionEstablishedTo(Address address) {
            this.lock.lock();
            try {
                TCPConnection conn = (TCPConnection)this.conns.get(address);
                boolean bl = conn != null && conn.isConnected();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public int size() {
            return this.conns.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.getLock().lock();
            try {
                for (Map.Entry entry : this.conns.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                String string = sb.toString();
                return string;
            }
            finally {
                this.getLock().unlock();
            }
        }
    }

    public class TCPConnection
    implements Connection {
        protected final Socket sock;
        protected final Lock send_lock = new ReentrantLock();
        protected final Log log = LogFactory.getLog(this.getClass());
        protected final byte[] cookie = new byte[]{98, 101, 108, 97};
        protected final DataOutputStream out;
        protected final DataInputStream in;
        protected final Address peer_addr;
        protected final int peer_addr_read_timeout = 2000;
        protected long last_access = System.currentTimeMillis();
        protected Sender sender;
        protected ConnectionPeerReceiver connectionPeerReceiver;
        protected final AtomicBoolean active = new AtomicBoolean(false);

        TCPConnection(Address peer_addr) throws Exception {
            if (peer_addr == null) {
                throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
            }
            InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)peer_addr).getIpAddress(), ((IpAddress)peer_addr).getPort());
            this.sock = TCPConnectionMap.this.socket_factory.createSocket("jgroups.tcp.sock");
            try {
                this.sock.bind(new InetSocketAddress(TCPConnectionMap.this.client_bind_addr, TCPConnectionMap.this.client_bind_port));
                if (this.sock.getLocalSocketAddress().equals(destAddr)) {
                    throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
                }
                Util.connect(this.sock, destAddr, TCPConnectionMap.this.sock_conn_timeout);
            }
            catch (Exception t) {
                TCPConnectionMap.this.socket_factory.close(this.sock);
                throw t;
            }
            TCPConnectionMap.this.setSocketParameters(this.sock);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.sendLocalAddress(TCPConnectionMap.this.getLocalAddress());
            this.peer_addr = peer_addr;
        }

        TCPConnection(Socket s) throws Exception {
            if (s == null) {
                throw new IllegalArgumentException("Invalid parameter s=" + s);
            }
            TCPConnectionMap.this.setSocketParameters(s);
            this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
            this.peer_addr = this.readPeerAddress(s);
            this.sock = s;
        }

        protected Address getPeerAddress() {
            return this.peer_addr;
        }

        protected void updateLastAccessed() {
            this.last_access = System.currentTimeMillis();
        }

        protected void start(ThreadFactory f) {
            if (this.active.compareAndSet(false, true)) {
                this.connectionPeerReceiver = new ConnectionPeerReceiver(f);
                this.connectionPeerReceiver.start();
                if (this.isSenderUsed()) {
                    this.sender = new Sender(f, TCPConnectionMap.this.getSenderQueueSize());
                    this.sender.start();
                }
            }
        }

        protected boolean isSenderUsed() {
            return TCPConnectionMap.this.getSenderQueueSize() > 0 && TCPConnectionMap.this.use_send_queues;
        }

        protected String getSockAddress() {
            StringBuilder sb = new StringBuilder();
            if (this.sock != null) {
                sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
                sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
            }
            return sb.toString();
        }

        protected void send(byte[] data, int offset, int length) throws Exception {
            if (this.isSenderUsed()) {
                byte[] tmp = new byte[length];
                System.arraycopy(data, offset, tmp, 0, length);
                this.sender.addToQueue(tmp);
            } else {
                this._send(data, offset, length, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _send(byte[] data, int offset, int length, boolean acquire_lock) throws Exception {
            if (acquire_lock) {
                this.send_lock.lock();
            }
            try {
                this.doSend(data, offset, length);
                this.updateLastAccessed();
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (acquire_lock) {
                    this.send_lock.unlock();
                }
            }
        }

        protected void doSend(byte[] data, int offset, int length) throws Exception {
            this.out.writeInt(length);
            this.out.write(data, offset, length);
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Address readPeerAddress(Socket client_sock) throws Exception {
            int timeout = client_sock.getSoTimeout();
            client_sock.setSoTimeout(2000);
            try {
                byte[] input_cookie = new byte[this.cookie.length];
                this.in.readFully(input_cookie, 0, input_cookie.length);
                if (!this.matchCookie(input_cookie)) {
                    throw new SocketException("ConnectionMap.Connection.readPeerAddress(): cookie read by " + TCPConnectionMap.this.getLocalAddress() + " does not match own cookie; terminating connection");
                }
                short version = this.in.readShort();
                if (!Version.isBinaryCompatible(version)) {
                    throw new IOException("packet from " + client_sock.getInetAddress() + ":" + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
                }
                IpAddress client_peer_addr = new IpAddress();
                client_peer_addr.readFrom(this.in);
                this.updateLastAccessed();
                IpAddress ipAddress = client_peer_addr;
                return ipAddress;
            }
            finally {
                client_sock.setSoTimeout(timeout);
            }
        }

        protected void sendLocalAddress(Address local_addr) throws Exception {
            this.out.write(this.cookie, 0, this.cookie.length);
            this.out.writeShort(Version.version);
            local_addr.writeTo(this.out);
            this.out.flush();
            this.updateLastAccessed();
        }

        protected boolean matchCookie(byte[] input) {
            if (input == null || input.length < this.cookie.length) {
                return false;
            }
            for (int i = 0; i < this.cookie.length; ++i) {
                if (this.cookie[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            InetAddress local = null;
            InetAddress remote = null;
            Socket tmp_sock = this.sock;
            if (tmp_sock == null) {
                ret.append("<null socket>");
            } else {
                local = tmp_sock.getLocalAddress();
                remote = tmp_sock.getInetAddress();
                String local_str = local != null ? Util.shortName(local) : "<null>";
                String remote_str = remote != null ? Util.shortName(remote) : "<null>";
                ret.append('<' + local_str + ':' + tmp_sock.getLocalPort() + " --> " + remote_str + ':' + tmp_sock.getPort() + "> (" + (System.currentTimeMillis() - this.last_access) / 1000L + " secs old)");
            }
            tmp_sock = null;
            return ret.toString();
        }

        @Override
        public boolean isExpired(long now) {
            return TCPConnectionMap.this.getConnectionExpiryTimeout() > 0L && now - this.last_access >= TCPConnectionMap.this.getConnectionExpiryTimeout();
        }

        public boolean isConnected() {
            return !this.sock.isClosed() && this.sock.isConnected();
        }

        @Override
        public boolean isOpen() {
            return this.isConnected() && (!this.isSenderUsed() || this.sender.isRunning()) && this.connectionPeerReceiver != null && this.connectionPeerReceiver.isRunning();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.send_lock.lock();
            try {
                this.connectionPeerReceiver.stop();
                if (this.isSenderUsed()) {
                    this.sender.stop();
                }
                try {
                    TCPConnectionMap.this.socket_factory.close(this.sock);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Util.close(this.out);
                Util.close(this.in);
            }
            finally {
                this.send_lock.unlock();
            }
            TCPConnectionMap.this.mapper.notifyConnectionClosed(this.peer_addr);
        }

        protected class Sender
        implements Runnable {
            final BlockingQueue<byte[]> send_queue;
            final Thread runner;
            protected final AtomicBoolean running = new AtomicBoolean(false);

            public Sender(ThreadFactory tf, int send_queue_size) {
                this.runner = tf.newThread(this, "Connection.Sender [" + TCPConnection.this.getSockAddress() + "]");
                this.send_queue = new LinkedBlockingQueue<byte[]>(send_queue_size);
            }

            public void addToQueue(byte[] data) throws Exception {
                if (this.canRun()) {
                    this.send_queue.put(data);
                }
            }

            public void start() {
                if (this.running.compareAndSet(false, true)) {
                    this.runner.start();
                }
            }

            public void stop() {
                if (this.running.compareAndSet(true, false)) {
                    this.runner.interrupt();
                }
            }

            public boolean isRunning() {
                return this.running.get();
            }

            public boolean canRun() {
                return this.isRunning() && TCPConnection.this.isConnected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    block7: while (true) {
                        while (!Thread.currentThread().isInterrupted() && this.canRun()) {
                            byte[] data = null;
                            try {
                                data = this.send_queue.take();
                            }
                            catch (InterruptedException e) {
                                break block10;
                            }
                            if (data == null) continue;
                            try {
                                TCPConnection.this._send(data, 0, data.length, false);
                                continue block7;
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        break block10;
                        {
                            continue block7;
                            break;
                        }
                        break;
                    }
                    finally {
                        Util.close(TCPConnection.this);
                    }
                }
                if (TCPConnection.this.log.isTraceEnabled()) {
                    TCPConnection.this.log.trace("TCPConnection.Sender thread terminated at " + TCPConnectionMap.this.local_addr);
                }
            }
        }

        protected class ConnectionPeerReceiver
        implements Runnable {
            protected final Thread recv;
            protected final AtomicBoolean receiving = new AtomicBoolean(false);

            public ConnectionPeerReceiver(ThreadFactory f) {
                this.recv = f.newThread(this, "Connection.Receiver [" + TCPConnection.this.getSockAddress() + "]");
            }

            public void start() {
                if (this.receiving.compareAndSet(false, true)) {
                    this.recv.start();
                }
            }

            public void stop() {
                if (this.receiving.compareAndSet(true, false)) {
                    this.recv.interrupt();
                }
            }

            public boolean isRunning() {
                return this.receiving.get();
            }

            public boolean canRun() {
                return this.isRunning() && TCPConnection.this.isConnected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted() && this.canRun()) {
                        try {
                            int len = TCPConnection.this.in.readInt();
                            byte[] buf = new byte[len];
                            TCPConnection.this.in.readFully(buf, 0, len);
                            TCPConnection.this.updateLastAccessed();
                            TCPConnectionMap.this.receiver.receive(TCPConnection.this.peer_addr, buf, 0, len);
                        }
                        catch (OutOfMemoryError mem_ex) {
                            break;
                        }
                        catch (IOException io_ex) {
                            break;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                finally {
                    Util.close(TCPConnection.this);
                }
            }
        }
    }

    protected class ConnectionAcceptor
    implements Runnable {
        protected ConnectionAcceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TCPConnectionMap.this.srv_sock.isClosed() && !Thread.currentThread().isInterrupted()) {
                TCPConnection conn = null;
                Socket client_sock = null;
                try {
                    client_sock = TCPConnectionMap.this.srv_sock.accept();
                    conn = new TCPConnection(client_sock);
                    Address peer_addr = conn.getPeerAddress();
                    TCPConnectionMap.this.mapper.getLock().lock();
                    try {
                        boolean currentConnectionOpen = TCPConnectionMap.this.mapper.hasOpenConnection(peer_addr);
                        boolean replaceWithNewConnection = false;
                        if (currentConnectionOpen) {
                            boolean bl = replaceWithNewConnection = peer_addr.compareTo(TCPConnectionMap.this.local_addr) > 0;
                        }
                        if (!currentConnectionOpen || replaceWithNewConnection) {
                            TCPConnectionMap.this.mapper.removeConnection(peer_addr);
                            TCPConnectionMap.this.mapper.addConnection(peer_addr, conn);
                            conn.start(TCPConnectionMap.this.mapper.getThreadFactory());
                            continue;
                        }
                        Util.close(conn);
                    }
                    finally {
                        TCPConnectionMap.this.mapper.getLock().unlock();
                    }
                }
                catch (SocketException se) {
                    boolean threadExiting;
                    boolean bl = threadExiting = TCPConnectionMap.this.srv_sock.isClosed() || Thread.currentThread().isInterrupted();
                    if (threadExiting) break;
                    if (TCPConnectionMap.this.log.isWarnEnabled()) {
                        TCPConnectionMap.this.log.warn(Util.getMessage("AcceptError", se));
                    }
                    Util.close(conn);
                    Util.close(client_sock);
                }
                catch (Exception ex) {
                    if (TCPConnectionMap.this.log.isWarnEnabled()) {
                        TCPConnectionMap.this.log.warn(Util.getMessage("AcceptError", ex));
                    }
                    Util.close(conn);
                    Util.close(client_sock);
                }
            }
            if (TCPConnectionMap.this.log.isTraceEnabled()) {
                TCPConnectionMap.this.log.trace(Thread.currentThread().getName() + " terminated");
            }
        }
    }

    public static interface Receiver {
        public void receive(Address var1, byte[] var2, int var3, int var4);
    }
}

