/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remotingjmx.MBeanServerManager;
import org.jboss.remotingjmx.WrappedMBeanServerConnection;
import org.jboss.remotingjmx.protocol.v2.Common;
import org.jboss.remotingjmx.protocol.v2.ServerCommon;
import org.jboss.remotingjmx.protocol.v2.ServerProxy;

public class ParameterProxy
extends ServerCommon {
    private static final Logger log = Logger.getLogger(ParameterProxy.class);
    private final Channel channel;
    private final Map<Byte, Common.MessageHandler> registry;
    private final Map<String, String> keyPairs = new HashMap<String, String>();
    private final MBeanServerManager mbeanServerManager;
    private final Executor executor;

    ParameterProxy(Channel channel, MBeanServerManager mbeanServerManager, Executor executor) {
        super(channel, executor);
        this.channel = channel;
        this.executor = executor;
        this.mbeanServerManager = mbeanServerManager;
        this.registry = this.createHandlerRegistry();
    }

    private Map<Byte, Common.MessageHandler> createHandlerRegistry() {
        HashMap<Byte, Common.MessageHandler> registry = new HashMap<Byte, Common.MessageHandler>();
        registry.put((byte)112, new SetKeyPairHandler());
        registry.put((byte)113, new BeginHandler());
        return Collections.unmodifiableMap(registry);
    }

    void start() throws IOException {
        log.debugf("Created connection - ID to be established after parameter negotiation.", new Object[0]);
        this.sendWelcomeMessage();
        this.channel.receiveMessage(new ServerCommon.MessageReciever());
    }

    @Override
    Map<Byte, Common.MessageHandler> getHandlerRegistry() {
        return this.registry;
    }

    @Override
    void end() {
    }

    private class BeginHandler
    extends ServerCommon.MessageHandler {
        private BeginHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("Begin");
            WrappedMBeanServerConnection mbeanServer = ParameterProxy.this.mbeanServerManager.getMBeanServer(ParameterProxy.this.keyPairs);
            if (mbeanServer == null) {
                throw new IOException("No MBeanServer identified from the specified parameters.");
            }
            ServerProxy server = new ServerProxy(ParameterProxy.this.channel, mbeanServer, ParameterProxy.this.executor);
            server.start();
            String connectionId = server.getConnectionId();
            ParameterProxy.this.writeResponse(connectionId, (byte)113, correlationId);
        }

        @Override
        boolean endReceiveLoop() {
            return true;
        }
    }

    private class SetKeyPairHandler
    implements Common.MessageHandler {
        private SetKeyPairHandler() {
        }

        @Override
        public void handle(DataInput input, int correlationId) throws IOException {
            log.trace("SetKeyPair");
            byte paramType = input.readByte();
            if (paramType != 8) {
                throw new IOException("Unexpected paramType");
            }
            String name = input.readUTF();
            paramType = input.readByte();
            if (paramType != 8) {
                throw new IOException("Unexpected paramType");
            }
            String value = input.readUTF();
            ParameterProxy.this.keyPairs.put(name, value);
            ParameterProxy.this.writeResponse((byte)112, correlationId);
        }
    }
}

