/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.jboss.logging.processor.Tools;
import org.jboss.logging.processor.apt.AbstractGenerator;
import org.jboss.logging.processor.apt.ImplementationClassGenerator;
import org.jboss.logging.processor.apt.MessageInterfaceFactory;
import org.jboss.logging.processor.apt.ToolLogger;
import org.jboss.logging.processor.apt.TranslationClassGenerator;
import org.jboss.logging.processor.apt.TranslationFileGenerator;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.Validator;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"debug"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class LoggingToolsProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    private final List<AbstractGenerator> processors = new ArrayList<AbstractGenerator>();
    private ToolLogger logger;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.logger = ToolLogger.getLogger(processingEnv);
        this.processors.add(new ImplementationClassGenerator(processingEnv));
        this.processors.add(new TranslationClassGenerator(processingEnv));
        this.processors.add(new TranslationFileGenerator(processingEnv));
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> supportedOptions = new HashSet<String>();
        SupportedOptions globalOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (globalOptions != null) {
            supportedOptions.addAll(Arrays.asList(globalOptions.value()));
        }
        for (AbstractGenerator generator : this.processors) {
            supportedOptions.addAll(generator.getSupportedOptions());
        }
        return supportedOptions;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean process = true;
        Validator validator = new Validator();
        for (TypeElement typeElement : annotations) {
            try {
                if (!this.isValidAnnotation(typeElement)) continue;
                Set<TypeElement> interfaces = ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(typeElement));
                for (TypeElement interfaceElement : interfaces) {
                    MessageInterface messageInterface = MessageInterfaceFactory.of(this.processingEnv, interfaceElement);
                    Collection<ValidationMessage> validationMessages = validator.validate(messageInterface);
                    block8: for (ValidationMessage message : validationMessages) {
                        Element element = ElementHelper.fromMessageObject(message.getMessageObject());
                        switch (message.type()) {
                            case ERROR: {
                                this.logger.error(element, message.getMessage());
                                process = false;
                                continue block8;
                            }
                            case WARN: {
                                this.logger.warn(element, message.getMessage());
                                continue block8;
                            }
                        }
                        this.logger.note(element, message.getMessage());
                    }
                    if (!process || !interfaceElement.getKind().isInterface() || interfaceElement.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    for (AbstractGenerator processor : this.processors) {
                        this.logger.debug("Executing processor %s", processor.getName());
                        processor.processTypeElement(typeElement, interfaceElement, messageInterface);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error((Element)typeElement, t);
            }
        }
        return process;
    }

    private boolean isValidAnnotation(TypeElement annotation) {
        return Tools.annotations().isValidInterfaceAnnotation(annotation);
    }
}

