/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.version.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.hornetq.core.version.Version;

public class VersionImpl
implements Version,
Serializable {
    private static final long serialVersionUID = -5271227256591080403L;
    private final String versionName;
    private final int majorVersion;
    private final int minorVersion;
    private final int microVersion;
    private final int incrementingVersion;
    private final String versionSuffix;
    private final String nettyVersion;
    private final int[] compatibleVersionList;

    public VersionImpl(String versionName, int majorVersion, int minorVersion, int microVersion, int incrementingVersion, String versionSuffix, String nettyVersion, int[] compatibleVersionList) {
        this.versionName = versionName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.microVersion = microVersion;
        this.incrementingVersion = incrementingVersion;
        this.versionSuffix = versionSuffix;
        this.nettyVersion = nettyVersion;
        this.compatibleVersionList = Arrays.copyOf(compatibleVersionList, compatibleVersionList.length);
    }

    @Override
    public String getFullVersion() {
        return this.majorVersion + "." + this.minorVersion + "." + this.microVersion + "." + this.versionSuffix + " (" + this.versionName + ", " + this.incrementingVersion + ")";
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getMicroVersion() {
        return this.microVersion;
    }

    @Override
    public String getVersionSuffix() {
        return this.versionSuffix;
    }

    @Override
    public int getIncrementingVersion() {
        return this.incrementingVersion;
    }

    @Override
    public String getNettyVersion() {
        return this.nettyVersion;
    }

    @Override
    public boolean isCompatible(int version) {
        for (int element : this.compatibleVersionList) {
            if (element != version) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.compatibleVersionList);
        result = 31 * result + this.incrementingVersion;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.microVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.nettyVersion == null ? 0 : this.nettyVersion.hashCode());
        result = 31 * result + (this.versionName == null ? 0 : this.versionName.hashCode());
        result = 31 * result + (this.versionSuffix == null ? 0 : this.versionSuffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionImpl)) {
            return false;
        }
        VersionImpl other = (VersionImpl)obj;
        if (!Arrays.equals(this.compatibleVersionList, other.compatibleVersionList)) {
            return false;
        }
        if (this.incrementingVersion != other.incrementingVersion) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.microVersion != other.microVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.nettyVersion == null ? other.nettyVersion != null : !this.nettyVersion.equals(other.nettyVersion)) {
            return false;
        }
        if (this.versionName == null ? other.versionName != null : !this.versionName.equals(other.versionName)) {
            return false;
        }
        return !(this.versionSuffix == null ? other.versionSuffix != null : !this.versionSuffix.equals(other.versionSuffix));
    }
}

